/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import java.sql.SQLException;

final class DataCache {
    private int rowCount_;
    private int columnCount_;
    private int rowSize_;
    private byte[] data_;
    private boolean[] nullMap_;
    private int currentRow_ = -1;

    DataCache() {
    }

    byte[] getData() {
        return this.data_;
    }

    int getRowOffset() {
        return this.currentRow_ * this.rowSize_;
    }

    void init(int n, int n2, int n3) {
        this.rowCount_ = n;
        this.columnCount_ = n2;
        this.rowSize_ = n3;
        int n4 = n * n3;
        if (this.data_ == null || this.data_.length < n4) {
            this.data_ = new byte[n4];
        }
        int n5 = n * n2;
        if (this.nullMap_ == null || this.nullMap_.length < n5) {
            this.nullMap_ = new boolean[n5];
        }
        this.currentRow_ = -1;
    }

    void setNull(int n, int n2, boolean bl) {
        int n3 = n * this.columnCount_;
        this.nullMap_[n3 + n2] = bl;
    }

    boolean isNull(int n) throws SQLException {
        if (n < 0 || n >= this.columnCount_) {
            throw new SQLException("Descriptor index (" + n + "/" + this.columnCount_ + ")not valid.");
        }
        int n2 = this.currentRow_ * this.columnCount_;
        return this.nullMap_[n2 + n];
    }

    void setRow(int n, byte[] byArray) {
        int n2 = n * this.rowSize_;
        System.arraycopy(byArray, 0, this.data_, n2, this.rowSize_);
    }

    int getNumRows() {
        return this.rowCount_;
    }

    int getCurrentRow() {
        return this.currentRow_;
    }

    int nextRow() {
        return ++this.currentRow_;
    }
}

