/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program.openlist;

import com.ibm.jtopenlite.command.CommandConnection;
import com.ibm.jtopenlite.command.CommandResult;
import com.ibm.jtopenlite.command.program.openlist.CloseList;
import com.ibm.jtopenlite.command.program.openlist.GetListEntries;
import com.ibm.jtopenlite.command.program.openlist.ListEntryFormat;
import com.ibm.jtopenlite.command.program.openlist.ListFormatListener;
import com.ibm.jtopenlite.command.program.openlist.ListInformation;
import com.ibm.jtopenlite.command.program.openlist.OpenListProgram;
import java.io.IOException;

public class OpenListHandler {
    private final OpenListProgram program_;
    private ListFormatListener listener_;
    private final GetListEntries getEntries_;
    private final CloseList close_ = new CloseList();

    public OpenListHandler(OpenListProgram openListProgram, ListEntryFormat listEntryFormat, ListFormatListener listFormatListener) {
        this.program_ = openListProgram;
        this.listener_ = listFormatListener;
        this.getEntries_ = new GetListEntries();
        this.getEntries_.setFormatter(listEntryFormat);
    }

    public ListFormatListener getFormatListener() {
        return this.listener_;
    }

    public void setFormatListener(ListFormatListener listFormatListener) {
        this.listener_ = listFormatListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CommandConnection commandConnection, int n) throws IOException {
        CommandResult commandResult = commandConnection.call(this.program_);
        if (!commandResult.succeeded()) {
            throw new IOException("Open list failed: " + commandResult.toString());
        }
        ListInformation listInformation = this.program_.getListInformation();
        byte[] byArray = listInformation.getRequestHandle();
        this.close_.setRequestHandle(byArray);
        if (this.listener_ != null) {
            this.listener_.openComplete();
        }
        try {
            int n2 = listInformation.getRecordLength();
            int n3 = 8;
            int n4 = -1;
            this.getEntries_.setLengthOfReceiverVariable(n3);
            this.getEntries_.setRequestHandle(byArray);
            this.getEntries_.setRecordLength(n2);
            this.getEntries_.setNumberOfRecordsToReturn(0);
            this.getEntries_.setStartingRecord(n4);
            this.getEntries_.setFormatListener(null);
            commandResult = commandConnection.call(this.getEntries_);
            if (!commandResult.succeeded()) {
                throw new IOException("Get list entries failed: " + commandResult.toString());
            }
            listInformation = this.getEntries_.getListInformation();
            int n5 = listInformation.getTotalRecords();
            if (this.listener_ != null) {
                this.listener_.totalRecordsInList(n5);
            }
            if ((n3 = n2 * n) <= 0) {
                n3 = 100000;
            }
            n4 = 1;
            this.getEntries_.setLengthOfReceiverVariable(n3);
            this.getEntries_.setNumberOfRecordsToReturn(n);
            this.getEntries_.setStartingRecord(n4);
            this.getEntries_.setFormatListener(this.listener_);
            if (this.listener_ != null) {
                while (!this.listener_.stopProcessing() && n4 <= n5) {
                    commandResult = commandConnection.call(this.getEntries_);
                    if (!commandResult.succeeded()) {
                        throw new IOException("Get objects failed: " + commandResult.toString());
                    }
                    listInformation = this.getEntries_.getListInformation();
                    this.getEntries_.setStartingRecord(n4 += listInformation.getRecordsReturned());
                }
            }
        }
        finally {
            commandConnection.call(this.close_);
        }
    }
}

