/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private String threadName;
    private Future<?> receiverFuture;
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(clientState, in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        methodName = "start";
        this.log.fine(CommsReceiver.CLASS_NAME, "start", "855");
        var4_4 = this.lifecycle;
        synchronized (var4_4) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.receiverFuture = executorService.submit(this);
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
            if (true) ** GOTO lbl23
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var4_5) {
                // empty catch block
            }
lbl23:
            // 3 sources

        } while (!this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop() {
        methodName = "stop";
        var2_2 = this.lifecycle;
        synchronized (var2_2) {
            if (this.receiverFuture != null) {
                this.receiverFuture.cancel(true);
            }
            this.log.fine(CommsReceiver.CLASS_NAME, "stop", "850");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl21
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var2_3) {
                // empty catch block
            }
lbl21:
            // 3 sources

        } while (this.isRunning());
        this.log.fine(CommsReceiver.CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        methodName = "run";
        token = null;
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            this.current_state = State.RUNNING;
        }
        try {
            var4_4 = this.lifecycle;
            synchronized (var4_4) {
                my_target = this.target_state;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 19] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                if (true) ** GOTO lbl123
            }
            do {
                block61: {
                    block60: {
                        try {
                            this.log.fine(CommsReceiver.CLASS_NAME, "run", "852");
                            if (this.in.available() > 0) {
                                var4_4 = this.lifecycle;
                                synchronized (var4_4) {
                                    this.current_state = State.RECEIVING;
                                }
                            }
                            message = this.in.readMqttWireMessage();
                            var5_7 = this.lifecycle;
                            synchronized (var5_7) {
                                this.current_state = State.RUNNING;
                            }
                            if (!(message instanceof MqttAck)) ** GOTO lbl55
                            token = this.tokenStore.getToken(message);
                            if (token != null) {
                                var5_7 = token;
                                synchronized (var5_7) {
                                    this.clientState.notifyReceivedAck((MqttAck)message);
                                    break block60;
                                }
                            }
                            if (message instanceof MqttPubRec || message instanceof MqttPubComp || message instanceof MqttPubAck) {
                                this.log.fine(CommsReceiver.CLASS_NAME, "run", "857");
                            } else {
                                throw new MqttException(6);
lbl55:
                                // 1 sources

                                if (message != null) {
                                    this.clientState.notifyReceivedMsg(message);
                                } else if (!this.clientComms.isConnected() && !this.clientComms.isConnecting()) {
                                    throw new IOException("Connection is lost.");
                                }
                            }
                        }
                        catch (MqttException ex) {
                            this.log.fine(CommsReceiver.CLASS_NAME, "run", "856", null, ex);
                            var5_7 = this.lifecycle;
                            synchronized (var5_7) {
                                this.target_state = State.STOPPED;
                            }
                            this.clientComms.shutdownConnection(token, ex);
                            var7_8 = this.lifecycle;
                            synchronized (var7_8) {
                                this.current_state = State.RUNNING;
                                break block61;
                            }
                        }
                        catch (IOException ioe) {
                            try {
                                this.log.fine(CommsReceiver.CLASS_NAME, "run", "853");
                                if (this.target_state != State.STOPPED) {
                                    var5_7 = this.lifecycle;
                                    synchronized (var5_7) {
                                        this.target_state = State.STOPPED;
                                    }
                                    if (!this.clientComms.isDisconnecting()) {
                                        this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
                                    }
                                }
                                var7_8 = this.lifecycle;
                            }
                            catch (Throwable var6_9) {
                                var7_8 = this.lifecycle;
                                synchronized (var7_8) {
                                    this.current_state = State.RUNNING;
                                }
                                throw var6_9;
                            }
                            synchronized (var7_8) {
                                this.current_state = State.RUNNING;
                                break block61;
                            }
                        }
                    }
                    var7_8 = this.lifecycle;
                    synchronized (var7_8) {
                        this.current_state = State.RUNNING;
                    }
                }
                var4_4 = this.lifecycle;
                synchronized (var4_4) {
                    my_target = this.target_state;
                }
lbl123:
                // 2 sources

            } while (my_target == State.RUNNING && this.in != null);
        }
        catch (Throwable var8_10) {
            var9_11 = this.lifecycle;
            synchronized (var9_11) {
                this.current_state = State.STOPPED;
            }
            throw var8_10;
        }
        var9_12 = this.lifecycle;
        synchronized (var9_12) {
            this.current_state = State.STOPPED;
        }
        this.recThread = null;
        this.log.fine(CommsReceiver.CLASS_NAME, "run", "854");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = (this.current_state == State.RUNNING || this.current_state == State.RECEIVING) && this.target_state == State.RUNNING;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiving() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = this.current_state == State.RECEIVING;
        }
        return result;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        STARTING,
        RECEIVING;

    }
}

