/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3;

import com.eg.org.apache.commons.lang3.SystemUtils;
import com.eg.org.apache.commons.lang3.arch.Processor;
import java.util.HashMap;
import java.util.Map;

public class ArchUtils {
    private static final Map<String, Processor> ARCH_TO_PROCESSOR = new HashMap<String, Processor>();

    private static void init() {
        ArchUtils.init_X86_32Bit();
        ArchUtils.init_X86_64Bit();
        ArchUtils.init_IA64_32Bit();
        ArchUtils.init_IA64_64Bit();
        ArchUtils.init_PPC_32Bit();
        ArchUtils.init_PPC_64Bit();
    }

    private static void init_X86_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.X86);
        String[] stringArray = new String[6];
        stringArray[0] = "x86";
        stringArray[1] = "i386";
        stringArray[2] = "i486";
        stringArray[3] = "i586";
        stringArray[4] = "i686";
        stringArray[5] = "pentium";
        ArchUtils.addProcessors(processor, stringArray);
    }

    private static void init_X86_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.X86);
        String[] stringArray = new String[4];
        stringArray[0] = "x86_64";
        stringArray[1] = "amd64";
        stringArray[2] = "em64t";
        stringArray[3] = "universal";
        ArchUtils.addProcessors(processor, stringArray);
    }

    private static void init_IA64_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.IA_64);
        String[] stringArray = new String[2];
        stringArray[0] = "ia64_32";
        stringArray[1] = "ia64n";
        ArchUtils.addProcessors(processor, stringArray);
    }

    private static void init_IA64_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.IA_64);
        String[] stringArray = new String[2];
        stringArray[0] = "ia64";
        stringArray[1] = "ia64w";
        ArchUtils.addProcessors(processor, stringArray);
    }

    private static void init_PPC_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.PPC);
        String[] stringArray = new String[5];
        stringArray[0] = "ppc";
        stringArray[1] = "power";
        stringArray[2] = "powerpc";
        stringArray[3] = "power_pc";
        stringArray[4] = "power_rs";
        ArchUtils.addProcessors(processor, stringArray);
    }

    private static void init_PPC_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.PPC);
        String[] stringArray = new String[5];
        stringArray[0] = "ppc64";
        stringArray[1] = "power64";
        stringArray[2] = "powerpc64";
        stringArray[3] = "power_pc64";
        stringArray[4] = "power_rs64";
        ArchUtils.addProcessors(processor, stringArray);
    }

    private static void addProcessor(String string, Processor processor) {
        if (ARCH_TO_PROCESSOR.containsKey(string)) {
            throw new IllegalStateException("Key " + string + " already exists in processor map");
        }
        ARCH_TO_PROCESSOR.put(string, processor);
    }

    private static void addProcessors(Processor processor, String ... stringArray) {
        for (String string : stringArray) {
            ArchUtils.addProcessor(string, processor);
        }
    }

    public static Processor getProcessor() {
        return ArchUtils.getProcessor(SystemUtils.OS_ARCH);
    }

    public static Processor getProcessor(String string) {
        return ARCH_TO_PROCESSOR.get(string);
    }

    static {
        ArchUtils.init();
    }
}

