/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.client.MongoIterable;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.MySQLResultDoc;
import com.mongodb.jdbc.MySQLResultSet;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

@AutoLoggable
public class MySQLStatement
extends MongoStatement<MySQLResultDoc>
implements Statement,
LoggingAspect$ajcMightHaveAspect {
    private boolean relaxed;
    private final BsonInt32 formatVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MySQLStatement(MongoConnection conn, String databaseName, boolean relaxed) throws SQLException {
        super(conn, databaseName);
        LoggingAspect.ajc$perObjectBind(this);
        this.formatVersion = new BsonInt32(2);
        this.relaxed = relaxed;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, string));
            }
            this.checkClosed();
            this.closeExistingResultSet();
            BsonDocument stage = this.constructQueryDocument(sql, "mysql", this.formatVersion);
            try {
                MongoIterable<MySQLResultDoc> iterable = this.currentDB.withCodecRegistry(MongoDriver.registry).aggregate(Collections.singletonList(stage), MySQLResultDoc.class).maxTime(this.maxQuerySec, TimeUnit.SECONDS);
                if (this.fetchSize != 0) {
                    iterable = iterable.batchSize(this.fetchSize);
                }
                this.resultSet = new MySQLResultSet(this, iterable.cursor(), this.relaxed);
                return this.resultSet;
            }
            catch (MongoExecutionTimeoutException e) {
                throw new SQLTimeoutException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    static {
        MySQLStatement.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MySQLStatement.java", MySQLStatement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeQuery", "com.mongodb.jdbc.MySQLStatement", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.ResultSet"), 43);
    }
}

