/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonType;

public final class BsonTypeInfo
extends Enum<BsonTypeInfo>
implements LoggingAspect$ajcMightHaveAspect {
    public static final /* enum */ BsonTypeInfo BSON_DOUBLE;
    public static final /* enum */ BsonTypeInfo BSON_STRING;
    public static final /* enum */ BsonTypeInfo BSON_OBJECT;
    public static final /* enum */ BsonTypeInfo BSON_ARRAY;
    public static final /* enum */ BsonTypeInfo BSON_BINDATA;
    public static final /* enum */ BsonTypeInfo BSON_UNDEFINED;
    public static final /* enum */ BsonTypeInfo BSON_OBJECTID;
    public static final /* enum */ BsonTypeInfo BSON_BOOL;
    public static final /* enum */ BsonTypeInfo BSON_DATE;
    public static final /* enum */ BsonTypeInfo BSON_NULL;
    public static final /* enum */ BsonTypeInfo BSON_REGEX;
    public static final /* enum */ BsonTypeInfo BSON_DBPOINTER;
    public static final /* enum */ BsonTypeInfo BSON_JAVASCRIPT;
    public static final /* enum */ BsonTypeInfo BSON_SYMBOL;
    public static final /* enum */ BsonTypeInfo BSON_JAVASCRIPTWITHSCOPE;
    public static final /* enum */ BsonTypeInfo BSON_INT;
    public static final /* enum */ BsonTypeInfo BSON_TIMESTAMP;
    public static final /* enum */ BsonTypeInfo BSON_LONG;
    public static final /* enum */ BsonTypeInfo BSON_DECIMAL;
    public static final /* enum */ BsonTypeInfo BSON_MINKEY;
    public static final /* enum */ BsonTypeInfo BSON_MAXKEY;
    public static final /* enum */ BsonTypeInfo BSON_BSON;
    private static final Set<String> BSON_TYPE_NAMES;
    private final String bsonName;
    private final BsonType bsonType;
    private final int jdbcType;
    private final boolean caseSensitivity;
    private final int minScale;
    private final int maxScale;
    private final int numPrecRadix;
    private final Integer precision;
    private final Integer decimalDigits;
    private final Integer fixedBytesLength;
    private static final /* synthetic */ BsonTypeInfo[] ENUM$VALUES;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        BsonTypeInfo.ajc$preClinit();
        BSON_DOUBLE = new BsonTypeInfo("double", BsonType.DOUBLE, 8, false, 15, 15, 2, 15, 15, 8);
        BSON_STRING = new BsonTypeInfo("string", BsonType.STRING, -1, true, 0, 0, 0, null, null, null);
        BSON_OBJECT = new BsonTypeInfo("object", BsonType.DOCUMENT, 1111, false, 0, 0, 0, null, null, null);
        BSON_ARRAY = new BsonTypeInfo("array", BsonType.ARRAY, 1111, false, 0, 0, 0, null, null, null);
        BSON_BINDATA = new BsonTypeInfo("binData", BsonType.BINARY, -2, false, 0, 0, 0, null, null, null);
        BSON_UNDEFINED = new BsonTypeInfo("undefined", BsonType.UNDEFINED, 1111, false, 0, 0, 0, null, null, null);
        BSON_OBJECTID = new BsonTypeInfo("objectId", BsonType.OBJECT_ID, 1111, false, 0, 0, 0, 24, null, null);
        BSON_BOOL = new BsonTypeInfo("bool", BsonType.BOOLEAN, -7, false, 0, 0, 0, 1, null, 1);
        BSON_DATE = new BsonTypeInfo("date", BsonType.DATE_TIME, 93, false, 0, 3, 0, 24, 3, 8);
        BSON_NULL = new BsonTypeInfo("null", BsonType.NULL, 0, false, 0, 0, 0, null, null, null);
        BSON_REGEX = new BsonTypeInfo("regex", BsonType.REGULAR_EXPRESSION, 1111, true, 0, 0, 0, null, null, null);
        BSON_DBPOINTER = new BsonTypeInfo("dbPointer", BsonType.DB_POINTER, 1111, false, 0, 0, 0, null, null, null);
        BSON_JAVASCRIPT = new BsonTypeInfo("javascript", BsonType.JAVASCRIPT, 1111, true, 0, 0, 0, null, null, null);
        BSON_SYMBOL = new BsonTypeInfo("symbol", BsonType.SYMBOL, 1111, true, 0, 0, 0, null, null, null);
        BSON_JAVASCRIPTWITHSCOPE = new BsonTypeInfo("javascriptWithScope", BsonType.JAVASCRIPT_WITH_SCOPE, 1111, true, 0, 0, 0, null, null, null);
        BSON_INT = new BsonTypeInfo("int", BsonType.INT32, 4, false, 0, 0, 2, 10, null, 4);
        BSON_TIMESTAMP = new BsonTypeInfo("timestamp", BsonType.TIMESTAMP, 1111, false, 0, 0, 0, null, null, null);
        BSON_LONG = new BsonTypeInfo("long", BsonType.INT64, -5, false, 0, 0, 2, 19, null, 8);
        BSON_DECIMAL = new BsonTypeInfo("decimal", BsonType.DECIMAL128, 3, false, 34, 34, 10, 34, 34, 16);
        BSON_MINKEY = new BsonTypeInfo("minKey", BsonType.MIN_KEY, 1111, false, 0, 0, 0, null, null, null);
        BSON_MAXKEY = new BsonTypeInfo("maxKey", BsonType.MAX_KEY, 1111, false, 0, 0, 0, null, null, null);
        BSON_BSON = new BsonTypeInfo("bson", BsonType.UNDEFINED, 1111, false, 0, 0, 0, null, null, null);
        ENUM$VALUES = new BsonTypeInfo[]{BSON_DOUBLE, BSON_STRING, BSON_OBJECT, BSON_ARRAY, BSON_BINDATA, BSON_UNDEFINED, BSON_OBJECTID, BSON_BOOL, BSON_DATE, BSON_NULL, BSON_REGEX, BSON_DBPOINTER, BSON_JAVASCRIPT, BSON_SYMBOL, BSON_JAVASCRIPTWITHSCOPE, BSON_INT, BSON_TIMESTAMP, BSON_LONG, BSON_DECIMAL, BSON_MINKEY, BSON_MAXKEY, BSON_BSON};
        BSON_TYPE_NAMES = new HashSet<String>(Arrays.asList(BsonTypeInfo.BSON_DOUBLE.bsonName, BsonTypeInfo.BSON_STRING.bsonName, BsonTypeInfo.BSON_OBJECT.bsonName, BsonTypeInfo.BSON_ARRAY.bsonName, BsonTypeInfo.BSON_BINDATA.bsonName, BsonTypeInfo.BSON_UNDEFINED.bsonName, BsonTypeInfo.BSON_OBJECTID.bsonName, BsonTypeInfo.BSON_BOOL.bsonName, BsonTypeInfo.BSON_DATE.bsonName, BsonTypeInfo.BSON_NULL.bsonName, BsonTypeInfo.BSON_REGEX.bsonName, BsonTypeInfo.BSON_DBPOINTER.bsonName, BsonTypeInfo.BSON_JAVASCRIPT.bsonName, BsonTypeInfo.BSON_SYMBOL.bsonName, BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.bsonName, BsonTypeInfo.BSON_INT.bsonName, BsonTypeInfo.BSON_TIMESTAMP.bsonName, BsonTypeInfo.BSON_LONG.bsonName, BsonTypeInfo.BSON_DECIMAL.bsonName, BsonTypeInfo.BSON_MINKEY.bsonName, BsonTypeInfo.BSON_MAXKEY.bsonName));
    }

    private BsonTypeInfo(String bsonName, BsonType bsonType, int jdbcType, boolean caseSensitivity, int minScale, int maxScale, int numPrecRadix, Integer precision, Integer decimalDigits, Integer fixedBytesLength) {
        LoggingAspect.ajc$perObjectBind(this);
        this.bsonName = bsonName;
        this.bsonType = bsonType;
        this.jdbcType = jdbcType;
        this.caseSensitivity = caseSensitivity;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.numPrecRadix = numPrecRadix;
        this.precision = precision;
        this.decimalDigits = decimalDigits;
        this.fixedBytesLength = fixedBytesLength;
    }

    public String getBsonName() {
        try {
            return this.bsonName;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    public BsonType getBsonType() {
        try {
            return this.bsonType;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    public int getJdbcType() {
        try {
            return this.jdbcType;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public boolean getCaseSensitivity() {
        try {
            return this.caseSensitivity;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public int getMinScale() {
        try {
            return this.minScale;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public int getMaxScale() {
        try {
            return this.maxScale;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    public int getNumPrecRadix() {
        try {
            return this.numPrecRadix;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    public Integer getPrecision() {
        try {
            return this.precision;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    public Integer getFixedBytesLength() {
        try {
            return this.fixedBytesLength;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    public Integer getDecimalDigits() {
        try {
            return this.decimalDigits;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    public Integer getCharOctetLength() {
        try {
            switch (this.bsonType) {
                case STRING: 
                case BINARY: {
                    return this.precision;
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    public static BsonTypeInfo getBsonTypeInfoByName(String typeName) throws SQLException {
        if (typeName == null) {
            throw new SQLException("Missing bson type name. Value is Null");
        }
        if (!BSON_TYPE_NAMES.contains(typeName)) {
            throw new SQLException("Unknown bson type name: \"" + typeName + "\"");
        }
        switch (typeName.charAt(0)) {
            case 'a': {
                return BSON_ARRAY;
            }
            case 'b': {
                switch (typeName.length()) {
                    case 4: {
                        return BSON_BOOL;
                    }
                    case 7: {
                        return BSON_BINDATA;
                    }
                }
                break;
            }
            case 'd': {
                switch (typeName.length()) {
                    case 4: {
                        return BSON_DATE;
                    }
                    case 6: {
                        return BSON_DOUBLE;
                    }
                    case 7: {
                        return BSON_DECIMAL;
                    }
                    case 9: {
                        return BSON_DBPOINTER;
                    }
                }
                break;
            }
            case 'i': {
                return BSON_INT;
            }
            case 'j': {
                switch (typeName.length()) {
                    case 10: {
                        return BSON_JAVASCRIPT;
                    }
                    case 19: {
                        return BSON_JAVASCRIPTWITHSCOPE;
                    }
                }
                break;
            }
            case 'l': {
                return BSON_LONG;
            }
            case 'm': {
                switch (typeName.charAt(1)) {
                    case 'a': {
                        return BSON_MAXKEY;
                    }
                    case 'i': {
                        return BSON_MINKEY;
                    }
                }
                break;
            }
            case 'n': {
                return BSON_NULL;
            }
            case 'o': {
                switch (typeName.length()) {
                    case 6: {
                        return BSON_OBJECT;
                    }
                    case 8: {
                        return BSON_OBJECTID;
                    }
                }
                break;
            }
            case 'r': {
                return BSON_REGEX;
            }
            case 's': {
                switch (typeName.charAt(1)) {
                    case 't': {
                        return BSON_STRING;
                    }
                    case 'y': {
                        return BSON_SYMBOL;
                    }
                }
                break;
            }
            case 't': {
                return BSON_TIMESTAMP;
            }
            case 'u': {
                return BSON_UNDEFINED;
            }
        }
        throw new SQLException("Unknown bson type name: \"" + typeName + "\"");
    }

    public static BsonTypeInfo[] values() {
        BsonTypeInfo[] bsonTypeInfoArray = ENUM$VALUES;
        int n = bsonTypeInfoArray.length;
        BsonTypeInfo[] bsonTypeInfoArray2 = new BsonTypeInfo[n];
        System.arraycopy(ENUM$VALUES, 0, bsonTypeInfoArray2, 0, n);
        return bsonTypeInfoArray2;
    }

    public static BsonTypeInfo valueOf(String arg0) {
        return Enum.valueOf(BsonTypeInfo.class, arg0);
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BsonTypeInfo.java", BsonTypeInfo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBsonName", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "java.lang.String"), 140);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBsonType", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "org.bson.BsonType"), 144);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCharOctetLength", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "java.lang.Integer"), 185);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJdbcType", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "int"), 148);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCaseSensitivity", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "boolean"), 152);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinScale", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "int"), 156);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxScale", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "int"), 160);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumPrecRadix", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "int"), 164);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrecision", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "java.lang.Integer"), 168);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFixedBytesLength", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "java.lang.Integer"), 172);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDecimalDigits", "com.mongodb.jdbc.BsonTypeInfo", "", "", "", "java.lang.Integer"), 176);
    }
}

