/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMClientXML;
import org.sblim.wbem.client.CIMEnumeration;
import org.sblim.wbem.http.HttpClient;
import org.sblim.wbem.util.GlobalProperties;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CIMEnumerationImpl
implements CIMEnumeration {
    private static final String CLASSNAME = "org.sblim.wbem.client.CIMEnumerationImpl";
    private static final String EMPTY = "";
    private XMLPullParser iPullParser;
    private XMLDefaultHandlerImpl iXmlHandler;
    private CIMObjectPath iRequest;
    private CIMNameSpace iDefaultNamespace;
    private boolean iHasNext;
    private InputStreamReader iInputStream;
    private Enumeration iEnumeration;
    private boolean iUseSAX;
    private HttpClient iHttpClient;
    private Logger iLogger = GlobalProperties.getLogger();

    public CIMEnumerationImpl(Enumeration pEnumeration, CIMObjectPath pRequest, CIMNameSpace pDefaultNamespace) {
        this.iRequest = pRequest;
        this.iDefaultNamespace = pDefaultNamespace;
        this.iEnumeration = pEnumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMEnumerationImpl(XMLDefaultHandlerImpl pHandler, CIMObjectPath pRequest, CIMNameSpace pDefaultNamespace, InputStreamReader pStream, HttpClient pHttpClient, boolean pUseSAX) {
        String methodName = "CIMEnumerationImpl(XMLDefaultHandlerImpl, CIMObjectPath, CIMNameSpace, InputStreamReader, HttpClient, boolean)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new String[]{pRequest.toString(), pDefaultNamespace != null ? pDefaultNamespace.toString() : null, pStream != null ? pStream.toString() : null, pHttpClient != null ? pHttpClient.toString() : null, Boolean.toString(pUseSAX)});
        }
        this.iXmlHandler = pHandler;
        this.iRequest = pRequest;
        this.iDefaultNamespace = pDefaultNamespace;
        this.iInputStream = pStream;
        this.iUseSAX = pUseSAX;
        this.iHttpClient = pHttpClient;
        try {
            try {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, pUseSAX ? "Using SAX parser... " : "Using Pull parser... ");
                }
                if (pUseSAX) {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(new InputSource(pStream), (DefaultHandler)this.iXmlHandler);
                    pStream = null;
                } else {
                    this.iPullParser = new XMLPullParser(pStream);
                    this.iHasNext = this.next(this.iPullParser, this.iXmlHandler, false);
                    Vector o = this.iXmlHandler.getObjects();
                    if (o != null && o.size() > 0) {
                        CIMResponse response = (CIMResponse)o.elementAt(0);
                        response.checkError();
                    } else {
                        CIMException ce = new CIMException("CIM_ERR_FAILED", "inconsistent state due to error while parsing response document");
                        throw ce;
                    }
                }
                Object var11_15 = null;
            }
            catch (CIMException e) {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error processing a returned enumeration", e);
                throw e;
            }
            catch (Exception e) {
                if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e);
                this.iLogger.log(Level.INFO, "Error processing a returned enumeration", e);
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            if (!this.iLogger.isLoggable(Level.FINER)) return;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
            this.iLogger.exiting(CLASSNAME, methodName, new String[]{pRequest.toString(), pDefaultNamespace != null ? pDefaultNamespace.toString() : null, pStream != null ? pStream.toString() : null, pHttpClient != null ? pHttpClient.toString() : null, Boolean.toString(pUseSAX)});
            throw throwable;
        }
        this.iLogger.exiting(CLASSNAME, methodName, new String[]{pRequest.toString(), pDefaultNamespace != null ? pDefaultNamespace.toString() : null, pStream != null ? pStream.toString() : null, pHttpClient != null ? pHttpClient.toString() : null, Boolean.toString(pUseSAX)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        boolean result;
        String methodName;
        block11: {
            block12: {
                methodName = "hasMoreElements()";
                result = false;
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.entering(CLASSNAME, methodName, new String[]{this.iRequest != null ? this.iRequest.toString() : null, this.iDefaultNamespace != null ? this.iDefaultNamespace.toString() : null, this.iInputStream != null ? this.iInputStream.toString() : null, this.iHttpClient != null ? this.iHttpClient.toString() : null, Boolean.toString(this.iUseSAX)});
                }
                try {
                    if (this.iEnumeration != null) break block11;
                    if (!this.iUseSAX) break block12;
                    Vector o = this.iXmlHandler.getObjects();
                    if (o == null || o.size() == 0) {
                        CIMException e = new CIMException("CIM_ERR_FAILED", "inconsistent XML parser: could not create cim response");
                        if (this.iLogger.isLoggable(Level.INFO)) {
                            this.iLogger.log(Level.INFO, "inconsistent XML parser: could not create cim response", e);
                        }
                        throw e;
                    }
                    CIMResponse response = (CIMResponse)o.elementAt(0);
                    boolean bl = result = response.getFirstReturnValue().size() > 0;
                    Object var7_9 = null;
                    if (this.iLogger.isLoggable(Level.FINER)) {
                        this.iLogger.exiting(CLASSNAME, methodName, result);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    block13: {
                        Object var7_12 = null;
                        if (!this.iLogger.isLoggable(Level.FINER)) break block13;
                        this.iLogger.exiting(CLASSNAME, methodName, result);
                    }
                    throw throwable;
                }
            }
            result = this.iHasNext;
            if (!this.iHasNext) {
                this.iInputStream = null;
            }
            boolean bl = result;
            Object var7_10 = null;
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName, result);
            }
            return bl;
        }
        boolean bl = result = this.iEnumeration.hasMoreElements();
        Object var7_11 = null;
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, methodName, result);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nextElement() {
        Object objects2;
        Object resultObj;
        String methodName;
        block16: {
            Object var6_12;
            block15: {
                methodName = "nextElement()";
                resultObj = null;
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.entering(CLASSNAME, methodName);
                }
                try {
                    Object var6_11;
                    block14: {
                        try {
                            if (this.iEnumeration == null) {
                                Vector objects2 = this.iXmlHandler.getObjects();
                                if (objects2.size() == 0) {
                                    CIMException e = new CIMException("CIM_ERR_FAILED", "inconsistent XML parser: could not create cim response");
                                    throw e;
                                }
                                CIMResponse response = (CIMResponse)objects2.elementAt(0);
                                response.checkError();
                                Vector v = response.getFirstReturnValue();
                                if (v != null && v.size() > 0) {
                                    resultObj = v.remove(0);
                                    CIMClientXML.fixResult(this.iRequest, resultObj, this.iDefaultNamespace);
                                    try {
                                        this.iHasNext = v.size() == 0 && !this.iUseSAX ? this.next(this.iPullParser, this.iXmlHandler, false) : true;
                                    }
                                    catch (Exception e) {
                                        if (this.iLogger.isLoggable(Level.WARNING)) {
                                            this.iLogger.log(Level.WARNING, "Unexpected exception while parsing XML document from the input stream", e);
                                        }
                                        this.iHasNext = false;
                                    }
                                    if (!this.iHasNext) {
                                        this.iInputStream = null;
                                    }
                                    var6_11 = resultObj;
                                    Object var8_13 = null;
                                    break block14;
                                }
                                var6_12 = resultObj;
                                break block15;
                            }
                            resultObj = this.iEnumeration.nextElement();
                            CIMClientXML.fixResult(this.iRequest, resultObj, this.iDefaultNamespace);
                            objects2 = resultObj;
                            break block16;
                        }
                        catch (CIMException e) {
                            if (!this.iLogger.isLoggable(Level.WARNING)) throw e;
                            this.iLogger.log(Level.WARNING, "Error occured while reading the next enumration element", e);
                            throw e;
                        }
                        catch (Exception e) {
                            if (!this.iLogger.isLoggable(Level.WARNING)) throw new CIMException("CIM_ERR_FAILED", e);
                            this.iLogger.log(Level.WARNING, "Error occured while reading the next enumration element", e);
                            throw new CIMException("CIM_ERR_FAILED", e);
                        }
                    }
                    if (!this.iLogger.isLoggable(Level.FINER)) return var6_11;
                    this.iLogger.exiting(CLASSNAME, methodName, resultObj);
                    return var6_11;
                }
                catch (Throwable throwable) {
                    Object var8_16 = null;
                    if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                    this.iLogger.exiting(CLASSNAME, methodName, resultObj);
                    throw throwable;
                }
            }
            Object var8_14 = null;
            if (!this.iLogger.isLoggable(Level.FINER)) return var6_12;
            this.iLogger.exiting(CLASSNAME, methodName, resultObj);
            return var6_12;
        }
        Object var8_15 = null;
        if (!this.iLogger.isLoggable(Level.FINER)) return objects2;
        this.iLogger.exiting(CLASSNAME, methodName, resultObj);
        return objects2;
    }

    public void close() throws IOException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean pForce) throws IOException {
        String methodName = "close(boolean)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, pForce);
        }
        try {
            block12: {
                try {
                    if (this.iInputStream == null) break block12;
                    if (pForce) {
                        this.iHttpClient.streamFinished(false);
                    } else if (this.iEnumeration == null && this.iInputStream != null) {
                        this.iInputStream.close();
                    }
                    this.iInputStream = null;
                }
                catch (Exception e) {
                    if (this.iLogger.isLoggable(Level.WARNING)) {
                        this.iLogger.log(Level.WARNING, "Error occured during closing the stream of enumeration", e);
                    }
                    Object var5_4 = null;
                    if (this.iLogger.isLoggable(Level.FINER)) {
                        this.iLogger.exiting(CLASSNAME, methodName);
                    }
                }
            }
            Object var5_3 = null;
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public void fetchAll() throws IOException {
        String methodName = "fetchAll()";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName);
        }
        try {
            try {
                this.next(this.iPullParser, this.iXmlHandler, true);
            }
            catch (SAXException e) {
                CIMException ee = new CIMException("CIM_ERR_FAILED", e);
                if (this.iLogger.isLoggable(Level.WARNING)) {
                    this.iLogger.log(Level.WARNING, "Error occured during fetching all enumeration elements", ee);
                }
                throw ee;
            }
            Object var5_2 = null;
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    private boolean next(XMLPullParser pReader, DefaultHandler pHandler, boolean pFetchAll) throws IOException, SAXException {
        block6: while (pReader.hasNext()) {
            int event = pReader.next();
            switch (event) {
                case 1: {
                    pHandler.startElement(EMPTY, EMPTY, pReader.getElementName(), pReader.getAttributes());
                    break;
                }
                case 2: {
                    pHandler.endElement(EMPTY, EMPTY, pReader.getElementName());
                    if (pFetchAll) break;
                    String lastElementName = null;
                    if (pReader.getElementNames().size() > 0) {
                        lastElementName = (String)pReader.getElementNames().lastElement();
                    }
                    if (lastElementName == null || !lastElementName.equalsIgnoreCase("IRETURNVALUE")) continue block6;
                    return true;
                }
                case 4: {
                    char[] buf = pReader.getText().toCharArray();
                    pHandler.characters(buf, 0, buf.length);
                    break;
                }
                case 8: {
                    return false;
                }
            }
        }
        return false;
    }

    public void finalize() {
        String methodName;
        block5: {
            methodName = "finalize()";
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.entering(CLASSNAME, methodName);
            }
            try {
                if (this.iInputStream != null) {
                    this.close(true);
                }
            }
            catch (IOException e) {
                if (!this.iLogger.isLoggable(Level.WARNING)) break block5;
                this.iLogger.log(Level.WARNING, "Error occured during cleaning up the enumeration", e);
            }
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, methodName);
        }
    }
}

