/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.AgentStartupLogger;
import com.eg.jtm.BTMConstants;
import java.io.File;

public class BTMSamplingConfiguration {
    private static final String SAMPLING_SETTINGS_SECTION = "SAMPLING_SETTINGS";
    private static final String SAMPLES_QUEUE_KEY = "QueueSize";
    private static final String SAMPLE_ANALYSING_WORKERS_KEY = "WorkerSize";
    private static final String INCLUDE_METHODS_KEY = "IncludeMethods";
    private static final String EXCLUDE_METHODS_KEY = "ExcludeMethods";
    private static final String SAMPLING_ENABLED_KEY = "SamplingEnabled";
    private static final int DEFAULT_SAMPLING_WORKERS = 1;
    private static final int DEFAULT_SAMPLING_QUEUE_SIZE = 1;
    private String iniFileName;
    private static long lastModifiedTime = -1L;
    private int workersSize;
    private int queueSize;
    private String[] includeMethods;
    private String[] excludeMethods;
    private boolean samplingEnabled;
    private static BTMSamplingConfiguration btmSamplingConfig = null;
    private static final String logPrefix = " [" + BTMSamplingConfiguration.class.getName() + "] ";

    private BTMSamplingConfiguration(String string) {
        this.iniFileName = string;
        this.updateConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BTMSamplingConfiguration getBTMSamplingConfiguration(String string) {
        if (btmSamplingConfig == null) {
            Class<BTMSamplingConfiguration> clazz = BTMSamplingConfiguration.class;
            synchronized (BTMSamplingConfiguration.class) {
                if (btmSamplingConfig == null) {
                    btmSamplingConfig = new BTMSamplingConfiguration(string);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            btmSamplingConfig.updateConfiguration(true);
        }
        return btmSamplingConfig;
    }

    private void updateConfiguration(boolean bl) {
        boolean bl2 = false;
        String string = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_CONFIG_FOLDER + File.separator + this.iniFileName;
        long l = IniFile.getLastModified(string);
        if (lastModifiedTime > -1L) {
            if (l != lastModifiedTime) {
                bl2 = true;
                lastModifiedTime = l;
            }
        } else {
            lastModifiedTime = l;
            bl2 = true;
        }
        AgentStartupLogger.logger.trace("{} {} iniUpdated :  {} , currentModifiedTime : {}, lastModifiedTime: {}", new Object[]{logPrefix, this.iniFileName, bl2, l, lastModifiedTime});
        if (bl2) {
            this.updateConfiguration();
        }
    }

    private void updateConfiguration() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_CONFIG_FOLDER + File.separator + this.iniFileName;
        AgentStartupLogger.logger.trace("{} Reading Sampling configuration from {}", (Object)logPrefix, (Object)string5);
        IniFile iniFile = new IniFile(string5);
        String string6 = iniFile.getValue(SAMPLING_SETTINGS_SECTION, SAMPLES_QUEUE_KEY);
        if (string6 != null && string6.length() > 0) {
            try {
                this.setQueueSize(Integer.parseInt(string6));
                if (this.getQueueSize() <= 0) {
                    this.setQueueSize(1);
                }
            }
            catch (Exception exception) {
                this.setQueueSize(1);
                AgentStartupLogger.logger.warn("{} Given Sampling queue size is invalid. So, using default queue size : {}", (Object)logPrefix, (Object)1);
            }
        }
        if ((string4 = iniFile.getValue(SAMPLING_SETTINGS_SECTION, SAMPLE_ANALYSING_WORKERS_KEY)) != null && string4.length() > 0) {
            try {
                this.setWorkersSize(Integer.parseInt(string4));
                if (this.getWorkersSize() <= 0) {
                    this.setWorkersSize(1);
                } else if (this.getWorkersSize() >= 25) {
                    AgentStartupLogger.logger.error("{} Given Sampling workers count[{}] is greater than 25, It will cause eG Agent to get CPU Spike. So, using default workers: {}.\n \t\t\t\t\t\t Please give worker count value in eg_tests.ini in manager config under [SAMPLING_SETTING] section, SamplingWorkers=50 or \n  ", new Object[]{logPrefix, this.getWorkersSize(), 1});
                    this.setWorkersSize(1);
                }
            }
            catch (Exception exception) {
                this.setWorkersSize(1);
                AgentStartupLogger.logger.warn("{} Given Sampling workers count is invalid. So, using default workers: {}", (Object)logPrefix, (Object)1);
            }
        }
        if ((string3 = iniFile.getValue(SAMPLING_SETTINGS_SECTION, INCLUDE_METHODS_KEY)) != null && string3.length() > 0) {
            if (string3.contains(",")) {
                this.setIncludeMethods(string3.split(","));
            } else {
                this.setIncludeMethods(new String[]{string3});
            }
        }
        if ((string2 = iniFile.getValue(SAMPLING_SETTINGS_SECTION, EXCLUDE_METHODS_KEY)) != null && string2.length() > 0) {
            if (string2.contains(",")) {
                this.setExcludeMethods(string2.split(","));
            } else {
                this.setExcludeMethods(new String[]{string2});
            }
        }
        this.samplingEnabled = (string = iniFile.getValue(SAMPLING_SETTINGS_SECTION, SAMPLING_ENABLED_KEY)) != null && string.length() > 0 ? string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") : false;
    }

    public int getWorkersSize() {
        return this.workersSize;
    }

    private void setWorkersSize(int n) {
        this.workersSize = n;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    private void setQueueSize(int n) {
        this.queueSize = n;
    }

    public String[] getIncludeMethods() {
        return this.includeMethods;
    }

    private void setIncludeMethods(String[] stringArray) {
        this.includeMethods = stringArray;
    }

    public String[] getExcludeMethods() {
        return this.excludeMethods;
    }

    private void setExcludeMethods(String[] stringArray) {
        this.excludeMethods = stringArray;
    }

    public boolean isSamplingEnabled() {
        return this.samplingEnabled;
    }
}

