/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.PropertyTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapHanaDatabaseInfo
extends BaseDatabaseInfo {
    private static final String HANA_URL_PREFIX = "jdbc:sap://";
    private static final String INSTANCENUMBER = "instancenumber";
    private static String instanceNo = "00";

    public SapHanaDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> sapHanaDataBaseDetails = new Hashtable<String, String>();
        sapHanaDataBaseDetails.put("SERVERTYPE", this.dbType);
        if (this.isParsingFailure) {
            sapHanaDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            sapHanaDataBaseDetails.put("DATABASENAME", "-");
            sapHanaDataBaseDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            sapHanaDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            sapHanaDataBaseDetails.put("DATABASENAME", "-");
            sapHanaDataBaseDetails.put("PORTNUMBER", "-");
        } else {
            sapHanaDataBaseDetails.put("SERVERTYPE", this.dbType);
            sapHanaDataBaseDetails.put("SERVERNAME", this.hostName);
            sapHanaDataBaseDetails.put("DATABASENAME", this.databaseName);
            sapHanaDataBaseDetails.put("PORTNUMBER", this.portNo);
        }
        return sapHanaDataBaseDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(HANA_URL_PREFIX)) {
                String hostPortDbString = maker.after(HANA_URL_PREFIX).before("?").value().trim();
                String propertyString = maker.next().value().trim();
                System.out.println("propertyString " + propertyString);
                int semi_index = hostPortDbString.indexOf(";");
                if (semi_index > 0) {
                    this.isParsingFailure = true;
                } else {
                    if (hostPortDbString.endsWith("/")) {
                        hostPortDbString = hostPortDbString.substring(0, hostPortDbString.length() - 1);
                    }
                    if (propertyString != null && propertyString.length() > 0 && propertyString.startsWith("?")) {
                        propertyString = propertyString.substring(1);
                    }
                    this.parseUrl(hostPortDbString, propertyString);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + " - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
        this.logger.debug("[" + this.dbType + " -parseUrl] hostName :" + this.hostName + " portNo :" + this.portNo + " databaseName :" + this.databaseName);
    }

    private void parseUrl(String hostPortDbString, String propertyString) {
        this.logger.debug("[" + this.dbType + "  - parseUrl] hostPortDbString :" + hostPortDbString + "  propertyString :" + propertyString);
        int colon_index = hostPortDbString.indexOf(":");
        if (colon_index > 0) {
            this.hostName = hostPortDbString.substring(0, colon_index);
            this.portNo = hostPortDbString.substring(colon_index + 1);
        } else {
            this.hostName = hostPortDbString;
            this.portNo = "-";
        }
        PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
        propertyTokenizer.parse(true);
        ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
        if (propertyList != null && propertyList.size() > 0) {
            Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
            int i = 0;
            while (i < propertyList.size()) {
                String propertyName = propertyList.get(i);
                if (propertyName.equals("databasename")) {
                    this.databaseName = properties.get(propertyName);
                } else if (propertyName.equals(INSTANCENUMBER)) {
                    instanceNo = properties.get(propertyName);
                    if (this.portNo.equals("-")) {
                        this.portNo = "3" + instanceNo + "15";
                    }
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:sap://192.168.9.84:30015/?autocommit=false&sessionVariable:APPLICATION=myapp";
        jdbcUrl = "jdbc:sap://192.168.9.84:30015";
        jdbcUrl = "jdbc:sap://myServer:30015;failover1:30015;failover2:30015/?autocommit=false";
        jdbcUrl = "jdbc:sap://ykfl00540545a:30115/?autocommit=false&databaseName=tdb1&sessionVariable:APPLICATION=myapp&sessionVariable:APPLICATIONUSER=user1&sessionVariable:myvar=myval&distribution=connection";
        System.out.println(" jdbcUrl :" + jdbcUrl);
        SapHanaDatabaseInfo dbInfo = new SapHanaDatabaseInfo(jdbcUrl, "SAP_HANA", null);
        Hashtable<String, String> result = dbInfo.getDBInfo();
        System.out.println(" result :" + result);
    }
}

