/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.PropertyTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSqlDatabaseInfo
extends BaseDatabaseInfo {
    private static final String URL_PREFIX = "jdbc:sqlserver://";
    private static final String JTDS_URL_PREFIX = "jdbc:jtds:sqlserver://";
    private static final String MICROSOFT_URL_PREFIX = "jdbc:microsoft:sqlserver://";
    private static final String WEBLOGIC_URL_PREFIX = "jdbc:weblogic:sqlserver://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:sqlserver://";
    private static final String DEFAULT_PORT = "1433";
    private List<HashMap<String, String>> hostList = null;
    private static final String CLUSTERNAME = "clustername";
    private static final String NAMEDPIPE = "namedpipe";
    private static final String INSTANCE = "instance";
    private static final String INSTANCE_NAME = "instancename";
    private boolean isCluster = false;
    private String virtualIP = null;

    public MsSqlDatabaseInfo(String string, String string2, Logger logger) {
        super(string, string2, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SERVERTYPE", this.dbType);
        if (this.isCluster) {
            hashtable.put("SERVERTYPE", "Sql_cluster_service");
        }
        if (this.isParsingFailure) {
            hashtable.put("SERVERNAME", this.jdbcUrl);
            hashtable.put("DATABASENAME", "-");
            hashtable.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            hashtable.put("SERVERNAME", this.jdbcUrl);
            hashtable.put("DATABASENAME", "-");
            hashtable.put("PORTNUMBER", "-");
        } else {
            if (this.isCluster && this.virtualIP != null) {
                this.hostName = this.virtualIP;
            }
            hashtable.put("SERVERNAME", this.hostName);
            hashtable.put("DATABASENAME", this.databaseName);
            hashtable.put("PORTNUMBER", this.portNo);
        }
        return hashtable;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String string = this.jdbcUrl.toLowerCase();
            if (!string.startsWith("jdbc:")) {
                string = "jdbc:" + string;
            }
            StringMaker stringMaker = new StringMaker(string);
            if (string.startsWith(URL_PREFIX)) {
                stringMaker.after(URL_PREFIX);
                this.parseUrl(stringMaker);
            } else if (string.startsWith(JTDS_URL_PREFIX)) {
                stringMaker.after(JTDS_URL_PREFIX);
                this.parseJtdsUrl(stringMaker);
            } else if (string.startsWith(MICROSOFT_URL_PREFIX)) {
                stringMaker.after(MICROSOFT_URL_PREFIX);
                this.parseUrl(stringMaker);
            } else if (string.startsWith(WEBLOGIC_URL_PREFIX)) {
                stringMaker.after(WEBLOGIC_URL_PREFIX);
                this.parseWeblogicConnectionUrl(stringMaker, DEFAULT_PORT);
            } else if (string.startsWith(DATADIRECT_URL_PREFIX)) {
                stringMaker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(stringMaker, DEFAULT_PORT);
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception exception) {
            this.logger.warn("[" + this.dbType + " - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
        this.logger.debug("[" + this.dbType + " -parseUrl] hostName :" + this.hostName + " portNo :" + this.portNo + " databaseName :" + this.databaseName);
    }

    @Override
    protected void parseProperty(String string, String string2, String string3) {
        if (string == null) {
            this.logger.warn("[" + this.dbType + " - parseProperty] propertyString is null for the URL :" + this.jdbcUrl);
            return;
        }
        PropertyTokenizer propertyTokenizer = new PropertyTokenizer(string, this.logger);
        propertyTokenizer.parse();
        ArrayList<String> arrayList = propertyTokenizer.getPropertyNames();
        if (arrayList != null && arrayList.size() > 0) {
            Hashtable<String, String> hashtable = propertyTokenizer.getAllPropertyKeyValues();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = arrayList.get(i);
                if (string4.equals("databasename") || string4.equals("database")) {
                    this.databaseName = hashtable.get(string4);
                    continue;
                }
                if (string4.equals("portnumber")) {
                    this.portNo = hashtable.get(string4);
                    continue;
                }
                if (string4.equals("servername")) {
                    this.hostName = hashtable.get(string4);
                    continue;
                }
                if (!string4.equals("alternateservers")) continue;
                this.isCluster = true;
            }
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        if (this.portNo == null) {
            this.portNo = string3 != null ? string3 : string2;
        }
    }

    private void parseUrl(StringMaker stringMaker) {
        Object object;
        this.logger.debug("[" + this.dbType + "- parseUrl] Maker :" + stringMaker);
        StringMaker stringMaker2 = stringMaker.after("//").before(';');
        String string = stringMaker2.value();
        String string2 = stringMaker.next().value();
        this.logger.debug("[" + this.dbType + " - parseUrl]  hostAndPortAndDataBaseString : " + string + "  maker :" + stringMaker + " PropertyString :" + string2);
        String string3 = null;
        int n = string.indexOf(47);
        if (n != -1) {
            string3 = string.substring(0, n);
            this.databaseName = string.substring(n + 1, string.length());
        } else {
            string3 = string;
        }
        String string4 = null;
        if (string3 != null && string3.length() > 0) {
            int n2 = string3.lastIndexOf(":");
            if (n2 == 0) {
                this.logger.debug("[" + this.dbType + " - parseUrl] HostName is not specified in the JDBC URL");
                this.portNo = string3.substring(1);
            } else if (n2 > 0) {
                object = string3;
                this.portNo = string3.substring(n2 + 1);
                object = string3.substring(0, n2);
                this.hostName = ((String)object).indexOf("\\") > 0 ? ((String)object).substring(0, ((String)object).indexOf("\\")) : object;
            } else if (string3.indexOf("\\") > 0) {
                this.hostName = string3.substring(0, string3.indexOf("\\"));
                string4 = string3.substring(string3.indexOf("\\") + 1);
            } else {
                this.hostName = string3;
            }
        }
        if (string2 != null && string2.length() > 1) {
            PropertyTokenizer propertyTokenizer = new PropertyTokenizer(string2, this.logger);
            propertyTokenizer.parse();
            object = propertyTokenizer.getPropertyNames();
            if (object != null && ((ArrayList)object).size() > 0) {
                Hashtable<String, String> hashtable = propertyTokenizer.getAllPropertyKeyValues();
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    String string5 = (String)((ArrayList)object).get(i);
                    if (string5.equals("databasename") || string5.equals("database") || string5.equals("database\\") || string5.equals("databasename\\")) {
                        this.databaseName = hashtable.get(string5);
                        continue;
                    }
                    if (string5.equals("portnumber") || string5.equals("port")) {
                        this.portNo = hashtable.get(string5);
                        continue;
                    }
                    if (string5.equals("servername") || string5.equals("server")) {
                        String string6 = hashtable.get(string5);
                        if (string6.indexOf("\\") > 0) {
                            this.hostName = string6.substring(0, string6.indexOf("\\"));
                            string4 = string6.substring(string6.indexOf("\\") + 1);
                            continue;
                        }
                        this.hostName = string6;
                        continue;
                    }
                    if (!string5.equals(INSTANCE) && !string5.equals(INSTANCE_NAME)) continue;
                    string4 = hashtable.get(string5);
                }
            }
        }
        if (this.portNo == null) {
            this.portNo = string4 != null ? string4 : DEFAULT_PORT;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
    }

    private void parseJtdsUrl(StringMaker stringMaker) {
        StringMaker stringMaker2 = stringMaker.after("//").before(';');
        String string = stringMaker2.value();
        String string2 = stringMaker.next().value();
        this.logger.debug("[" + this.dbType + " - parseJtdsUrl] hostAndPortAndDataBaseString : " + string + "  maker :" + stringMaker + " PropertyString :" + string2);
        String string3 = null;
        int n = string.indexOf(47);
        if (n != -1) {
            string3 = string.substring(0, n);
            this.databaseName = string.substring(n + 1, string.length());
        } else {
            string3 = string;
        }
        String string4 = null;
        if (string2 != null && string2.length() > 1) {
            PropertyTokenizer propertyTokenizer = new PropertyTokenizer(string2, this.logger);
            propertyTokenizer.parse();
            ArrayList<String> arrayList = propertyTokenizer.getPropertyNames();
            if (arrayList != null && arrayList.size() > 0) {
                Hashtable<String, String> hashtable = propertyTokenizer.getAllPropertyKeyValues();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string5;
                    String string6 = arrayList.get(i);
                    if (string6.equals("databasename")) {
                        this.databaseName = hashtable.get(string6);
                        continue;
                    }
                    if (string6.equals(CLUSTERNAME)) {
                        this.isCluster = true;
                        this.virtualIP = hashtable.get(string6);
                        continue;
                    }
                    if (string6.equals(INSTANCE) || string6.equals(INSTANCE_NAME)) {
                        string4 = hashtable.get(string6);
                        continue;
                    }
                    if (!string6.equals(NAMEDPIPE) || (string5 = hashtable.get(string6)) == null || !string5.equals("true")) continue;
                    this.isParsingFailure = true;
                }
            }
        }
        if (this.isParsingFailure) {
            return;
        }
        if (this.portNo == null) {
            this.portNo = string4 != null ? string4 : DEFAULT_PORT;
        }
        if (string3 != null && string3.length() > 0) {
            this.assignHostNameAndPort(string3, this.portNo);
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
    }

    public static void main(String[] stringArray) {
        String string = "jdbc:jtds:sqlserver://neptune.acme.com:1433/test";
        MsSqlDatabaseInfo msSqlDatabaseInfo = new MsSqlDatabaseInfo(string, "MS_sql_server", null);
        Hashtable<String, String> hashtable = msSqlDatabaseInfo.getDBInfo();
        System.out.println(" result :" + hashtable);
    }
}

