/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.JDBCStringParsingException;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMDb2DatabaseInfo
extends BaseDatabaseInfo {
    private static final String WEBLOGIC_URL_PREFIX = "jdbc:weblogic:db2://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:db2://";
    private static final String URL_PREFIX = "jdbc:db2://";
    private static final String DEFAULT_PORT = "50000";

    public IBMDb2DatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> db2Details = new Hashtable<String, String>();
        db2Details.put("SERVERTYPE", this.dbType);
        if (this.isParsingFailure) {
            db2Details.put("SERVERNAME", this.jdbcUrl);
            db2Details.put("DATABASENAME", "-");
            db2Details.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            db2Details.put("SERVERNAME", this.jdbcUrl);
            db2Details.put("DATABASENAME", "-");
            db2Details.put("PORTNUMBER", "-");
        } else {
            db2Details.put("SERVERNAME", this.hostName);
            db2Details.put("DATABASENAME", this.databaseName);
            db2Details.put("PORTNUMBER", this.portNo);
        }
        return db2Details;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(URL_PREFIX)) {
                maker.after(URL_PREFIX);
                this.parseConnectionUrl(maker);
            } else if (normalizedUrl.startsWith(WEBLOGIC_URL_PREFIX)) {
                maker.after(WEBLOGIC_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
                maker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.portNo == null) {
            this.portNo = DEFAULT_PORT;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
    }

    private void parseConnectionUrl(StringMaker maker) {
        this.logger.debug("[" + this.dbType + "  - parseConnectionUrl] maker :" + maker.toString());
        String fromhost = maker.after("//").value().trim();
        try {
            if (fromhost.startsWith("/")) {
                this.databaseName = maker.after("/").value();
                this.hostName = "localhost";
                this.portNo = DEFAULT_PORT;
                this.logger.debug("[" + this.dbType + "  - parseConnectionUrl]  hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
                return;
            }
            String ipPortString = null;
            if (fromhost.indexOf("/") > 0) {
                String dbName = maker.after("/").value();
                if (dbName.indexOf(":") > 0) {
                    dbName = dbName.substring(0, dbName.indexOf(":"));
                }
                this.databaseName = dbName;
                ipPortString = maker.prev().after("//").beforeLast("/").value();
            } else {
                this.databaseName = "-";
                ipPortString = maker.before("//").value();
            }
            if (ipPortString != null && ipPortString.length() == 0) {
                ipPortString = maker.before("/").value();
            }
            if (ipPortString != null && ipPortString.length() > 0) {
                this.assignHostNameAndPort(ipPortString, DEFAULT_PORT);
            }
        }
        catch (JDBCStringParsingException ex) {
            this.isParsingFailure = true;
            this.logger.warn("[" + this.dbType + "  - parseConnectionUrl] Exception while parsing URL :" + this.jdbcUrl);
            throw new JDBCStringParsingException("Exception while parsing URL :" + this.jdbcUrl);
        }
        this.logger.debug("[" + this.dbType + "  - parseConnectionUrl] hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:db2://abc.com:12345/SAMPLE";
        IBMDb2DatabaseInfo dbInfo = new IBMDb2DatabaseInfo(jdbcUrl, "IBM_Db2_server", null);
        Hashtable<String, String> result = dbInfo.getDBInfo();
        System.out.println(" result :" + result + "  " + dbInfo.isParsingFailure);
    }
}

