/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BTMDiscovery {
    private final Hashtable DataBaseHT = new Hashtable();
    private final HashMap<String, String> sessionUserMapping = new HashMap();
    private Vector<HashMap<String, double[]>> workingCopyOneList = new Vector();
    private Vector<HashMap<String, double[]>> workingCopyTwoList = new Vector();
    private Vector<HashMap<String, double[]>> transmitCopyList = new Vector();
    private boolean workingCopy1_isProcessing = false;
    private static final String loggerDispStr = "[BTMDiscovery]";

    public Hashtable getDataBaseHT() {
        return this.DataBaseHT;
    }

    public String getPropertyFromDataBaseHT(String key) {
        return (String)this.DataBaseHT.get(key);
    }

    public Hashtable getGlobalDetails() {
        if (this.sessionUserMapping.isEmpty()) {
            return this.DataBaseHT;
        }
        this.DataBaseHT.put("SESSION_USER_KEY", this.sessionUserMapping.clone());
        return this.DataBaseHT;
    }

    public void removeSessionUserKey() {
        HashMap resultMap = (HashMap)this.DataBaseHT.remove("SESSION_USER_KEY");
        if (resultMap != null) {
            int size = resultMap.size();
            try {
                Set keys = resultMap.keySet();
                for (String sessionString : keys) {
                    this.sessionUserMapping.remove(sessionString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addUserSessionDetails(String userName, String sessionId) {
        this.sessionUserMapping.put(sessionId, userName);
    }

    public Vector<HashMap<String, double[]>> getWorkingCopy() {
        if (this.workingCopy1_isProcessing) {
            return this.workingCopyTwoList;
        }
        return this.workingCopyOneList;
    }

    private void resetTransmitCopy() {
        this.transmitCopyList = new Vector();
    }

    private void resetWorkingCopyOne() {
        this.workingCopyOneList = new Vector();
    }

    private void resetWorkingCopyTwo() {
        this.workingCopyTwoList = new Vector();
    }

    public void updateTransmitCopy() {
        Vector cloneList = null;
        if (this.workingCopy1_isProcessing) {
            this.workingCopy1_isProcessing = false;
            cloneList = (Vector)this.workingCopyTwoList.clone();
            this.resetWorkingCopyTwo();
        } else {
            this.workingCopy1_isProcessing = true;
            cloneList = (Vector)this.workingCopyOneList.clone();
            this.resetWorkingCopyOne();
        }
        if (cloneList != null) {
            this.transmitCopyList.addAll(cloneList);
        }
    }

    public Hashtable cloneTransmitCopy() {
        Vector cloneTransmitCopy = (Vector)this.transmitCopyList.clone();
        this.resetTransmitCopy();
        Hashtable<String, Vector> detailsHT = new Hashtable<String, Vector>();
        detailsHT.put("tftDetails", cloneTransmitCopy);
        return detailsHT;
    }

    public void reset() {
        this.resetWorkingCopyOne();
        this.resetWorkingCopyTwo();
        this.resetTransmitCopy();
    }
}

