/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ProcessBasedDiscoveryManager;
import com.eg.apm.ProcessBasedDiscoveryThread;

public class ProcessBasedDiscoveryThreadsController {
    private static final String loggerDispStr = "[ProcessBasedDiscoveryThreadsController]";
    private static final ProcessBasedDiscoveryThreadsController INSTANCE = new ProcessBasedDiscoveryThreadsController();

    private ProcessBasedDiscoveryThreadsController() {
    }

    public static ProcessBasedDiscoveryThreadsController getInstance() {
        return INSTANCE;
    }

    public void startApmAppDiscoveryThreads() {
        ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
        try {
            if (apmConfigManager.isAgentDiscoveryEnabled() && apmConfigManager.isEgProcessBasedDiscoveryEnabled()) {
                if (apmConfigManager.isJavaProcessDiscoveryEnabled()) {
                    ProcessBasedDiscoveryThread.getInstance();
                } else {
                    APMDiscoveryLogger.discoveryLogger.info("{} Skipping java process based discovery due to - isJavaProcessDiscoveryEnabled : {} ", (Object)loggerDispStr, (Object)ApmConfigManager.getInstance().isJavaProcessDiscoveryEnabled());
                }
            } else {
                APMDiscoveryLogger.discoveryLogger.info("{} Skipping process based discovery due to - isAgentDiscoveryEnabled : {}, isEgProcessBasedDiscoveryEnabled : {} ", new Object[]{loggerDispStr, ApmConfigManager.getInstance().isAgentDiscoveryEnabled(), ApmConfigManager.getInstance().isEgProcessBasedDiscoveryEnabled()});
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to initiate apm app discovery threads ", (Object)loggerDispStr, (Object)exception);
        }
    }

    public void trackApmAppDiscoveryThreads() {
        ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
        try {
            if (apmConfigManager.isAgentDiscoveryEnabled() && apmConfigManager.isEgProcessBasedDiscoveryEnabled()) {
                if (apmConfigManager.isJavaProcessDiscoveryEnabled()) {
                    ProcessBasedDiscoveryThread.getInstance();
                } else {
                    this.clearJavaProcessDiscoveryResources(this.getJavaProcessDiscoveryStatus());
                }
            } else {
                this.clearJavaProcessDiscoveryResources(this.getAgentDiscoveryStatus() + "&" + this.getEgProcessBasedDiscoveryStatus());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to track apm discovery threads ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void clearJavaProcessDiscoveryResources(String string) {
        this.killJavaProcessDiscoveryThread(string);
        this.clearApmAppDiscoveryIni();
        this.clearOnMemoryRepositories();
    }

    private void clearOnMemoryRepositories() {
        ProcessBasedDiscoveryManager.getInstance().clearData(true);
    }

    private void clearApmAppDiscoveryIni() {
    }

    private void killJavaProcessDiscoveryThread(String string) {
        try {
            ProcessBasedDiscoveryThread processBasedDiscoveryThread = ProcessBasedDiscoveryThread.getInstance(true);
            if (processBasedDiscoveryThread != null) {
                String string2 = processBasedDiscoveryThread.getName();
                processBasedDiscoveryThread.setRunThis(false);
                APMDiscoveryLogger.discoveryLogger.warn("{} Terminated JavaProcessDiscoveryThread - [{}], Reason: {} ", new Object[]{loggerDispStr, string2, string});
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to interrupt JavaProcessDiscoveryThread ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private String getJavaProcessDiscoveryStatus() {
        return "[isJavaProcessDiscoveryEnabled: " + ApmConfigManager.getInstance().isJavaProcessDiscoveryEnabled() + "]";
    }

    private String getAgentDiscoveryStatus() {
        return "[isAgentDiscoveryEnabled: " + ApmConfigManager.getInstance().isAgentDiscoveryEnabled() + "]";
    }

    private String getEgProcessBasedDiscoveryStatus() {
        return "[isEgProcessBasedDiscoveryEnabled: " + ApmConfigManager.getInstance().isEgProcessBasedDiscoveryEnabled() + "]";
    }
}

