/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;

public final class NetstatUtils {
    private static final String loggerDispStr = "[NetstatUtils]";
    private static String netstatCmd = "";
    private static String sudoPrefix = "";

    static {
        netstatCmd = NetstatUtils.getNetStatCmd();
        if (!APMUtils.isWindows()) {
            sudoPrefix = "sudo";
        }
    }

    private static String getNetStatCmd() {
        if (APMUtils.isWindows()) {
            return "netstat -aonp tcp | findstr LISTENING";
        }
        if (APMUtils.isLinux()) {
            return "netstat -anlp | grep LISTEN | grep tcp";
        }
        if (APMUtils.isSolaris()) {
            return "netstat -anP tcp | grep LISTEN";
        }
        if (APMUtils.isHpux()) {
            return "netstat -an | grep LISTEN";
        }
        if (APMUtils.isAix()) {
            return "netstat -tna | grep LISTEN";
        }
        return "";
    }

    public static HashMap<String, TreeSet<Integer>> getListenPorts() {
        if (APMUtils.isWindows()) {
            return NetstatUtils.getListenPortsForWindows(sudoPrefix, netstatCmd);
        }
        if (ApmConfigManager.getInstance().isNetStatExistsOnLinux()) {
            return NetstatUtils.getListenPortsForUnix(sudoPrefix, netstatCmd);
        }
        return new HashMap<String, TreeSet<Integer>>();
    }

    private static HashMap<String, TreeSet<Integer>> getListenPortsForWindows(String sudoPrefix, String portCmd) {
        HashMap<String, TreeSet<Integer>> resultMap;
        block8: {
            resultMap = new HashMap<String, TreeSet<Integer>>();
            try {
                String cmd = APMUtils.getFullCmd(sudoPrefix, portCmd);
                boolean useShell = !APMUtils.isWindows();
                ArrayList outPut = APMUtils.executeCmd(cmd, useShell);
                if (outPut == null || outPut.size() <= 0) break block8;
                int i = 0;
                while (i < outPut.size()) {
                    String pidLineString = (String)outPut.get(i);
                    try {
                        int index;
                        String completeString = pidLineString.trim().replaceAll(" +", "#");
                        StringTokenizer tokenizer = new StringTokenizer(completeString, "#");
                        tokenizer.nextElement();
                        String IPAndPort = (String)tokenizer.nextElement();
                        int port = -1;
                        if (IPAndPort != null && (index = IPAndPort.indexOf(":")) > -1) {
                            port = Integer.parseInt(IPAndPort.substring(index + 1));
                        }
                        tokenizer.nextElement();
                        tokenizer.nextElement();
                        String pid = (String)tokenizer.nextElement();
                        if (port > -1 && pid != null && pid.length() > 0) {
                            TreeSet<Integer> portlist = resultMap.get(pid);
                            if (portlist == null) {
                                portlist = new TreeSet();
                            }
                            portlist.add(port);
                            resultMap.put(pid.trim(), portlist);
                        }
                    }
                    catch (Exception e) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} getJvmPortsForWidnows() Unable to get listening ports for {} ", (Object)loggerDispStr, (Object)pidLineString);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} getJvmPortsForWidnows() Unable to get listening ports ", (Object)loggerDispStr, (Object)e);
            }
        }
        return resultMap;
    }

    private static HashMap<String, TreeSet<Integer>> getListenPortsForUnix(String sudoPrefix, String portCmd) {
        HashMap<String, TreeSet<Integer>> resultMap;
        block9: {
            resultMap = new HashMap<String, TreeSet<Integer>>();
            try {
                String cmd = APMUtils.getFullCmd(sudoPrefix, portCmd);
                boolean useShell = !APMUtils.isWindows();
                ArrayList outPut = APMUtils.executeCmd(cmd, useShell);
                if (outPut == null || outPut.size() <= 0) break block9;
                int i = 0;
                while (i < outPut.size()) {
                    String pidLineString = (String)outPut.get(i);
                    try {
                        int index;
                        int index2;
                        String completeString = pidLineString.trim().replaceAll(" +", "#");
                        StringTokenizer tokenizer = new StringTokenizer(completeString, "#");
                        tokenizer.nextElement();
                        tokenizer.nextElement();
                        tokenizer.nextElement();
                        String IPAndPort = (String)tokenizer.nextElement();
                        int port = -1;
                        if (IPAndPort != null && (index2 = IPAndPort.indexOf(":")) > -1) {
                            String ipwithchar = IPAndPort.substring(index2);
                            port = Integer.parseInt(ipwithchar.replaceAll(":", "").trim());
                        }
                        tokenizer.nextElement();
                        tokenizer.nextElement();
                        String pid = (String)tokenizer.nextElement();
                        if (pid != null && (index = pid.indexOf("/")) > -1) {
                            pid = pid.substring(0, index);
                        }
                        if (port > -1 && pid != null && pid.length() > 0) {
                            TreeSet<Integer> portlist = resultMap.get(pid);
                            if (portlist == null) {
                                portlist = new TreeSet();
                            }
                            portlist.add(port);
                            resultMap.put(pid.trim(), portlist);
                        }
                    }
                    catch (Exception e) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} getJvmPortsForUnix() Unable to get listening ports for {} ", (Object)loggerDispStr, (Object)pidLineString);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} getJvmPortsForUnix() Unable to get listening ports ", (Object)loggerDispStr, (Object)e);
            }
        }
        return resultMap;
    }
}

