/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ContainersService;
import com.eg.apm.DiscoveryMode;
import com.eg.apm.DiscoveryProtocol;
import com.eg.apm.EgDiscoveryHelper;
import com.eg.apm.JavaProcess;
import com.eg.apm.ProcessInfo;
import com.eg.apm.ProcessPatternMatcher;
import java.util.ArrayList;

public class EgProcessHandleDiscoveryProtocol
implements DiscoveryProtocol {
    private static final String loggerDispStr = "[EgProcessHandleDiscoveryProtocol]";
    private static final ArrayList EMPTY_LIST = new ArrayList();
    private DiscoveryMode discoveryMode = null;

    public EgProcessHandleDiscoveryProtocol(DiscoveryMode discoveryMode) {
        this.discoveryMode = discoveryMode;
    }

    public ArrayList doDiscovery(EgDiscoveryHelper egDiscoveryHelper) {
        ContainersService containersService = ContainersService.getInstance();
        ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
        if (containersService.isContainerZ() && !containersService.isHybridEnv() && !apmConfigManager.isJPHDEnabledForContainerZ()) {
            APMDiscoveryLogger.discoveryLogger.info("{} {} discovery disabled for containerized env", (Object)loggerDispStr, (Object)this.discoveryMode);
            return EMPTY_LIST;
        }
        if (apmConfigManager.isJava9Higher()) {
            APMDiscoveryLogger.discoveryLogger.info("{}  Discovery Running by using {} mode !!!", (Object)loggerDispStr, (Object)this.discoveryMode);
            if (APMUtils.isWindows()) {
                ProcessPatternMatcher processPatternMatcher = egDiscoveryHelper.getProcessPatterMatcher();
                return this.discoverForWindowsOS(processPatternMatcher);
            }
            String string = egDiscoveryHelper.getJavaProcHandleExecCmd();
            return this.discoverForLinuxOS(string);
        }
        APMDiscoveryLogger.discoveryLogger.warn("{} {} discovery supported above JAVA 9 only. Upgrade to JAVA 9 & above. Current JAVA version : {}", new Object[]{loggerDispStr, this.discoveryMode, apmConfigManager.isJava9Higher()});
        return EMPTY_LIST;
    }

    private ArrayList discoverForWindowsOS(ProcessPatternMatcher processPatternMatcher) {
        return ProcessInfo.getJavaProcessInfoObjects(processPatternMatcher);
    }

    private ArrayList discoverForLinuxOS(String string) {
        ArrayList<JavaProcess> arrayList = new ArrayList<JavaProcess>();
        try {
            ArrayList arrayList2 = APMUtils.executeCmd(string, true);
            if (arrayList2 != null && arrayList2.size() > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string2 = (String)arrayList2.get(i);
                    if (!string2.contains("^|^")) continue;
                    arrayList.add(new JavaProcess(string2));
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} discoverForUnix() Unable to discover process details ", (Object)loggerDispStr, (Object)exception);
        }
        return arrayList;
    }

    public void clear() {
    }
}

