/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.EgLogContainsChecker;
import com.eg.apm.EgLogMatcher;
import com.eg.apm.EgLogStartsWithChecker;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.filter.Filter;
import com.eg.ch.qos.logback.core.spi.FilterReply;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgLogFilter
extends Filter<ILoggingEvent> {
    private String messageString;
    private String loggerName;
    private HashMap<String, EgLogMatcher> filterMap;

    public EgLogFilter(String string, String string2) {
        this.messageString = string;
        this.loggerName = string2;
        this.filterMap = new HashMap();
        System.out.println("[EgLogFilter] -" + this.loggerName + " constructed with " + this.messageString);
        this.buildMap();
    }

    private void buildMap() {
        if (this.messageString != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.messageString, "|");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || (string = string2.trim()).length() <= 0) continue;
                if (string.startsWith("sw-")) {
                    string = string.substring(3);
                    this.filterMap.put(string, new EgLogStartsWithChecker(string));
                    continue;
                }
                if (string.startsWith("c-")) {
                    string = string.substring(2);
                    this.filterMap.put(string, new EgLogContainsChecker(string));
                    continue;
                }
                this.filterMap.put(string, new EgLogContainsChecker(string));
            }
        }
        System.out.println("[EgLogFilter] -" + this.loggerName + "-->filterMap :" + this.filterMap);
    }

    private boolean isFound(String string) {
        String string2;
        EgLogMatcher egLogMatcher;
        boolean bl = false;
        Set<String> set = this.filterMap.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext() && !(bl = (egLogMatcher = this.filterMap.get(string2 = iterator.next())).isMatchFound(string))) {
        }
        return bl;
    }

    public FilterReply decide(ILoggingEvent iLoggingEvent) {
        String string = iLoggingEvent.getFormattedMessage();
        if (string != null && this.isFound(string)) {
            return FilterReply.ACCEPT;
        }
        return FilterReply.DENY;
    }
}

