/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.EgContainerzDiscoveryConfig;
import java.io.File;
import java.util.HashMap;

public class EgDiscoveryConfigManager {
    private IniFile discoveryFileObj;
    private long lastModifiedTime;
    private long lastSize;
    private static final String discoveryIniFile = EgInstallInfo.getInstallDir() + File.separator + "agent" + File.separator + "config" + File.separator + "eg_containerizedapps.ini";
    private static final String DISCOVERY = new String("DISCOVERY");
    private static EgDiscoveryConfigManager instance = null;
    private static final String loggerPrefix = "[EgDiscoveryConfigManager] ";
    private HashMap conzDiscoveryWishList = new HashMap();
    private HashMap conzDiscoveryTypes = new HashMap();
    private HashMap conzDiscoveryPorts = new HashMap();
    private HashMap conzDiscoveryProcessPatterns = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EgDiscoveryConfigManager getInstance() {
        if (instance != null) return instance;
        Class<EgDiscoveryConfigManager> clazz = EgDiscoveryConfigManager.class;
        synchronized (EgDiscoveryConfigManager.class) {
            if (instance != null) return instance;
            instance = new EgDiscoveryConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private EgDiscoveryConfigManager() {
        EgContainerzDiscoveryConfig.init();
        this.init();
    }

    private void init() {
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.discoveryFileObj = new IniFile(discoveryIniFile);
        this.updateConfigs();
        this.printConfigs();
    }

    private void updateConfigs() {
        this.conzDiscoveryWishList = APMUtils.getAutoLinesAsArrayListMap(this.discoveryFileObj, EgContainerzDiscoveryConfig.getDiscoveryAutoDiscoveryTypesSection(), ",", APMDiscoveryLogger.discoveryLogger);
        this.conzDiscoveryTypes = APMUtils.getLinesAsArrayListMap(this.discoveryFileObj, EgContainerzDiscoveryConfig.getDiscoveryTypesSection(), ",", APMDiscoveryLogger.discoveryLogger);
        this.conzDiscoveryPorts = APMUtils.getLinesAsArrayListMap(this.discoveryFileObj, EgContainerzDiscoveryConfig.getDiscoveryPortsSection(), ",", APMDiscoveryLogger.discoveryLogger);
        this.conzDiscoveryProcessPatterns = APMUtils.getLinesAsArrayListMap(this.discoveryFileObj, EgContainerzDiscoveryConfig.getDiscoveryProcessPaternSection(), ",", APMDiscoveryLogger.discoveryLogger);
    }

    private void printConfigs() {
        if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled()) {
            APMDiscoveryLogger.discoveryLogger.info(" {} Current Containerz Discovery Spec : {}", (Object)loggerPrefix, (Object)EgContainerzDiscoveryConfig.getCurrentDiscoverySpec());
            APMDiscoveryLogger.discoveryLogger.info(" {} conzDiscoveryTypes : {}, conzDiscoveryPorts : {},  conzDiscoveryProcessPatterns : {}conzDiscoveryWishList : {}", new Object[]{loggerPrefix, this.conzDiscoveryTypes, this.conzDiscoveryPorts, this.conzDiscoveryProcessPatterns, this.conzDiscoveryWishList});
        }
    }

    private long lastModified() {
        return IniFile.getLastModified(discoveryIniFile);
    }

    private long lastSize() {
        return IniFile.getLastSize(discoveryIniFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && l2 == this.lastSize) {
            return false;
        }
        String string = DISCOVERY;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == this.lastModifiedTime && l2 == this.lastSize) {
                return false;
            }
            this.init();
            return true;
        }
    }

    public HashMap getConzDiscoveryTypes() {
        return this.conzDiscoveryTypes;
    }

    public HashMap getConzDiscoveryWishList() {
        return this.conzDiscoveryWishList;
    }

    public HashMap getConzDiscoveryPorts() {
        return this.conzDiscoveryPorts;
    }

    public HashMap getConzDiscoveryProcessPatterns() {
        return this.conzDiscoveryProcessPatterns;
    }

    public static void main(String[] stringArray) {
        System.setProperty("eg.discovery.spec", "ON-PREM_CONTAINER-ENV_PRIVATE-CLOUD");
        EgDiscoveryConfigManager egDiscoveryConfigManager = EgDiscoveryConfigManager.getInstance();
        System.out.println(discoveryIniFile);
        System.out.println(egDiscoveryConfigManager.getConzDiscoveryPorts());
        System.out.println(EgContainerzDiscoveryConfig.getCurrentDiscoverySpec());
    }
}

