/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ContainerType {
    NONE{

        public boolean isDocker() {
            return false;
        }

        public boolean isCrio() {
            return false;
        }

        public boolean isK8Pod() {
            return false;
        }

        public String getCommandForContainerID() {
            return null;
        }

        public boolean isCluster() {
            return false;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    }
    ,
    DOCKER{

        public boolean isDocker() {
            return true;
        }

        public boolean isCrio() {
            return false;
        }

        public boolean isK8Pod() {
            return false;
        }

        public String getCommandForContainerID() {
            String string = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"docker-.*.scope\" | head -n 1 | sed \"s/docker-\\(.*\\).scope/\\\\1/\"";
            return string;
        }

        public boolean isCluster() {
            return false;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    }
    ,
    CRIO{

        public boolean isDocker() {
            return true;
        }

        public boolean isCrio() {
            return true;
        }

        public boolean isK8Pod() {
            return false;
        }

        public String getCommandForContainerID() {
            String string = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"crio-.*.scope\" | head -n 1 | sed \"s/crio-\\(.*\\).scope/\\\\1/\"";
            return string;
        }

        public boolean isCluster() {
            return false;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    }
    ,
    CRIO_K8{

        public boolean isDocker() {
            return true;
        }

        public boolean isCrio() {
            return true;
        }

        public boolean isK8Pod() {
            return true;
        }

        public String getCommandForContainerID() {
            String string = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"crio-.*.scope\" | head -n 1 | sed \"s/crio-\\(.*\\).scope/\\\\1/\"";
            return string;
        }

        public boolean isCluster() {
            return true;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    }
    ,
    DOCKER_K8{

        public boolean isDocker() {
            return true;
        }

        public boolean isCrio() {
            return false;
        }

        public boolean isK8Pod() {
            return true;
        }

        public String getCommandForContainerID() {
            String string = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"docker-.*.scope\" | head -n 1 | sed \"s/docker-\\(.*\\).scope/\\\\1/\"";
            return string;
        }

        public boolean isCluster() {
            return true;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    }
    ,
    AWS_ECS{

        public boolean isDocker() {
            return true;
        }

        public boolean isCrio() {
            return false;
        }

        public boolean isK8Pod() {
            return true;
        }

        public String getCommandForContainerID() {
            String string = "cat /proc/self/cgroup  | grep -e \"cpu\" | awk -F\"/\" '{print $NF}' | head -n 1";
            return string;
        }

        public boolean isCluster() {
            return true;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    }
    ,
    AWS_K8{

        public boolean isDocker() {
            return true;
        }

        public boolean isCrio() {
            return false;
        }

        public boolean isK8Pod() {
            return true;
        }

        public String getCommandForContainerID() {
            String string = "cat /proc/self/cgroup  | grep -e \"cpu\" | awk -F\"/\" '{print $NF}' | head -n 1";
            return string;
        }

        public boolean isCluster() {
            return true;
        }

        public boolean isContainerZ() {
            return this.isCluster() || this.isK8Pod() || this.isCrio() || this.isDocker();
        }
    };


    public abstract boolean isDocker();

    public abstract boolean isCrio();

    public abstract boolean isK8Pod();

    public abstract boolean isCluster();

    public abstract boolean isContainerZ();

    public abstract String getCommandForContainerID();
}

