/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMLanguage;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.Component;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.MessageHandler;
import com.eg.apm.MessageHandlerFactory;
import com.eg.apm.NodeAPMComponent;
import com.eg.apm.WorkerInfo;
import com.eg.jtm.NodeThreadPoolManager;
import com.eg.jtm.ThreadPoolManager;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ClientSocketHandler
implements Runnable {
    private Socket clientSocket;
    private static final String logPrefix = " [ClientSocketHandler] ";
    private String clientSocketAddress;
    private APMLanguage language;
    private volatile boolean runThis = true;
    private volatile boolean whileRunning = false;
    private static final Object configSync = new Object();
    private Long workerID = null;
    private String nick;
    private String guid;

    public ClientSocketHandler(Socket clientSocket, APMLanguage language) {
        try {
            this.clientSocket = clientSocket;
            this.language = language;
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} BTM - Unable to initialize ClientSocketHandler object {}", (Object)logPrefix, (Object)e);
        }
    }

    public void run() {
        if (this.clientSocket == null) {
            return;
        }
        if (this.language == APMLanguage.JAVA) {
            this.javaHandler();
        } else if (this.language == APMLanguage.NODEJS) {
            this.nodeJsHandler();
        }
    }

    /*
     * Exception decompiling
     */
    private void nodeJsHandler() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void javaHandler() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 32[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void submitDataToQueue(String nodeID, Object obj, APMLanguage language) {
        if (language == APMLanguage.JAVA) {
            ThreadPoolManager poolManager = ThreadPoolManager.getInstance();
            try {
                poolManager.submitTask(obj);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Java eG BTM Object [{}] added into Queue for {} Queue Size is {}", new Object[]{logPrefix, obj, nodeID, poolManager.getQueueSize()});
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Unable to add Java eG BTM  Object to the Queue for {} {} ", new Object[]{logPrefix, nodeID, e});
            }
        } else {
            NodeThreadPoolManager poolManager = NodeThreadPoolManager.getInstance();
            try {
                poolManager.submitTask(obj);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} NodeJS Object [{}] added into Queue for {} Queue Size is {}", new Object[]{logPrefix, obj, nodeID, poolManager.getQueueSize()});
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Unable to add NodeJS Object to the Queue for {} {} ", new Object[]{logPrefix, nodeID, e});
            }
        }
    }

    String getClientSocketAddress() {
        return this.clientSocketAddress;
    }

    private String getComponentId(JSONArray nodeJsArray) {
        try {
            int i = 0;
            while (i < nodeJsArray.size()) {
                JSONObject jsonObject = (JSONObject)nodeJsArray.get(i);
                if (jsonObject != null && jsonObject.containsKey((Object)"discoveryDetails")) {
                    JSONObject jsonObject1 = (JSONObject)jsonObject.get((Object)"discoveryDetails");
                    if (jsonObject1 != null && jsonObject1.containsKey((Object)"JvmGUID")) {
                        return (String)jsonObject1.get((Object)"JvmGUID");
                    }
                } else if (jsonObject != null && jsonObject.containsKey((Object)"componentId")) {
                    return (String)jsonObject.get((Object)"componentId");
                }
                ++i;
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} got an error while retriving componentId from NodeJs Object :- {} , {} ", new Object[]{logPrefix, this.clientSocketAddress, e});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFurtherProcess(APMComponent component, WorkerInfo workerInfo, Object streamObject, boolean nodeJsObject) {
        ClientSocketHandler handlerObject;
        boolean ackSend = false;
        Long workerId = Component.DEFAULT_WORKER_ID;
        Long workerCount = Component.DEFAULT_WORKER_ID;
        boolean isNullId = false;
        if (workerInfo != null) {
            isNullId = workerInfo.isNullWorkerId();
            if (isNullId) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess - NullWorker ID {}, this-{}", new Object[]{logPrefix, workerInfo, this});
                return;
            }
            if (workerInfo.isClusterMode()) {
                workerId = workerInfo.getWorkerId();
                workerCount = workerInfo.getWorkerCount();
            }
        }
        if ((handlerObject = component.getHandlerObject(workerId)) != null && handlerObject.whileRunning) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 2- nodeJsObject {} - isAppServerRestarted ? {}  MATCH ? {} <==> {} , WorkerInfo - {} , clientSocket {} <<==>> {}", new Object[]{logPrefix, nodeJsObject, component.isAppServerRestarted(), handlerObject, this, workerInfo, handlerObject.clientSocket, this.clientSocket});
            if (handlerObject == this) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 3- nodeJsObject {} - isAppServerRestarted ? {} MATCH ? {} <==> {} , WorkerInfo - {}", new Object[]{logPrefix, nodeJsObject, component.isAppServerRestarted(), handlerObject, this, workerInfo});
                ackSend = nodeJsObject ? this.isAnyDataAvailableToSend(component, workerId, workerCount, streamObject, true) : this.isAnyDataAvailableToSend(component, workerId, workerCount, streamObject);
                component.setAppServerRestarted(false);
            } else if (workerInfo != null) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 4 else Block- nodeJsObject {} - isAppServerRestarted ? {} MATCH ? {} <==> {} , WorkerInfo - {}", new Object[]{logPrefix, nodeJsObject, component.isAppServerRestarted(), handlerObject, this, workerInfo});
                Long handlerWorkerID = handlerObject.workerID;
                Long thisWorkerID = this.workerID;
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 4.1 else Block- handlerWorkerID {}, thisWorkerID :{}, workerId :{}", new Object[]{logPrefix, handlerWorkerID, thisWorkerID, workerId});
                if (handlerWorkerID != null && handlerWorkerID == workerId && (thisWorkerID == null || thisWorkerID == -1L)) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 4.2 else Block- nodeJsObject {} - isAppServerRestarted ? {} MATCH ? {} <==> {} , WorkerInfo - {}", new Object[]{logPrefix, nodeJsObject, component.isAppServerRestarted(), handlerObject, this, workerInfo});
                    try {
                        handlerObject.whileRunning = false;
                        handlerObject.closeSocketConnection(handlerObject.clientSocket);
                        handlerObject = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Object object = configSync;
                    synchronized (object) {
                        component.setHandlerObject(workerId, this);
                        this.workerID = workerId;
                    }
                }
            } else {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} - This Handler Object - {} -  is other than the dedicated - {} !!! ", new Object[]{logPrefix, this, handlerObject});
            }
        } else {
            Object object = configSync;
            synchronized (object) {
                if (handlerObject == null || !handlerObject.whileRunning) {
                    component.setHandlerObject(workerId, this);
                    this.workerID = workerId;
                }
            }
        }
        if (!ackSend) {
            this.sendResponseToProfiler("OK", streamObject, component.getID());
        }
    }

    private boolean readData(Object outStream, Object obj) {
        String messageString = obj.toString();
        if (messageString.length() == 0) {
            return true;
        }
        if (outStream instanceof ObjectOutputStream) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Data received from btm client, Data : {} {} ", new Object[]{logPrefix, messageString, this.clientSocketAddress});
        } else {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Data received from node js client, Data : {} {} ", new Object[]{logPrefix, messageString, this.clientSocketAddress});
        }
        if (messageString.equalsIgnoreCase("OFFLOAD - PING")) {
            this.sendResponseToProfiler("OFFLOAD - PONG", outStream, "");
            this.sleep(1000L);
            return !this.language.equals((Object)APMLanguage.JAVA);
        }
        int indx = messageString.indexOf("!;-;!");
        if (indx > -1) {
            String responseMessage = messageString.substring(0, indx);
            MessageHandler messageHandler = MessageHandlerFactory.getInstance().getMessageHandler(responseMessage);
            return messageHandler.handleMessage(messageString, outStream, this);
        }
        if (messageString.startsWith("DISCOVER_ME")) {
            MessageHandler messageHandler = MessageHandlerFactory.getInstance().getMessageHandler("DISCOVER_ME");
            messageHandler.handleMessage(messageString, outStream, this);
            return false;
        }
        return true;
    }

    private PrintWriter getNodeJSPrintWriter() {
        PrintWriter outWriter = null;
        try {
            outWriter = new PrintWriter(this.clientSocket.getOutputStream(), true);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to get PrintWriter for Node JS {}", (Object)logPrefix, (Object)e);
        }
        return outWriter;
    }

    private BufferedReader getNodeJSBufferedReader() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            AgentStartupLogger.logger.info("{} Got the BufferedReader for Node JS {}", (Object)logPrefix, (Object)bufferedReader);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to get BufferedReader for Node JS {}", (Object)logPrefix, (Object)e);
        }
        return bufferedReader;
    }

    private ObjectInputStream getDataInputStream() {
        ObjectInputStream inputstream = null;
        try {
            inputstream = new ObjectInputStream(this.clientSocket.getInputStream());
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to get ObjectInputStream {} ", (Object)logPrefix, (Object)e);
        }
        return inputstream;
    }

    private ObjectOutputStream getDataOutputStream() {
        ObjectOutputStream outputstream = null;
        try {
            outputstream = new ObjectOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to get ObjectOutputStream {} ", (Object)logPrefix, (Object)e);
        }
        return outputstream;
    }

    boolean isAnyDataAvailableToSend(APMComponent component, Long workerId, Long workerCount, Object outputStream) {
        HashMap infraConfig = component.getInfraTestConfig(workerId, workerCount);
        if (infraConfig != null && infraConfig.size() > 0) {
            ArrayList<Object> dataToSend = new ArrayList<Object>();
            dataToSend.add(infraConfig);
            dataToSend.add("OK");
            this.sendResponseToProfiler(dataToSend, outputStream, component.getID());
        } else {
            this.sendResponseToProfiler("OK", outputStream, component.getID());
        }
        return true;
    }

    private boolean isAnyDataAvailableToSend(APMComponent component, Long workerId, Long workerCount, Object outputStream, boolean overLoadedMethod) {
        HashMap cpcData;
        HashMap jvmConfig;
        HashMap keyPropsMap;
        HashMap propsMap;
        HashMap keyThresholdDetails;
        ArrayList<Object> dataToSend = new ArrayList<Object>();
        APMLanguage language = component.getAPMLanguage();
        HashMap thresholdDetails = component.getThresholdDetails(language.getBusinessTransTestName(), workerId, workerCount);
        if (thresholdDetails != null) {
            dataToSend.add(thresholdDetails);
        }
        if ((keyThresholdDetails = component.getThresholdDetails(language.getKeyBusinessTransTestName(), workerId, workerCount)) != null) {
            dataToSend.add(keyThresholdDetails);
        }
        if ((propsMap = component.getPropsDetails(language.getBusinessTransTestName(), workerId, workerCount)) != null && propsMap.size() > 0) {
            dataToSend.add(propsMap);
        }
        if ((keyPropsMap = component.getPropsDetails(language.getKeyBusinessTransTestName(), workerId, workerCount)) != null && keyPropsMap.size() > 0) {
            dataToSend.add(keyPropsMap);
        }
        if ((jvmConfig = component.getInfraTestConfig(workerId, workerCount)) != null && jvmConfig.size() > 0) {
            dataToSend.add(jvmConfig);
        }
        if ((cpcData = component.getCPCPatternMap(workerId, workerCount)) != null && cpcData.size() > 0) {
            dataToSend.add(cpcData);
        }
        HashMap commonGuidConfig = null;
        if (language == APMLanguage.JAVA) {
            commonGuidConfig = ((JavaAPMComponent)component).getCommonGUIDConfiguration();
        } else if (language == APMLanguage.NODEJS) {
            commonGuidConfig = ((NodeAPMComponent)component).getCommonGUIDConfiguration();
        }
        if (commonGuidConfig != null && commonGuidConfig.size() > 0) {
            dataToSend.add(commonGuidConfig);
        }
        String nodeID = component.getID();
        if (dataToSend.size() > 0) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Sending config details for the Node : {} : {} ", new Object[]{logPrefix, nodeID, dataToSend});
            dataToSend.add("OK");
            this.sendResponseToProfiler(dataToSend, outputStream, nodeID);
        } else {
            this.sendResponseToProfiler("OK", outputStream, nodeID);
        }
        return true;
    }

    void sendResponseToProfiler(Object message, Object outputStream, String nodeID) {
        if (outputStream instanceof ObjectOutputStream) {
            try {
                ObjectOutputStream outStream = (ObjectOutputStream)outputStream;
                outStream.writeObject(message);
                outStream.flush();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Agent sent message {}  to  {} - {} : {} ", new Object[]{logPrefix, message.toString(), nodeID, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in sendResponseToProfiler() while sending response to client socket  : ", (Object)logPrefix);
            }
        } else {
            try {
                String jsonString = message.toString();
                if (message instanceof ArrayList) {
                    ArrayList<HashMap> finalList = new ArrayList<HashMap>();
                    ArrayList incomingList = (ArrayList)message;
                    int i = 0;
                    while (i < incomingList.size()) {
                        if (incomingList.get(i) instanceof HashMap) {
                            HashMap incomingMap = (HashMap)incomingList.get(i);
                            if (!incomingMap.containsKey("Entity")) {
                                HashMap<String, HashMap> finalMap = new HashMap<String, HashMap>();
                                if (incomingMap.containsKey("Threshold")) {
                                    finalMap.put("ThresholdConfig", incomingMap);
                                } else if (incomingMap.containsKey("common_GUID_props")) {
                                    finalMap.put("CommonGuidConfig", incomingMap);
                                } else {
                                    finalMap.put("TestConfig", incomingMap);
                                }
                                finalList.add(finalMap);
                            } else {
                                finalList.add(incomingMap);
                            }
                        }
                        ++i;
                    }
                    jsonString = this.parseNodeJsResponseData(finalList);
                } else if (message != null && message.toString().startsWith("COMPONENT_DISCOVERD_")) {
                    jsonString = this.transmitDiscoveryDetails(message);
                }
                PrintWriter outWriter = (PrintWriter)outputStream;
                outWriter.print(jsonString);
                outWriter.flush();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Agent sent message {}  to  {} - {} : {} ", new Object[]{logPrefix, jsonString, nodeID, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in sendResponseToProfiler() while sending response to client socket  : ", (Object)logPrefix);
            }
        }
    }

    private String transmitDiscoveryDetails(Object message) {
        try {
            APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
            String discoveryWithGuid = message.toString();
            String discoveryConstant = discoveryWithGuid.substring(0, discoveryWithGuid.lastIndexOf("_"));
            String managedGuid = discoveryWithGuid.substring(discoveryWithGuid.lastIndexOf("_") + 1);
            APMComponent component = componentIDRepository.getAPMComponent(managedGuid);
            return String.valueOf(discoveryConstant) + ":-:" + managedGuid + ":-:" + component.getNickWithPort();
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in transmitDiscoveryDetails() while sending response to client socket for newly discovered component : ", (Object)logPrefix);
            return null;
        }
    }

    private String parseNodeJsResponseData(Object message) {
        String parsedObject = null;
        try {
            Gson gson = new Gson();
            parsedObject = gson.toJson(message);
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in parseNodeJsResponseData while parsing response to client socket  : ", (Object)logPrefix, (Object)e);
        }
        if (parsedObject != null) {
            parsedObject = String.valueOf(parsedObject) + "!;-;!";
        }
        return parsedObject;
    }

    boolean validateComponentGUID(String nodeID, Object outputStream) {
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Validating message {}", (Object)logPrefix, (Object)nodeID);
        if (nodeID.startsWith("DISCOVER_ME")) {
            return true;
        }
        APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
        if (componentIDRepository.isSiteIdAvailable(nodeID)) {
            if (!componentIDRepository.isOffloadComponentID(nodeID)) {
                componentIDRepository.registerStatusAsManagedOffload(nodeID);
            }
            return true;
        }
        this.sendResponseToProfiler("UNMONITORED HOST", outputStream, nodeID);
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Either NodeID: {} is not managed (or) BTM Test(s) are not configured in the eG Manager console !!!", (Object)logPrefix, (Object)nodeID);
        this.sleep(3000L);
        return false;
    }

    void sleep(Long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeServerSocket() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Connection closed {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
                this.clientSocket = null;
            }
        }
        catch (IOException e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Unable to close connection {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
        }
    }

    void closeSocketConnection(Socket clientSocket) {
        try {
            if (clientSocket != null) {
                clientSocket.close();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Connection closed {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
                clientSocket = null;
            }
        }
        catch (IOException e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Unable to close connection {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
        }
    }

    public void setRunThis(boolean runThis) {
        this.runThis = runThis;
        if (!this.runThis) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} closing {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
            this.closeServerSocket();
        }
    }

    public static String getManagedGUID(String temGUID) {
        String offload_apmdiscovery_path = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_apmdiscovery.ini";
        String guidmap_path = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_apmGuid.ini";
        IniFile inifile = new IniFile(offload_apmdiscovery_path);
        String[] uniqueGuidMapping = inifile.getLinesUnderSubject("JAVA_UNIQUE_GUID_MAPPING");
        IniFile guidmapIni = new IniFile(guidmap_path);
        String[] agmwn = guidmapIni.getLinesUnderSubject("APM_GUID_MAPPING_WITH_NICK");
        String[] stringArray = uniqueGuidMapping;
        int n = uniqueGuidMapping.length;
        int n2 = 0;
        while (n2 < n) {
            String contId_TempGuid = stringArray[n2];
            String tempGuid = contId_TempGuid.split("=")[1];
            if (tempGuid.equals(temGUID)) {
                String[] arr = contId_TempGuid.split("=")[0].split(":");
                String[] stringArray2 = agmwn;
                int n3 = agmwn.length;
                int n4 = 0;
                while (n4 < n3) {
                    String agwn1 = stringArray2[n4];
                    String[] split2 = agwn1.split("=");
                    String[] split = split2[0].split("\\^");
                    if (arr[0].equals(split[2]) && arr[1].equals(split[3]) && arr[2].equals(split[0])) {
                        return split2[1].toString();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[ClientSocketHandler = {clientSocketAddress=").append(this.clientSocketAddress);
        builder.append(", guid=").append(this.guid);
        builder.append(", nick=").append(this.nick);
        builder.append(", language=").append((Object)this.language);
        builder.append(", runThis=").append(this.runThis);
        builder.append(", whileRunning=").append(this.whileRunning);
        builder.append(", workerID=").append(this.workerID);
        builder.append("}]");
        return builder.toString();
    }
}

