/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMQueue;
import com.eg.apm.APMWorker;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.JavaAPMExceptionObject;
import com.eg.apm.JavaAPMStatusCodeObject;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.NodeAPMComponent;
import com.eg.apm.NodeBTMDataParser;
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.SnapShotTakerWatcher;
import com.eg.apm.Status;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternData;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APMNodeWorker
extends APMWorker {
    public static int counter = 1;
    protected static String loggerDispStr = "[APMNodeWorker]";
    private boolean nodeRunThis = true;
    protected final Logger log = NodeBTMLogger.nodeLogger;
    private NodeBTMDataParser nodeBTMDataParser = new NodeBTMDataParser();

    public APMNodeWorker(APMQueue<Object> myQueue2) {
        super(myQueue2);
    }

    @Override
    public void run() {
        loggerDispStr = "[APMNodeWorker] [" + Thread.currentThread().getName() + "] ";
        do {
            try {
                boolean end = false;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace(String.valueOf(loggerDispStr) + "runThis : {}", (Object)this.nodeRunThis);
                while (!end && this.nodeRunThis) {
                    block30: {
                        try {
                            MethodInfo methodInfo = null;
                            Object nodeJsObject = this.myQueue.dequeue(true);
                            if (nodeJsObject == null || !(nodeJsObject instanceof JSONArray)) break block30;
                            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} incoming node js object is : {} ", (Object)loggerDispStr, nodeJsObject);
                            ArrayList btmData = null;
                            try {
                                JSONArray jsonArrayObject = (JSONArray)nodeJsObject;
                                JSONObject jsonObject = (JSONObject)jsonArrayObject.get(0);
                                if (jsonObject.containsKey((Object)"discoveryDetails")) {
                                    this.processDiscoveryData((JSONObject)jsonObject.get((Object)"discoveryDetails"));
                                } else {
                                    btmData = this.nodeBTMDataParser.computeNodeJsData(jsonArrayObject);
                                }
                            }
                            catch (Exception e) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn(String.valueOf(loggerDispStr) + "Exception while getting btmdata");
                            }
                            if (btmData != null && btmData.size() > 0) {
                                int i = 0;
                                while (i < btmData.size()) {
                                    methodInfo = (MethodInfo)btmData.get(i);
                                    if (methodInfo != null) {
                                        Map rootProps = methodInfo.getProperties();
                                        JavaBTMOffloadLogger.btmOffLoadLogger.trace(String.valueOf(loggerDispStr) + "rootProps : {}", (Object)rootProps);
                                        String jvmGuid = (String)rootProps.get("JvmGUID");
                                        String patternString = (String)rootProps.get("PS");
                                        if (jvmGuid == null || jvmGuid.equalsIgnoreCase("")) {
                                            JavaBTMOffloadLogger.btmOffLoadLogger.warn(String.valueOf(loggerDispStr) + " No siteID from MethodInfo, So discarding this Methodinfo object");
                                        } else {
                                            APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(jvmGuid);
                                            if (component != null) {
                                                String patternObject;
                                                ComponentWatcherTracker.isWatcherNull(true);
                                                SnapShotTakerWatcher.isWatcherNull(true, jvmGuid);
                                                this.updateCommonJVMDetails(component, rootProps);
                                                if (rootProps.containsKey("isHttpStatusCodeTestEnabled")) {
                                                    boolean is404Request = (Boolean)rootProps.get("is404Request");
                                                    this.processStatusCodeDetails(rootProps, component, is404Request);
                                                }
                                                boolean firstNode = (Boolean)rootProps.get("firstNode");
                                                boolean keyTransaction = (Boolean)rootProps.get("keyTransaction");
                                                String requestType = (String)rootProps.get("requestType");
                                                UPDManager updTemp = component.getUPDManager();
                                                if (keyTransaction) {
                                                    patternObject = updTemp.manualPatternTable.get(patternString);
                                                    if (patternObject == null) {
                                                        updTemp.manualPatternTable.put(patternString, patternString);
                                                        updTemp.updateTables4Manual();
                                                    }
                                                } else {
                                                    patternObject = updTemp.autoPatternTable.get(patternString);
                                                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} patternObject Object {} ", (Object)loggerDispStr, (Object)patternObject);
                                                    if (patternObject == null) {
                                                        updTemp.autoPatternTable.put(patternString, patternString);
                                                        updTemp.updateTables4Auto();
                                                    }
                                                }
                                                if (JavaBTMOffloadLogger.btmOffLoadLogger.isDebugEnabled()) {
                                                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL : {} \t Response Time :  {} ", new Object[]{loggerDispStr, methodInfo.getRawURL(), methodInfo.getExecutionTime()});
                                                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} isFirstNode -   {}, keyTransaction -  {}, requestType -   {}", new Object[]{loggerDispStr, firstNode, keyTransaction, requestType});
                                                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} methodInfo.isErrorURL() - {}, methodInfo.isSlowURL() - {}, methodInfo.isStalled() - {}", new Object[]{loggerDispStr, methodInfo.isErrorURL(), methodInfo.isSlowURL(), methodInfo.isStalled()});
                                                }
                                                if (methodInfo.isErrorURL()) {
                                                    this.addToUPD(updTemp, methodInfo, firstNode, keyTransaction, requestType, -5L, -5L, -5L);
                                                    ArrayList incomingList = (ArrayList)rootProps.remove("NODEJS_EXCEPTION_DETAILS");
                                                    if (incomingList != null && incomingList.size() > 0) {
                                                        String eGGUID = (String)rootProps.get("GUID");
                                                        JavaAPMExceptionObject javaApmExpObj = new JavaAPMExceptionObject(eGGUID, requestType, patternString, incomingList);
                                                        component.getApmRepositoryForException().addExceptions(javaApmExpObj);
                                                    }
                                                } else if (methodInfo.isSlowURL()) {
                                                    this.addToUPD(updTemp, methodInfo, firstNode, keyTransaction, requestType, -5L, -5L, -5L);
                                                } else if (methodInfo.isStalled()) {
                                                    this.addStalledURLDetails(updTemp, methodInfo, firstNode, keyTransaction, requestType, -5L, -5L, -5L);
                                                } else {
                                                    this.updateAllUrlDetails(updTemp, methodInfo, firstNode, keyTransaction, requestType, -5L, -5L, -5L);
                                                }
                                            }
                                        }
                                    }
                                    ++i;
                                }
                            } else {
                                this.sleep(10L);
                            }
                            JavaBTMOffloadLogger.btmOffLoadLogger.trace(String.valueOf(loggerDispStr) + "Node worker while loop, methodInfo: " + methodInfo);
                        }
                        catch (Exception e) {
                            JavaBTMOffloadLogger.btmOffLoadLogger.error(String.valueOf(loggerDispStr) + " Unable to parse Methodinfo object completely... ", (Throwable)e);
                            end = true;
                        }
                    }
                    this.sleep(1L);
                }
                this.sleep(1000L);
            }
            catch (Exception e) {
                this.log.error("Error while getting btm data in apmnodeworker", (Throwable)e);
                JavaBTMOffloadLogger.btmOffLoadLogger.warn(String.valueOf(loggerDispStr) + "Exception occured in the worker thread", (Throwable)e);
                break;
            }
            this.sleep(100L);
        } while (this.nodeRunThis);
        JavaBTMOffloadLogger.btmOffLoadLogger.warn(String.valueOf(loggerDispStr) + " Worker exiting - runThis : {}", (Object)this.nodeRunThis);
    }

    private void processStatusCodeDetails(Map rootProps, APMComponent component, boolean is404Request) {
        try {
            if (is404Request) {
                double[] requestDetails = (double[])rootProps.get("Request404Details");
                JavaAPMStatusCodeObject codeObject = new JavaAPMStatusCodeObject("404", requestDetails[0], requestDetails[1], true);
                component.getApmRepositoryForStatusCode().addStatusCodes(codeObject);
            } else {
                Object statusCodeValue = rootProps.get("STATUS");
                if (statusCodeValue != null && statusCodeValue.equals("-")) {
                    return;
                }
                int statusCode = (Integer)rootProps.get("STATUS");
                String statusMesage = (String)rootProps.get("STATUS_MESSAGE");
                if (statusMesage == null) {
                    statusMesage = "-";
                }
                boolean isErrorRedirectRequest = (Boolean)rootProps.remove("REDIRECTED_ERROR_PAGE");
                String patternString = (String)rootProps.get("PS");
                String reqGUID = (String)rootProps.get("GUID");
                JavaAPMStatusCodeObject codeObject = new JavaAPMStatusCodeObject(reqGUID, patternString, String.valueOf(statusCode), statusMesage, isErrorRedirectRequest);
                component.getApmRepositoryForStatusCode().addStatusCodes(codeObject);
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} exception while updating status code repository  {} ", (Object)loggerDispStr, (Object)e);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace(String.valueOf(loggerDispStr) + "{} updated status code details in status code repository for  {}", (Object)loggerDispStr, rootProps.get("requestID"));
    }

    private void processDiscoveryData(JSONObject jsonObject) {
        HashMap<String, Object> discoveryData = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            Object data = jsonObject.get((Object)key.toString());
            if (data instanceof JSONObject) {
                Hashtable hashtable = new Hashtable();
                hashtable.putAll((JSONObject)data);
                discoveryData.put(key.toString(), hashtable);
                continue;
            }
            discoveryData.put(key.toString(), String.valueOf(data));
        }
        String jvmGUID = (String)discoveryData.get("JvmGUID");
        this.processAutoDiscovery(discoveryData, jvmGUID);
    }

    private void processAutoDiscovery(Map discoveryData, String nodeID) {
        try {
            String containerName = (String)discoveryData.get("CONTAINER_NAME");
            if (containerName != null && containerName.trim().length() > 0) {
                APMDiscoveryHelper.storeAutoDiscoveryDetails(discoveryData, nodeID);
            } else {
                APMDiscoveryLogger.discoveryLogger.debug("{} Discovery data received seems to be invalid, Hence discarding the discoverd details for {}, discovered data - {} ", new Object[]{loggerDispStr, nodeID, discoveryData});
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while getting auto discovery details !!.. so set the default value... {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private void updateCommonJVMDetails(APMComponent component, Map rootProps) {
        String[] sessionUserMapping;
        component.setHeartBeatStatus(Status.HEART_BEATING);
        String commonDetails = (String)rootProps.get("DataBaseHT");
        if (commonDetails != null && commonDetails.equalsIgnoreCase("true")) {
            String timezone = (String)rootProps.remove("TimeZone");
            Hashtable customPC = (Hashtable)rootProps.remove("CustomPC");
            component.setTimeZone(timezone);
            if (component.getAPMLanguage() == APMLanguage.NODEJS) {
                NodeAPMComponent javaComponent = (NodeAPMComponent)component;
                javaComponent.setCustomPointCuts(customPC);
            }
        }
        if ((sessionUserMapping = (String[])rootProps.remove("sessionUserMapping")) != null && sessionUserMapping.length > 0) {
            String userName = sessionUserMapping[0];
            String sessionId = sessionUserMapping[1];
            component.updateSessionUserMapping(sessionId, userName);
        }
    }

    @Override
    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateAllUrlDetails(UPDManager updTemp, MethodInfo Minfo, boolean firstNode, boolean keyTransaction, String requestType, long cpuTime, long blockedTime, long waitedTime) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug(String.valueOf(loggerDispStr) + " URL " + Minfo.getProperties().get("requestID") + "  " + Minfo.getExecutionTime() + " ms & matched patterns " + Minfo.getUrlPatternsMatched());
                String pName = Minfo.getUrlPatternsMatched();
                Map properties = Minfo.getProperties();
                URLPatternData matchingUPD = (URLPatternData)updTemp.getUPDTblWC(keyTransaction).get(pName);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} [All URL] Pattern Name : {} Matched UPD : {} Minfo : {} ", new Object[]{loggerDispStr, pName, matchingUPD, Minfo});
                if (matchingUPD != null) {
                    matchingUPD.updateAllUrlCount(Minfo, firstNode, requestType, cpuTime, blockedTime, waitedTime);
                }
            }
            catch (Exception e) {
                if (Minfo == null) break block3;
                Minfo.clearURLTree();
            }
        }
    }

    private void addToUPD(UPDManager updTemp, MethodInfo Minfo, boolean firstNode, boolean keyTransaction, String requestType, long cpuTime, long blockedTime, long waitedTime) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug(String.valueOf(loggerDispStr) + " URL " + Minfo.getProperties().get("requestID") + "  " + Minfo.getExecutionTime() + " ms & matched patterns " + Minfo.getUrlPatternsMatched());
                String pName = Minfo.getUrlPatternsMatched();
                URLPatternData matchingUPD = (URLPatternData)updTemp.getUPDTblWC(keyTransaction).get(pName);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} [addToUPD] Pattern Name : {} Matched UPD : {} Minfo : {} ", new Object[]{loggerDispStr, pName, matchingUPD, Minfo});
                if (matchingUPD != null) {
                    matchingUPD.addURLInfo(Minfo, firstNode, requestType, cpuTime, blockedTime, waitedTime);
                }
            }
            catch (Exception e) {
                if (Minfo == null) break block3;
                Minfo.clearURLTree();
            }
        }
    }

    @Override
    public void addStalledURLDetails(UPDManager updTemp, MethodInfo Minfo, boolean firstNode, boolean keyTransaction, String requestType, long cpuTime, long blockedTime, long waitedTime) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug(String.valueOf(loggerDispStr) + "Stalled URL " + Minfo.getProperties().get("requestID") + "  " + Minfo.getExecutionTime() + " ms & matched patterns " + Minfo.getUrlPatternsMatched());
                String pName = Minfo.getUrlPatternsMatched();
                URLPatternData matchingUPD = (URLPatternData)updTemp.getUPDTblWC(keyTransaction).get(pName);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} [addStalledURL] Pattern Name : {} Matched UPD : {} Minfo : {} ", new Object[]{loggerDispStr, pName, matchingUPD, Minfo});
                if (matchingUPD != null) {
                    matchingUPD.addStalledURLInfo(Minfo, firstNode, requestType, cpuTime, blockedTime, waitedTime);
                }
            }
            catch (Exception e) {
                if (Minfo == null) break block3;
                Minfo.clearURLTree();
            }
        }
    }

    @Override
    public void setRunThis(boolean runThis) {
        this.nodeRunThis = runThis;
    }
}

