/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.apm.EgLogbackManager;
import com.eg.org.slf4j.Logger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RUMAggregateStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = EgLogbackManager.getInstance().getLogger("TEST_LOGGER");
    private transient HashSet sessionList = new HashSet();
    private transient Set uniqueIPSet = new HashSet();
    private long errorCount;
    private long pageLoadTime;
    private long firstbyteTime;
    private long serverConnectionTime;
    private long responseAvailableTime;
    private long frontEndTime;
    private long documentReadyTime;
    private long documentDownloadTime;
    private long documentProcessingTime;
    private long pageRenderTime;
    private long dnsLookupTime;
    private long tcpConnectTime;
    private long sslHandshakeTime;
    private long appCacheTime;
    private long redirectionTime;
    private long browserWaitTime;
    private long unLoadTime;
    private long processingTime;
    private long onLoadEventDuration;
    private long childrenTime;
    private String pageType;
    private String pageGroup;
    private String resourceTiming;
    private long btmExecTime;
    private long pageViews;
    private long normalPageViews;
    private long slowPageViews;
    private long errorPageViews;
    private long satisfiedPageViews;
    private long toleratingPageViews;
    private long frustratedPageViews;
    private long sslRequestCount;
    private double fp;
    private double fcp;

    public double getFp() {
        return this.fp;
    }

    public double getFcp() {
        return this.fcp;
    }

    public void setFcp(long fcp) {
        this.fcp = fcp;
    }

    public void setFp(long fp) {
        this.fp = fp;
    }

    public void setUniqueIPCount(String ip) {
        try {
            if (ip != null && !ip.equalsIgnoreCase("null") && ip.length() != 0 && !ip.equals("-")) {
                this.uniqueIPSet.add(ip);
            }
        }
        catch (Exception e) {
            logger.warn("RUMAggregateStats - Exception while adding the UniqueIP" + e.getMessage());
        }
    }

    public String getUniqueIPCount() {
        String uniqueIPsString = new String("-5");
        try {
            int uniqueIPs = 0;
            if (this.uniqueIPSet != null) {
                uniqueIPs = this.uniqueIPSet.size();
            }
            if (uniqueIPs != 0) {
                uniqueIPsString = String.valueOf(uniqueIPs);
            }
        }
        catch (Exception e) {
            logger.warn("RUMAggregateStats - Exception while computing Unique IP Count" + e.getMessage());
        }
        return uniqueIPsString;
    }

    public String getUserSession() {
        int session = 0;
        if (this.sessionList != null) {
            session = this.sessionList.size();
        }
        if (session == 0) {
            session = -5;
        }
        String userSession = String.valueOf(session);
        return userSession;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public long getPageLoadTime() {
        return this.pageLoadTime;
    }

    public void setPageLoadTime(long pageLoadTime) {
        this.pageLoadTime = pageLoadTime;
    }

    public long getFirstbyteTime() {
        return this.firstbyteTime;
    }

    public void setFirstbyteTime(long firstbyteTime) {
        this.firstbyteTime = firstbyteTime;
    }

    public long getServerConnectionTime() {
        return this.serverConnectionTime;
    }

    public void setServerConnectionTime(long serverConnectionTime) {
        this.serverConnectionTime = serverConnectionTime;
    }

    public long getResponseAvailableTime() {
        return this.responseAvailableTime;
    }

    public void setResponseAvailableTime(long responseAvailableTime) {
        this.responseAvailableTime = responseAvailableTime;
    }

    public long getFrontEndTime() {
        return this.frontEndTime;
    }

    public void setFrontEndTime(long frontEndTime) {
        this.frontEndTime = frontEndTime;
    }

    public long getDocumentReadyTime() {
        return this.documentReadyTime;
    }

    public void setDocumentReadyTime(long documentReadyTime) {
        this.documentReadyTime = documentReadyTime;
    }

    public long getDocumentDownloadTime() {
        return this.documentDownloadTime;
    }

    public void setDocumentDownloadTime(long documentDownloadTime) {
        this.documentDownloadTime = documentDownloadTime;
    }

    public long getDocumentProcessingTime() {
        return this.documentProcessingTime;
    }

    public void setDocumentProcessingTime(long documentProcessingTime) {
        this.documentProcessingTime = documentProcessingTime;
    }

    public long getPageRenderTime() {
        return this.pageRenderTime;
    }

    public void setPageRenderTime(long pageRenderTime) {
        this.pageRenderTime = pageRenderTime;
    }

    public long getDnsLookupTime() {
        return this.dnsLookupTime;
    }

    public void setDnsLookupTime(long dnsLookupTime) {
        this.dnsLookupTime = dnsLookupTime;
    }

    public long getTcpConnectTime() {
        return this.tcpConnectTime;
    }

    public void setTcpConnectTime(long tcpConnectTime) {
        this.tcpConnectTime = tcpConnectTime;
    }

    public long getSslHandshakeTime() {
        return this.sslHandshakeTime;
    }

    public void setSslHandshakeTime(long sslHandshakeTime) {
        if (sslHandshakeTime > 1L) {
            ++this.sslRequestCount;
        }
        this.sslHandshakeTime = sslHandshakeTime;
    }

    public long getSslRequestCount() {
        return this.sslRequestCount;
    }

    public long getAppCacheTime() {
        return this.appCacheTime;
    }

    public void setAppCacheTime(long appCacheTime) {
        this.appCacheTime = appCacheTime;
    }

    public long getRedirectionTime() {
        return this.redirectionTime;
    }

    public void setRedirectionTime(long redirectionTime) {
        this.redirectionTime = redirectionTime;
    }

    public long getBrowserWaitTime() {
        return this.browserWaitTime;
    }

    public void setBrowserWaitTime(long browserWaitTime) {
        this.browserWaitTime = browserWaitTime;
    }

    public long getUnLoadTime() {
        return this.unLoadTime;
    }

    public void setUnLoadTime(long unLoadTime) {
        this.unLoadTime = unLoadTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getOnLoadEventDuration() {
        return this.onLoadEventDuration;
    }

    public void setOnLoadEventDuration(long onLoadEventDuration) {
        this.onLoadEventDuration = onLoadEventDuration;
    }

    public long getChildrenTime() {
        return this.childrenTime;
    }

    public void setChildrenTime(long childrenTime) {
        this.childrenTime = childrenTime;
    }

    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public String getResourceTiming() {
        return this.resourceTiming;
    }

    public void setResourceTiming(String resourceTiming) {
        this.resourceTiming = resourceTiming;
    }

    public long getBtmExecTime() {
        return this.btmExecTime;
    }

    public void setBtmExecTime(long btmExecTime) {
        this.btmExecTime = btmExecTime;
    }

    public String getPageGroup() {
        return this.pageGroup;
    }

    public void setPageGroup(String pageGroup) {
        this.pageGroup = pageGroup;
    }

    public long getPageViews() {
        return this.pageViews;
    }

    public void setPageViews(long pageViews) {
        this.pageViews = pageViews;
    }

    public long getNormalPageViews() {
        return this.normalPageViews;
    }

    public void setNormalPageViews(long normalPageViews) {
        this.normalPageViews = normalPageViews;
    }

    public long getSlowPageViews() {
        return this.slowPageViews;
    }

    public void setSlowPageViews(long slowPageViews) {
        this.slowPageViews = slowPageViews;
    }

    public long getErrorPageViews() {
        return this.errorPageViews;
    }

    public void setErrorPageViews(long errorPageViews) {
        this.errorPageViews = errorPageViews;
    }

    public long getSatisfiedPageViews() {
        return this.satisfiedPageViews;
    }

    public void setSatisfiedPageViews(long satisfiedPageViews) {
        this.satisfiedPageViews = satisfiedPageViews;
    }

    public long getToleratingPageViews() {
        return this.toleratingPageViews;
    }

    public void setToleratingPageViews(long toleratingPageViews) {
        this.toleratingPageViews = toleratingPageViews;
    }

    public long getFrustratedPageViews() {
        return this.frustratedPageViews;
    }

    public void setFrustratedPageViews(long frustratedPageViews) {
        this.frustratedPageViews = frustratedPageViews;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RUMAggregateStats [sessionList=").append(this.sessionList).append(", uniqueIPSet=").append(this.uniqueIPSet);
        builder.append(", errorCount=").append(this.errorCount).append(", pageLoadTime=").append(this.pageLoadTime);
        builder.append(", firstbyteTime=").append(this.firstbyteTime).append(", serverConnectionTime=").append(this.serverConnectionTime);
        builder.append(", responseAvailableTime=").append(this.responseAvailableTime).append(", frontEndTime=");
        builder.append(this.frontEndTime).append(", documentReadyTime=").append(this.documentReadyTime).append(", documentDownloadTime=");
        builder.append(this.documentDownloadTime).append(", documentProcessingTime=").append(this.documentProcessingTime);
        builder.append(", pageRenderTime=").append(this.pageRenderTime).append(", dnsLookupTime=").append(this.dnsLookupTime);
        builder.append(", tcpConnectTime=").append(this.tcpConnectTime).append(", sslHandshakeTime=").append(this.sslHandshakeTime);
        builder.append(", appCacheTime=").append(this.appCacheTime).append(", redirectionTime=").append(this.redirectionTime);
        builder.append(", browserWaitTime=").append(this.browserWaitTime).append(", pageType=").append(this.pageType);
        builder.append(", pageGroup=").append(this.pageGroup).append(", resourceTiming=").append(this.resourceTiming);
        builder.append(", btmExecTime=").append(this.btmExecTime).append(", pageViews=").append(this.pageViews).append(", normalPageViews=");
        builder.append(this.normalPageViews).append(", slowPageViews=").append(this.slowPageViews).append(", errorPageViews=");
        builder.append(this.errorPageViews).append(", satisfiedPageViews=").append(this.satisfiedPageViews).append(", toleratingPageViews=");
        builder.append(this.toleratingPageViews).append(", frustratedPageViews=");
        builder.append(this.frustratedPageViews).append(", sslRequestCount=").append(this.sslRequestCount);
        builder.append(", firstPaint=").append(this.fp);
        builder.append(", firstContentfulPaintTime=").append(this.fcp).append("]");
        return builder.toString();
    }

    public String toString1() {
        return "Page Views - " + this.pageViews + "*****" + "Page Load Time -  " + this.pageLoadTime;
    }
}

