/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class XIOXBricksTest
extends XtremIOBase {
    private static final int XTREM_IO_X_BRICKS_MEASURE_COUNT = 3;

    public XIOXBricksTest(String[] stringArray) {
        super(stringArray);
        try {
            this.setMeasureCount(3);
        }
        catch (Exception exception) {
            this.printOut("Error in constructor " + exception.toString());
            this.putErrorMessageToLogfile("Error in constructor " + exception.toString());
        }
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        try {
            long l = System.currentTimeMillis();
            Hashtable hashtable2 = this.getXBricks();
            System.out.println("XBricks  :" + hashtable2);
            this.printOut("xBricksHashtable " + hashtable2, false);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                if (string2.lastIndexOf("/") > -1 && this.xioAPIVersion > 1.0) {
                    object = string2;
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("/"));
                    this.printOut("Temp href :" + (String)object);
                    string2 = (String)object + "?name=" + string + "&cluster-name=" + this.monitoredCluster;
                }
                this.printOut("XBrick Name  :" + string + " href  :" + string2);
                object = this.xBrickdata(string2);
                if (object != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
                    this.printOut("XBrick Name  :" + string + " measureArrayList  :" + object, true);
                    if (bl) continue;
                    this.addNewMeasure(string, (ArrayList)object);
                    continue;
                }
                for (int i = 0; i < 3; ++i) {
                    ((ArrayList)object).add(new Double(-5.0));
                }
                if (!bl) {
                    this.addNewMeasure(string, (ArrayList)object);
                }
                this.printOut("XBrick Name  :" + string + " measureArrayList(Passing defaultvalues) :" + object, true);
            }
            long l2 = System.currentTimeMillis();
            this.printOut("Total time(millis) took to this computeMeasure call :" + (l2 - l));
        }
        catch (Exception exception) {
            this.printOut("Error in debugComputeMeasure " + exception.toString());
            this.putErrorMessageToLogfile("Error in debugComputeMeasure " + exception.toString());
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        XIOXBricksTest xIOXBricksTest = new XIOXBricksTest(stringArray);
        xIOXBricksTest.debugComputeMeasures(new Hashtable(), true);
    }

    private ArrayList xBrickdata(String string) {
        ArrayList<Double> arrayList;
        block4: {
            arrayList = new ArrayList<Double>();
            try {
                String string2 = this.getJSONDataFromURL(string);
                JSONObject jSONObject = null;
                if (string2 == null || string2.length() <= 0) break block4;
                JSONParser jSONParser = new JSONParser();
                try {
                    jSONObject = (JSONObject)jSONParser.parse(string2);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"content");
                String string3 = (String)jSONObject2.get((Object)"brick-state");
                double d = this.xBrickStatus(string3);
                this.printOut("XEnv state  :" + d);
                arrayList.add(new Double(d));
                double d2 = this.getValueFromJSONObject(jSONObject2, "num-of-ssds", true);
                this.printOut("No Of SSDs   :" + d2);
                arrayList.add(new Double(d2));
                double d3 = this.noOfBatteryUnits(jSONObject2, "ups-list");
                arrayList.add(new Double(d3));
            }
            catch (Exception exception) {
                this.printOut("Error in xBrickdata " + exception.toString());
                this.putErrorMessageToLogfile("Error in  xBrickdata" + exception.toString());
            }
        }
        return arrayList;
    }

    private double xBrickStatus(String string) {
        double d = -5.0;
        try {
            d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("in_sys") ? 0.0 : 1.0);
        }
        catch (Exception exception) {
            this.printOut("Error in xBrickStatus " + exception.toString());
            this.putErrorMessageToLogfile("Error in  xBrickStatus" + exception.toString());
        }
        return d;
    }

    double noOfBatteryUnits(JSONObject jSONObject, String string) {
        double d = 0.0;
        if (jSONObject == null || jSONObject.isEmpty()) {
            this.printOut("jsonObject is  null or empty for the parameter :" + string);
            return d;
        }
        try {
            JSONArray jSONArray = (JSONArray)jSONObject.get((Object)string);
            if (jSONArray != null) {
                d = jSONArray.size();
            }
        }
        catch (Exception exception) {
            this.printOut("Error in noOfBatteryUnits " + exception.toString());
            this.putErrorMessageToLogfile("Error in noOfBatteryUnits " + exception.toString());
        }
        return d;
    }
}

