/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class XIOSCSASPortTest
extends XtremIOBase {
    private static final int XTREM_IO_SC_SAS_PORT_MEASURE_COUNT = 2;

    public XIOSCSASPortTest(String[] stringArray) {
        super(stringArray);
        try {
            this.setMeasureCount(2);
        }
        catch (Exception exception) {
            this.printOut("Error in constructor " + exception.toString());
            this.putErrorMessageToLogfile("Error in constructor " + exception.toString());
        }
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        if (this.xioAPIVersion <= 1.0) {
            this.printOut("This test supports EMC XtremIO API version 2 and above only ");
            this.putWarningMessageToLogfile("This test supports EMC XtremIO API version 2 and above only ");
            return;
        }
        Hashtable hashtable2 = this.getStorageControllers();
        if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
            this.printOut("Could not collect the  data ,so test returing ");
            this.putWarningMessageToLogfile("Could not collect the  data ,so test returing ");
            return;
        }
        this.printOut("SC SAS Ports   :" + hashtable2, debug);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2.lastIndexOf("/") > -1 && this.xioAPIVersion > 1.0) {
                object = string2;
                object = ((String)object).substring(0, ((String)object).lastIndexOf("/"));
                this.printOut("Temp href :" + (String)object);
                string2 = (String)object + "?name=" + string + "&cluster-name=" + this.monitoredCluster;
            }
            this.printOut("SC  Name  :" + string + " href  :" + string2);
            object = this.scSASPortdata(string2);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (object != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
                Double d = (Double)((ArrayList)object).get(0);
                Double d2 = (Double)((ArrayList)object).get(1);
                arrayList.add(d);
                arrayList.add(d2);
                if (!bl) {
                    this.addNewMeasure(string + "/sas1", arrayList);
                }
                this.printOut("SC  Name  :" + string + "/sas1" + " measureArrayList  :" + arrayList, true);
                arrayList = new ArrayList();
                Double d3 = (Double)((ArrayList)object).get(2);
                Double d4 = (Double)((ArrayList)object).get(3);
                arrayList.add(d3);
                arrayList.add(d4);
                if (!bl) {
                    this.addNewMeasure(string + "/sas2", arrayList);
                }
                this.printOut("SC  Name  :" + string + "/sas2" + " measureArrayList  :" + arrayList, true);
                continue;
            }
            for (int i = 0; i < 2; ++i) {
                arrayList.add(new Double(-5.0));
            }
            if (!bl) {
                this.addNewMeasure(string, arrayList);
            }
            this.printOut("SC  Name  :" + string + " measureArrayList(Passing defaultvalues) :" + arrayList, true);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        XIOSCSASPortTest xIOSCSASPortTest = new XIOSCSASPortTest(stringArray);
        xIOSCSASPortTest.debugComputeMeasures(new Hashtable(), true);
    }

    private ArrayList scSASPortdata(String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = this.getJSONDataFromURL(string);
        JSONObject jSONObject = null;
        if (string2 != null && string2.length() > 0) {
            JSONParser jSONParser = new JSONParser();
            try {
                jSONObject = (JSONObject)jSONParser.parse(string2);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"content");
            String string3 = (String)jSONObject2.get((Object)"sas1-hba-port-health-level");
            double d = this.sasHBAPortHealthState(string3);
            arrayList.add(new Double(d));
            String string4 = (String)jSONObject2.get((Object)"sas1-port-state");
            double d2 = this.sasPortState(string4);
            arrayList.add(new Double(d2));
            String string5 = (String)jSONObject2.get((Object)"sas2-hba-port-health-level");
            double d3 = this.sasHBAPortHealthState(string5);
            arrayList.add(new Double(d3));
            String string6 = (String)jSONObject2.get((Object)"sas2-port-state");
            double d4 = this.sasPortState(string6);
            arrayList.add(new Double(d4));
        }
        return arrayList;
    }

    private double sasHBAPortHealthState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("level_1_clear") ? 0.0 : (string.equalsIgnoreCase("level_2_unknown") ? 1.0 : (string.equalsIgnoreCase("level_3_warning") ? 2.0 : (string.equalsIgnoreCase("level_4_minor") ? 4.0 : (string.equalsIgnoreCase("level_5_major") ? 5.0 : (string.equalsIgnoreCase("level_6_critical") ? 6.0 : -1.0))))));
        return d;
    }

    private double sasPortState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("up") ? 0.0 : (string.equalsIgnoreCase("down") ? 1.0 : -1.0));
        return d;
    }
}

