/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;

public class WsThreadPoolTest
extends EgWebSphere {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String userPassword = "none";
    private String server = "";
    private String ssl = "";
    private String serverName = null;
    private static int threadCreationRateIndex = 0;
    private static int threadDestroyRateIndex = 1;
    private static int activeThreadsIndex = 2;
    private static int poolSizeIndex = 3;
    private static int percentMaxedIndex = 4;
    private double threadCreationRate = 0.0;
    private double threadDestroyRate = 0.0;
    private double activeThreads = 0.0;
    private double poolSize = 0.0;
    private double percentMaxed = 0.0;
    private String tempHost = "";

    public WsThreadPoolTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 5;
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        this.ssl = this.getValueForParam("ssl");
        if (this.ssl != null) {
            this.isSsl = new Boolean(this.ssl);
        }
        if (this.serverName == null || this.serverName.equalsIgnoreCase("localhost")) {
            this.serverName = this.getHostName();
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.user != null && !this.user.equalsIgnoreCase("none")) {
            this.userPassword = this.user + ":" + EgCrypt.decrypt(this.password);
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public static void main(String[] stringArray) {
        WsThreadPoolTest wsThreadPoolTest = new WsThreadPoolTest(stringArray);
        wsThreadPoolTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
            String string2 = this.url + "/" + this.uri + "?module=threadPoolModule&summary=true&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
            ArrayList arrayList = this.returnMeasures(string2, "threadPool", this.isSsl, this.userPassword);
            if (arrayList == null) {
                this.prevValues = new Hashtable();
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            this.tokenizeMeasureString(arrayList);
            String[] stringArray = this.getInfo();
            if (stringArray == null || stringArray.length == 0) {
                this.prevValues = new Hashtable();
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith("threadPoolModule")) continue;
                String string3 = string + stringArray[i];
                this.threadCreationRate = this.getValue(stringArray[i], "threadCreates", true);
                this.threadDestroyRate = this.getValue(stringArray[i], "threadDestroys", true);
                if (this.timeSinceLastTest > 0.0) {
                    this.threadCreationRate /= this.timeSinceLastTest;
                    this.threadDestroyRate /= this.timeSinceLastTest;
                    if (this.threadCreationRate < 0.0 || this.threadDestroyRate < 0.0) {
                        this.threadCreationRate = -1.0;
                        this.threadDestroyRate = -1.0;
                    }
                } else {
                    this.threadCreationRate = -1.0;
                    this.threadDestroyRate = -1.0;
                }
                double d = this.getValue(stringArray[i], "activeThreads", false);
                double d2 = this.getValue(stringArray[i], "poolSize", false);
                double d3 = this.getValue(stringArray[i], "percentMaxed", false);
                this.addValueToResultSet(string3, threadCreationRateIndex, this.threadCreationRate);
                this.addValueToResultSet(string3, threadDestroyRateIndex, this.threadDestroyRate);
                this.addValueToResultSet(string3, activeThreadsIndex, d);
                this.addValueToResultSet(string3, poolSizeIndex, d2);
                this.addValueToResultSet(string3, percentMaxedIndex, d3);
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            this.updateAllResultSets();
            return true;
        }
    }
}

