/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.net.URLEncoder;
import java.util.ArrayList;

public class WsSrvltSessionTest
extends EgWebSphere {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String userPassword = "none";
    private String serverName = null;
    private String server = "";
    private static int sessionCreationRateIndex = 0;
    private static int invalidatedSessionsIndex = 1;
    private static int sessionLifeTimeIndex = 2;
    private static int activeSessionsIndex = 3;
    private static int liveSessionsIndex = 4;
    private double sessionCreationRate = 0.0;
    private double invalidatedSessions = 0.0;
    private double sessionLifeTime = 0.0;
    private double activeSessions = 0.0;
    private double liveSessions = 0.0;
    private String tempHost = "";

    public WsSrvltSessionTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 5;
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        String string = this.getValueForParam("ssl");
        if (string != null) {
            this.isSsl = new Boolean(string);
        }
        if (this.serverName == null || this.serverName.equalsIgnoreCase("localhost")) {
            this.serverName = this.getHostName();
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.user != null && !this.user.equalsIgnoreCase("none")) {
            this.userPassword = this.user + ":" + EgCrypt.decrypt(this.password);
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public static void main(String[] stringArray) {
        WsSrvltSessionTest wsSrvltSessionTest = new WsSrvltSessionTest(stringArray);
        wsSrvltSessionTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
            String string2 = this.url + "/" + this.uri + "?module=servletSessionsModule&summary=true&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
            ArrayList arrayList = this.returnMeasures(string2, "servletSessions", this.isSsl, this.userPassword);
            if (arrayList == null) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            this.tokenizeMeasureString(arrayList);
            String[] stringArray = this.getInfo();
            if (stringArray == null || stringArray.length == 0) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = new String();
                int n = stringArray[i].lastIndexOf("servletSessionsModule");
                if (n < 0) continue;
                string3 = stringArray[i].substring(0, n - 1);
                String string4 = string + string3;
                this.sessionCreationRate = this.getValue(stringArray[i], "createdSessions", true);
                this.sessionCreationRate = this.timeSinceLastTest > 0.0 ? (this.sessionCreationRate /= this.timeSinceLastTest) : -1.0;
                this.invalidatedSessions = this.getValue(stringArray[i], "invalidatedSessions", true);
                this.sessionLifeTime = this.getValue(stringArray[i], "sessionLifeTime", true);
                if (this.sessionLifeTime > 0.0) {
                    this.sessionLifeTime /= 1000.0;
                }
                if (this.sessionCreationRate < 0.0 || this.invalidatedSessions < 0.0 || this.sessionLifeTime < 0.0) {
                    this.sessionCreationRate = -1.0;
                    this.invalidatedSessions = -1.0;
                    this.sessionLifeTime = -1.0;
                }
                this.activeSessions = this.getValue(stringArray[i], "activeSessions", false);
                this.liveSessions = this.getValue(stringArray[i], "liveSessions", false);
                this.addValueToResultSet(string4, sessionCreationRateIndex, this.sessionCreationRate);
                this.addValueToResultSet(string4, invalidatedSessionsIndex, this.invalidatedSessions);
                this.addValueToResultSet(string4, sessionLifeTimeIndex, this.sessionLifeTime);
                this.addValueToResultSet(string4, activeSessionsIndex, this.activeSessions);
                this.addValueToResultSet(string4, liveSessionsIndex, this.liveSessions);
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            this.updateAllResultSets();
            return true;
        }
    }
}

