/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WebsphereValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String uri = "egurkha/Websphere.jsp";
    public String webServerPort = "80";
    public String url = "";
    public String connectorport = "none";
    public String user = "none";
    public String password = "none";
    public String serverHostName = null;
    public String serverName = null;
    public String nodeName = null;
    public String ssl = null;
    public boolean isSsl = false;
    private long timeout;
    public boolean isConnectivityOk = false;
    public boolean isTableInfoComing = true;
    public boolean meAgentLess = false;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();

    public WebsphereValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-appport")) {
                    this.webServerPort = string3;
                    this.app_port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-serverhostname")) {
                    this.serverHostName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-nodename")) {
                    this.nodeName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-servername")) {
                    this.serverName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-connectorport")) {
                    this.connectorport = string3;
                    this.connector_port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    this.ssl = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                    } else {
                        this.isAgentLess = "false";
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                }
                if ("true".equalsIgnoreCase(this.ssl)) {
                    this.url = "https://";
                    this.isSsl = true;
                    continue;
                }
                this.url = "http://";
            }
            this.nodeName = URLEncoder.encode(this.nodeName);
            this.serverHostName = URLEncoder.encode(this.serverHostName);
            this.serverName = URLEncoder.encode(this.serverName);
            this.user = URLEncoder.encode(this.user);
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.host;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void validate() {
        try {
            if (!this.isIPReachable()) {
                String string = this.host;
                if (this.url != null && !this.url.equals("")) {
                    string = this.admin_host;
                }
                this.validationMsgs.add("Websphere Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + string + "' is invalid or Host IP/Name is unreachable");
                this.validationMsgs.add("Port$#$NA");
                this.validationMsgs.add("Websphere SOAP Connector Port$#$NA");
            } else if (!this.isPortReachable()) {
                this.validationMsgs.add("Websphere Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$Port settings is incorrect or Websphere is down");
                this.validationMsgs.add("Websphere SOAP Connector Port$#$NA");
            } else if (!this.isConnectorPortReachable()) {
                this.validationMsgs.add("Websphere Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("Websphere SOAP Connector Port$#$Websphere SOAP Connector Port Settings  is incorrect");
            } else {
                this.validationMsgs.add("Websphere Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("Websphere SOAP Connector Port$#$OK");
                this.validationMsgs.add("Specific_Error_Msg$#$Please validate Websphere Username/Password and other related params!");
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getNBTName(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = !this.isTargetIp ? "nbtstat -a " + string : "nbtstat -A " + string;
        String string3 = string;
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        ArrayList arrayList2 = null;
        String string4 = null;
        if (arrayList != null && (arrayList2 = (ArrayList)arrayList.get(0)) != null) {
            int n = arrayList2.size();
            if (n <= 0) {
                return string3;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                string4 = (String)arrayList2.get(i);
                if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("Name") || string4.startsWith("-") || (n3 = (stringTokenizer = new StringTokenizer(string4)).countTokens()) < 3 || string4.indexOf("<00>") <= 0 || string4.indexOf("UNIQUE") <= 0) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.endsWith("<00>")) {
                    n2 = string3.indexOf("<00>");
                    string3 = string3.substring(0, n2);
                }
                if (string3.indexOf("~") >= 0) continue;
                n2 = string3.indexOf("~");
                string3 = string3.toLowerCase().trim();
                break;
            }
        }
        return string3;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }
}

