/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WeblogicValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String sid = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String version = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String useWarFile = "";
    public String url = "";
    public String protocol = "t3";
    static final String EGURKHA_NAME = "egurkha";
    static final String EGURKHA_MONITOR = "monitoring";
    public String weblogicJarLoc = "";
    private long timeout;
    public boolean isConnectivityOk = false;
    public boolean isSqlInstanceOk = false;
    public boolean isTableInfoComing = true;
    public boolean isAdminRole = true;
    public boolean meAgentLess = false;
    public boolean isSsl = false;
    private String server = "";
    private String ssl = "false";
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private String tempHost = "";

    public WeblogicValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-server")) {
                    this.server = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-version")) {
                    this.version = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    this.ssl = string3;
                    if (this.ssl == null || !this.ssl.equalsIgnoreCase("true")) continue;
                    this.isSsl = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-useWarFile")) {
                    this.useWarFile = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-url")) {
                    this.url = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-weblogicJarLocation")) continue;
                this.weblogicJarLoc = string3;
            }
        }
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.server;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void validate() {
        try {
            if (!this.checkWeblogicConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (!this.isIPReachable()) {
                    String string = this.host;
                    if (this.url != null && !this.url.equals("")) {
                        string = this.admin_host;
                    }
                    this.validationMsgs.add("Weblogic Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + string + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Weblogic Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect or Weblogic is down");
                } else {
                    this.validationMsgs.add("Weblogic Server Connectivity$#$" + this.validationErrorMsg);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("Weblogic Server Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkWeblogicConnectivity() {
        this.isWebLogic = true;
        if (this.url == null || this.url.equals("")) {
            this.tempHost = IPV6Helper.getValidIPAddress(this.host);
            if (this.isSsl) {
                this.url = "https://" + this.tempHost + ":" + this.port;
                this.protocol = "t3s";
            } else {
                this.url = "http://" + this.tempHost + ":" + this.port;
                this.protocol = "t3";
            }
        } else {
            this.admin_host = this.url.substring(this.url.indexOf(":") + 3, this.url.lastIndexOf(":")).trim();
            if (this.admin_host != null && this.admin_host.length() != 0 && this.admin_host.startsWith("[") && this.admin_host.endsWith("]")) {
                this.admin_host = this.admin_host.substring(1, this.admin_host.length() - 1);
            }
            this.admin_port = this.url.substring(this.url.lastIndexOf(":") + 1, this.url.length()).trim();
        }
        String string = "";
        String string2 = "";
        HttpURLConnection httpURLConnection = null;
        Object var4_4 = null;
        Object var5_5 = null;
        ArrayList arrayList = new ArrayList();
        String string3 = null;
        boolean bl = false;
        if (this.version != null && this.version.trim().length() > 0 && this.version.equalsIgnoreCase("12")) {
            bl = true;
        }
        try {
            string3 = bl ? this.url + "/egurkha/WLServerTestUsingJMX.jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.host + "&port=" + this.port + "&server=" + this.server + "&debug=true" : this.url + "/egurkha/WLServerTest.jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.host + "&port=" + this.port + "&server=" + this.server + "&debug=true";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        URL uRL = null;
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.isSsl) {
                object3 = EgSSL.getInstance();
                EgSSL.enableSSL();
                object2 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var12_15 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                object = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, (TrustManager[])object, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            uRL = new URL(string3);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            object3 = new ConnectionThread(httpURLConnection, false);
            object2 = null;
            int n = 0;
            boolean bl2 = this.checkForTimeout((ConnectionThread)object3);
            if (bl2) {
                n = ((ConnectionThread)object3).code;
                object2 = ((ConnectionThread)object3).data;
            }
            object3 = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl2 || n != 200) {
                this.isConnectivityOk = false;
                if (!bl2) {
                    this.validationErrorMsg = "No Response from server";
                }
                this.validationErrorMsg = n == 500 ? "Error 500 - No Response from server due to internal server error" : (n == 404 ? "Error 404 - No Response from server due to 'egurkha' application is not found on the server" : (n == 503 ? "Error 503 - The server is currently unavailable or not started" : "Oops ! Please validate other params for the weblogic like SSL,JarLocation etc"));
                return this.isConnectivityOk;
            }
            if (object2 == null || ((ArrayList)object2).size() == 0) {
                this.isConnectivityOk = false;
                this.validationErrorMsg = "No data has been receieved";
                return this.isConnectivityOk;
            }
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                object = (String)((ArrayList)object2).get(i);
                if (object == null || ((String)object).equals("")) continue;
                if (object != null && ((String)object).indexOf("RUNNING") > 0) {
                    this.isConnectivityOk = true;
                    break;
                }
                if (((String)object).indexOf("javax.security.auth.login.FailedLoginException:") > -1 || ((String)object).indexOf("javax.naming.AuthenticationException:") > -1) {
                    this.validationErrorMsg = "Invalid username/password; logon denied";
                    this.isConnectivityOk = false;
                    break;
                }
                if (((String)object).indexOf("javax.naming.NameNotFoundException:") > -1 || ((String)object).indexOf("javax.management.InstanceNotFoundException:") > -1) {
                    this.validationErrorMsg = "Connection Failed; Invalid Server Name ' " + this.server + " '";
                    this.isConnectivityOk = false;
                    break;
                }
                this.validationErrorMsg = object;
            }
        }
        catch (Exception exception) {
            String string4;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            String string5 = this.getStackTraceAsString(exception);
            this.validationErrorMsg = string4 = string5.substring(0, string5.indexOf("at"));
            this.isConnectivityOk = false;
        }
        return this.isConnectivityOk;
    }

    public String getNBTName(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = !this.isTargetIp ? "nbtstat -a " + string : "nbtstat -A " + string;
        String string3 = string;
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        ArrayList arrayList2 = null;
        String string4 = null;
        if (arrayList != null && (arrayList2 = (ArrayList)arrayList.get(0)) != null) {
            int n = arrayList2.size();
            if (n <= 0) {
                return string3;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                string4 = (String)arrayList2.get(i);
                if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("Name") || string4.startsWith("-") || (n3 = (stringTokenizer = new StringTokenizer(string4)).countTokens()) < 3 || string4.indexOf("<00>") <= 0 || string4.indexOf("UNIQUE") <= 0) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.endsWith("<00>")) {
                    n2 = string3.indexOf("<00>");
                    string3 = string3.substring(0, n2);
                }
                if (string3.indexOf("~") >= 0) continue;
                n2 = string3.indexOf("~");
                string3 = string3.toLowerCase().trim();
                break;
            }
        }
        return string3;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }
}

