/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class WebAdapterTest
extends EgTest {
    public String host;
    public String port;
    public int thisPort;
    public String serverType;
    public int shmId = -1;
    public int numStructures = 0;
    public String hostIpAddress;
    public String fileName = null;
    public String lockFileName = EgConfigInfo.webAdapterLockFile;
    private File lock = null;
    public String[] srvrAddress;
    public String[] srvrPorts;
    public static Properties serverSharedId = new Properties();
    public static Hashtable shmIdTestObjects = new Hashtable();
    public static Boolean lockForConfigChanges = new Boolean(true);
    public static final Comparator DATE_COMPARE = new Comparator(){
        private Date d1 = new Date();
        private Date d2 = new Date();

        public int compare(Object object, Object object2) {
            File file = new File((String)object);
            File file2 = new File((String)object2);
            this.d1.setTime(file.lastModified());
            this.d2.setTime(file2.lastModified());
            return this.d2.compareTo(this.d1);
        }
    };

    public void stopTest() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 8) {
            System.out.println("Usage:-  java WebAdapterTest  -host <host> -port <portNo> -period <period>-hostIp <hostIpAddress>");
            return;
        }
        WebAdapterTest webAdapterTest = new WebAdapterTest(stringArray);
        if (webAdapterTest.searchFiles()) {
            System.out.println(webAdapterTest.fileName);
        }
        for (int i = 0; i < 5; ++i) {
            if (!webAdapterTest.isFileExist()) {
                System.out.println("File is gone ..");
                break;
            }
            System.out.println(" file exist.." + webAdapterTest.fileName);
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public WebAdapterTest() {
    }

    public WebAdapterTest(String[] stringArray) {
        super(stringArray);
        if (stringArray.length < 8) {
            System.out.println("Please pass 8 parametes in same order and datatype");
            System.out.println("Usage:- -host <host> -port <portNo>-period <period> -hostIp <hostIp>");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-host")) {
                this.targetHost = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-port")) {
                this.portNo = stringArray[++i];
                try {
                    this.thisPort = Integer.parseInt(this.portNo);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Argument port is not a Number");
                    numberFormatException.printStackTrace();
                    return;
                }
            }
            if (!stringArray[i].equalsIgnoreCase("-hostIp")) continue;
            this.hostIpAddress = stringArray[++i];
        }
    }

    public boolean searchFiles() {
        boolean bl = false;
        File file = new File(egConfigDir);
        String[] stringArray = file.list();
        Arrays.sort(stringArray, DATE_COMPARE);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("webadapter") || !this.openWebAdapterFile(egConfigDir + stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean openWebAdapterFile(String string) {
        boolean bl = false;
        this.srvrAddress = new String[0];
        this.srvrPorts = new String[0];
        try {
            String string2 = null;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            while ((string2 = dataInputStream.readLine()) != null) {
                if (string2.startsWith("Listen")) {
                    int n = string2.indexOf("=");
                    string2 = string2.substring(n + 1);
                    string2.trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        if (!this.parseToken(stringTokenizer.nextToken())) continue;
                        bl = true;
                        this.fileName = string;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                    stringTokenizer = new StringTokenizer(string2, ",");
                    int n2 = stringTokenizer.countTokens();
                    this.srvrAddress = new String[n2];
                    this.srvrPorts = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        String string3 = stringTokenizer.nextToken();
                        string3.trim();
                        int n3 = string3.indexOf(":");
                        if (n3 >= 0) {
                            this.srvrAddress[i] = new String(string3.substring(0, n3));
                            this.srvrPorts[i] = new String(string3.substring(n3 + 1));
                            continue;
                        }
                        this.srvrAddress[i] = null;
                        this.srvrPorts[i] = null;
                    }
                    continue;
                }
                this.getConfigDatas(string2);
            }
            dataInputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return bl;
        }
    }

    private void getConfigDatas(String string) {
        if (string.startsWith("Shmid=")) {
            int n = string.indexOf("=");
            String string2 = string.substring(n + 1);
            this.shmId = new Integer(string2);
        } else if (string.startsWith("Structures=")) {
            int n = string.indexOf("=");
            String string3 = string.substring(n + 1);
            this.numStructures = new Integer(string3);
        } else if (string.startsWith("Server_Type=")) {
            int n = string.indexOf("=");
            this.serverType = string.substring(n + 1);
        }
    }

    boolean parseToken(String string) {
        InetAddress inetAddress;
        string.trim();
        int n = string.indexOf(":");
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        int n2 = new Integer(string2);
        string3.trim();
        if (string3.equals("*") && n2 == this.thisPort || string3.equals("_default_") && n2 == this.thisPort || string3.equals("0.0.0.0") && n2 == this.thisPort) {
            return true;
        }
        if (n2 != this.thisPort) {
            System.out.println("Ports dont match " + n2 + " " + this.thisPort);
            return false;
        }
        if (this.isIpAddress(string3)) {
            if (string3.equals(this.hostIpAddress)) {
                return true;
            }
            System.out.println("IPS dont match! " + string3 + " " + this.hostIpAddress);
            return false;
        }
        try {
            inetAddress = InetAddress.getByName(string3);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("getbyName error " + string3 + " " + unknownHostException.toString());
            return false;
        }
        String string4 = inetAddress.getHostAddress();
        if (string4 != null && string4.equals(this.hostIpAddress)) {
            return true;
        }
        System.out.println("NOT MATCHED FOR WEB ADAPTER!!!! " + string4 + " " + this.hostIpAddress);
        return false;
    }

    public boolean isFileExist() {
        if (this.shmId == -1 || this.fileName == null || this.fileName.length() == 0) {
            return false;
        }
        boolean bl = false;
        try {
            Object var3_2 = null;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
            bl = true;
            dataInputStream.close();
        }
        catch (Exception exception) {
            bl = false;
            this.fileName = null;
            this.shmId = -1;
            this.numStructures = -1;
            this.serverType = null;
        }
        return bl;
    }

    public boolean getExclusiveAccess() {
        int n;
        this.lock = new File(this.lockFileName);
        boolean bl = false;
        EgDateInfo egDateInfo = new EgDateInfo();
        for (n = 0; n < 5; ++n) {
            try {
                bl = this.lock.createNewFile();
                this.lock.deleteOnExit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) break;
            this.sleepCurrentThread(2000L);
        }
        return n != 5;
    }

    private void sleepCurrentThread(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void deleteLockFile() {
        this.lock.delete();
        this.lock = null;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

