/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WLEJBCacheTest
extends WLBaseTest_F {
    private double activationCount_last = -5.0;
    private double passivationCount_last = -5.0;
    private double cacheHitCount_last = -5.0;
    private double cacheAccessCount_last = -5.0;
    private Hashtable lastMeasures = new Hashtable();
    private Hashtable newLastMeasures = new Hashtable();
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String protocol = "t3";
    private boolean useJMX = false;
    boolean useSSLTrustStoreFlag = false;
    String wlSSLTrustKeyStore = null;
    String customTrustKeyStoreFileName = null;
    String customTrustKeyStoreType = null;
    String customTrustKeyStorePassPhrase = null;

    public WLEJBCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.isDynamicInfoTest = true;
        this.needToStoreMeasuresForDD = true;
        this.doNotTakeAverageList.add(new Integer(1));
        this.doNotTakeAverageList.add(new Integer(2));
        this.doNotTakeAverageList.add(new Integer(3));
        this.doNotTakeAverageList.add(new Integer(4));
        this.doNotTakeAverageList.add(new Integer(6));
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        boolean bl = false;
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.server = this.getValueForParam("server");
        this.ssl = this.getValueForParam("ssl");
        bl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("yes"));
        this.url = this.getValueForParam("url");
        this.s_useWarFile = this.getValueForParam("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
            if (bl) {
                this.wlSSLTrustKeyStore = this.getValueForParam("ssl_trust_key_store");
                System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is before check  " + this.wlSSLTrustKeyStore);
                if (this.wlSSLTrustKeyStore == null || this.wlSSLTrustKeyStore.equalsIgnoreCase("none") || this.wlSSLTrustKeyStore.equalsIgnoreCase("null") || this.wlSSLTrustKeyStore.trim().length() == 0) {
                    this.useSSLTrustStoreFlag = false;
                } else {
                    this.useSSLTrustStoreFlag = true;
                    this.wlSSLTrustKeyStore = this.wlSSLTrustKeyStore.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
                }
                this.customTrustKeyStoreFileName = this.getValueForParam("custom_trust_key_store_file_name");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is before check  " + this.customTrustKeyStoreFileName);
                if (this.customTrustKeyStoreFileName == null || this.customTrustKeyStoreFileName.equalsIgnoreCase("none") || this.customTrustKeyStoreFileName.equalsIgnoreCase("null") || this.customTrustKeyStoreFileName.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is null or none   ");
                } else {
                    this.customTrustKeyStoreFileName = this.customTrustKeyStoreFileName.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is " + this.customTrustKeyStoreFileName);
                }
                this.customTrustKeyStoreType = this.getValueForParam("custom_trust_key_store_type");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is before check  " + this.customTrustKeyStoreType);
                if (this.customTrustKeyStoreType == null || this.customTrustKeyStoreType.equalsIgnoreCase("none") || this.customTrustKeyStoreType.equalsIgnoreCase("null") || this.customTrustKeyStoreType.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is null or none  ");
                } else {
                    this.customTrustKeyStoreType = this.customTrustKeyStoreType.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is " + this.customTrustKeyStoreType);
                }
                this.customTrustKeyStorePassPhrase = this.getValueForParam("custom_trust_key_store_pass_phrase");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is before check  " + this.customTrustKeyStorePassPhrase);
                if (this.customTrustKeyStorePassPhrase == null || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("none") || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("null") || this.customTrustKeyStorePassPhrase.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is null or none    ");
                } else {
                    this.customTrustKeyStorePassPhrase = this.customTrustKeyStorePassPhrase.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is " + this.customTrustKeyStorePassPhrase);
                }
            }
        }
        String string2 = this.getValueForParam("showServerName");
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            this.showServer = false;
        }
        if ((string = this.getValueForParam("encryptPass")) != null && string.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        this.newLastMeasures = new Hashtable();
        if (this.weblogicVersion == 0) {
            object = this.getValueForParam("version");
            if (!((String)object).equalsIgnoreCase("none")) {
                int n = ((String)object).indexOf(".");
                if (n >= 0) {
                    object = ((String)object).substring(0, n);
                }
                try {
                    this.weblogicVersion = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    this.weblogicVersion = 0;
                }
            }
            if (this.weblogicVersion == 0) {
                this.discovery();
            }
        }
        System.out.println(this.entity + ":" + this.reportingName + " weblogicVersion :" + this.weblogicVersion);
        if (this.weblogicVersion < 6) {
            this.lastMeasures = new Hashtable();
            this.logToErrorFile("Error", "WLEJBCacheTest", "WebLogic version number is " + this.weblogicVersion + ". Can't monitor WebLogic Server version prior to 6");
            return;
        }
        this.protocol = bl ? "t3s" : "t3";
        if (this.weblogicVersion >= 12) {
            this.useJMX = true;
        }
        object = null;
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "WLEJBCacheTest.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                this.lastMeasures = new Hashtable();
                this.addNewMeasure(null);
                return;
            }
            WLCommandExecute wLCommandExecute = new WLCommandExecute();
            if (this.useSSLTrustStoreFlag) {
                wLCommandExecute.setWebLogicSSLTrustKeyStore(this.wlSSLTrustKeyStore, this.customTrustKeyStoreFileName, this.customTrustKeyStoreType, this.customTrustKeyStorePassPhrase);
                System.out.println(this.reportingName + ":" + this.entity + " : Calling the method with SSL Truststore and  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
            }
            object = this.useJMX ? wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLEJBCacheTestUsingJMX") : wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLEJBCacheTest");
        } else {
            object = this.useJMX ? this.getMeasuresFromJSP("WLEJBCacheTestUsingJMX") : this.getMeasuresFromJSP("WLEJBCacheTest");
        }
        if (object == null || ((ArrayList)object).size() == 0) {
            this.lastMeasures = new Hashtable();
            this.addNewMeasure(null);
            return;
        }
        Vector vector = this.getComponentsToBeMonitored();
        String string3 = this.server + "_";
        int n = string3.length();
        int n2 = ((ArrayList)object).size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string4 = (String)((ArrayList)object).get(i);
            if (string4 == null || (n3 = string4.indexOf(":")) == -1 || (n3 = (string4 = string4.substring(n3 + 1)).indexOf(",")) == -1) continue;
            String string5 = string4.substring(0, n3);
            if (!this.showServer && string5.startsWith(string3)) {
                string5 = string5.substring(n);
            }
            if (!this.isAuto && vector != null && vector.size() > 0 && !vector.contains(string5)) continue;
            string4 = string4.substring(n3 + 1);
            try {
                n3 = string4.indexOf(",");
                if (n3 == -1) continue;
                double d = Double.parseDouble(string4.substring(0, n3));
                System.out.println("Activation count for " + string5 + " " + d);
                string4 = string4.substring(n3 + 1);
                n3 = string4.indexOf(",");
                if (n3 == -1) continue;
                double d2 = Double.parseDouble(string4.substring(0, n3));
                if ((n3 = (string4 = string4.substring(n3 + 1)).indexOf(",")) == -1) continue;
                double d3 = Double.parseDouble(string4.substring(0, n3));
                if ((n3 = (string4 = string4.substring(n3 + 1)).indexOf(",")) == -1) continue;
                double d4 = Double.parseDouble(string4.substring(0, n3));
                string4 = string4.substring(n3 + 1);
                double d5 = Double.parseDouble(string4);
                this.populateLastMeasures(string5);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (this.activationCount_last == -5.0) {
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                } else {
                    double d6 = d - this.activationCount_last;
                    arrayList.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    d6 = d2 - this.passivationCount_last;
                    arrayList.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    d6 = d4 - this.cacheHitCount_last;
                    arrayList.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    d6 = d5 - this.cacheAccessCount_last - d6;
                    arrayList.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    if (d5 - this.cacheAccessCount_last == 0.0) {
                        arrayList.add(new Double(100.0));
                    } else {
                        d6 = (d4 - this.cacheHitCount_last) / (d5 - this.cacheAccessCount_last) * 100.0;
                        arrayList.add(new Double(d6));
                    }
                }
                arrayList.add(new Double(d3));
                this.activationCount_last = d;
                this.passivationCount_last = d2;
                this.cacheHitCount_last = d4;
                this.cacheAccessCount_last = d5;
                this.addNewMeasure(string5, arrayList);
                this.saveLastMeasures(string5);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.logToErrorFile("Error", "WLEJBCacheTest.computeMeasures: ", string5 + " : " + numberFormatException.toString());
                numberFormatException.printStackTrace();
            }
        }
        this.lastMeasures = this.newLastMeasures;
    }

    private void populateLastMeasures(String string) {
        if (!this.lastMeasures.isEmpty() && this.lastMeasures.containsKey(string)) {
            String string2 = (String)this.lastMeasures.get(string);
            int n = string2.indexOf(",");
            this.activationCount_last = Double.parseDouble(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(",");
            this.passivationCount_last = Double.parseDouble(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(",");
            this.cacheHitCount_last = Double.parseDouble(string2.substring(0, n));
            this.cacheAccessCount_last = Double.parseDouble(string2.substring(n + 1));
            return;
        }
        this.activationCount_last = -5.0;
        this.passivationCount_last = -5.0;
        this.cacheHitCount_last = -5.0;
        this.cacheAccessCount_last = -5.0;
    }

    private void saveLastMeasures(String string) {
        String string2 = this.activationCount_last + "," + this.passivationCount_last + "," + this.cacheHitCount_last + "," + this.cacheAccessCount_last;
        this.newLastMeasures.put(string, string2);
    }
}

