/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WLBaseTest
extends GenericTest {
    protected int weblogicVersion = 0;
    protected static final String EGURKHA_NAME = "egurkha";
    protected static final String EGURKHA_MONITOR = "monitoring";
    protected String user = "system";
    protected String password = "password";
    protected String server = "myserver";
    protected String ssl = "false";
    protected String url = "";
    private String tempHost = "";
    protected boolean useJMX = false;
    protected long jspTimeout;

    public WLBaseTest(String[] stringArray) {
        super(stringArray);
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        String string = this.getValueForParam("jspTimeout");
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string);
    }

    protected void discovery() {
        long l;
        if (this.server == null) {
            this.server = "localhome";
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            this.url = Boolean.getBoolean(this.ssl) ? "https://" + this.tempHost + ":" + this.portNo : "http://" + this.tempHost + ":" + this.portNo;
        }
        WebLogicHelperThread webLogicHelperThread = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), Boolean.getBoolean(this.ssl));
        int n = 6;
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (webLogicHelperThread.done) {
                this.weblogicVersion = webLogicHelperThread.version;
                return;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                webLogicHelperThread.stop();
                webLogicHelperThread = null;
                this.weblogicVersion = n;
                return;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        webLogicHelperThread.stop();
        webLogicHelperThread = null;
        this.weblogicVersion = n;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    protected ArrayList getMeasuresFromJSP(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object var3_3 = null;
        HttpURLConnection httpURLConnection = this.getHTTPConnection(string);
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        try {
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList2 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList2 = connectionThread.data;
            }
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (arrayList2 == null || arrayList2.size() == 0) {
                return null;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (string2.startsWith(string)) {
                    arrayList.add(string2);
                }
                if (string.indexOf("UsingJMX") <= -1) continue;
                System.out.println("inside substring");
                String string3 = string.substring(0, string.indexOf("UsingJMX"));
                System.out.println(this.entity + " after substring JSP file to hit :" + string3);
                if (!string2.startsWith(string3)) continue;
                System.out.println(this.entity + " Measures to add the test file :" + string2);
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
        return arrayList;
    }

    private HttpURLConnection getHTTPConnection(String string) {
        String string2;
        Object object;
        Object object2;
        String string3;
        String string4 = null;
        if (string.equalsIgnoreCase("WLJDBCTestUsingJMX")) {
            System.out.println("Calling WLJDBCTestUsingJMX.jsp...... ");
            string3 = this.url;
            if (string3.endsWith("/") || string3.endsWith("\\")) {
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                    System.out.println(string3);
                }
                if (string3.endsWith("\\")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            }
            if ((object2 = this.getValueForParam("adminServerHost")) == null || ((String)object2).trim().length() == 0 || ((String)object2).equalsIgnoreCase("none")) {
                object2 = this.targetHost;
            }
            if ((object = this.getValueForParam("adminServerPort")) == null || ((String)object).trim().length() == 0 || ((String)object).equalsIgnoreCase("none")) {
                object = this.portNo;
            }
            System.out.println("WLJDBCTestUsingJMX  :Port :" + this.portNo + " changed into " + (String)object + " for WLJDBCTestUsingJMX");
            System.out.println("WLJDBCTestUsingJMX  :IP  :" + this.targetHost + " changed into " + (String)object2 + " for WLJDBCTestUsingJMX");
            string2 = "WLJDBCTestUsingJMX";
            try {
                string4 = this.url + "/egurkha/" + string2 + ".jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + (String)object2 + "&port=" + (String)object + "&server=" + this.server + "&timeout=" + this.jspTimeout;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        } else {
            try {
                string4 = this.url + "/egurkha/" + string + ".jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        string3 = this.url + "/egurkha/" + string + ".jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=*********&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        System.out.println("[" + this.reportingName + ":" + this.entity + "]  measureUri : " + string3);
        try {
            if (Boolean.getBoolean(this.ssl)) {
                object2 = EgSSL.getInstance();
                EgSSL.enableSSL();
                object = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string2 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                URL uRL = new URL(string4);
                return (HttpURLConnection)uRL.openConnection();
            }
            object2 = new URL(string4);
            return (HttpURLConnection)((URL)object2).openConnection();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "WLBaseTest.getHTTPConnection: ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public int getWebLogicVersion() {
        return this.weblogicVersion;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServer() {
        return this.server;
    }

    public String getSsl() {
        return this.ssl;
    }

    public String getUrl() {
        return this.url;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }
}

