/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMWorkerHelper;
import com.eg.apm.EgLogbackManager;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMDiscovery;
import com.eg.org.slf4j.Logger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionFlowTest
extends BusinessTransTestBase {
    private static ArrayList defaultValueList = null;
    private static final Double zeroValue = new Double(0.0);
    private static final String WEB_TOTAL_KEY = "THIS_NODE#TOTAL_Web";
    private static final String WEB_SELF_KEY = "THIS_NODE#SELF_Web";
    private static final String THREAD_TOTAL_KEY = "THIS_NODE#TOTAL_Thread";
    private static final String THREAD_SELF_KEY = "THIS_NODE#SELF_Thread";
    private static final String SELF_NODE_SYNC_KEY = "THIS_NODE_Sync:SELF";
    private static final String SELF_NODE_ASYNC_KEY = "THIS_NODE_Async:SELF";
    private static final String NODE_TOTAL_SYNC_KEY = "THIS_NODE_Sync:TOTAL";
    private static final String NODE_TOTAL_ASYNC_KEY = "THIS_NODE_Async:TOTAL";
    protected String loggerDispStr;
    protected static Logger logger = EgLogbackManager.getInstance().getLogger("TFT_LOGGER");
    private static final Hashtable KEY_MAPPING = new Hashtable();
    protected Vector allExternalCallDetails;
    protected Set egHostIpList;

    public TransactionFlowTest(String[] args) {
        super(args);
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [TransactionFlowTest]";
        this.isNewDynamicInfoTest = true;
        if (defaultValueList == null) {
            defaultValueList = this.createDefaultValueList();
        }
    }

    public void computeMeasures(Hashtable paramList) {
        Hashtable finalMeasures;
        this.getJvmGuid();
        HashMap autoNames = this.getComponentsForAppflow();
        JavaTransactionFlowUtility.storeAutoNameIntoIniFile(autoNames, "NEW_APPFLOW_AUTO_NAME_MAPPING", "SEND_APPFLOW_AUTO_NAME_MAPPING", this.NodeID, logger);
        HashMap nodeOrder = TransactionFlowTest.getNodeorderForTargetnames(autoNames);
        JavaTransactionFlowUtility.storeAutoNameIntoIniFile(nodeOrder, "NEW_APPFLOW_NODE_ORDER_MAPPING", "SEND_APPFLOW_NODE_ORDER_MAPPING", this.NodeID, logger);
        logger.debug("{} nodeOrder  : {} ", (Object)this.loggerDispStr, (Object)nodeOrder);
        logger.debug("{} autoNames  : {} ", (Object)this.loggerDispStr, (Object)autoNames);
        Hashtable<String, Long> configTable = new Hashtable<String, Long>();
        configTable.put("MEASURE_PERIOD", new Long(this.measurePeriod));
        BTMDiscovery btmDiscoveryWithNodeId = JavaTransactionFlowUtility.getBTMDiscoveryObject(this.apmComponentGUID);
        if (btmDiscoveryWithNodeId == null) {
            logger.debug("{} No TRANSACTION_FLOW_DETAILS data available for : {} ", (Object)this.loggerDispStr, (Object)this.apmComponentGUID);
            return;
        }
        Hashtable discoveryDetails = btmDiscoveryWithNodeId.cloneTransmitCopy();
        this.allExternalCallDetails = (Vector)discoveryDetails.get("tftDetails");
        this.egHostIpList = (Set)discoveryDetails.get("hostPortDetails");
        logger.debug("{}  allExternalCallDetails ===> {}", (Object)this.loggerDispStr, (Object)this.allExternalCallDetails);
        logger.debug("{}  egHostIpList ===> {}", (Object)this.loggerDispStr, (Object)this.egHostIpList);
        if (this.egHostIpList == null) {
            logger.debug("{} New Ip/Port 'Not' found for Application Flow Test MultiNode Setup....", (Object)this.loggerDispStr);
        } else {
            logger.info("{} New Ip/Port found for Application Flow Test MultiNode Setup....", (Object)this.loggerDispStr);
        }
        Hashtable detailsHT = new Hashtable();
        if (this.allExternalCallDetails != null && this.allExternalCallDetails.size() > 0) {
            try {
                Enumeration externalCallDetailsList = this.allExternalCallDetails.elements();
                while (externalCallDetailsList.hasMoreElements()) {
                    HashMap object = (HashMap)externalCallDetailsList.nextElement();
                    for (Map.Entry pair : object.entrySet()) {
                        String formattedKeyString;
                        double entry_node;
                        double error_count;
                        double self_exe_time;
                        String keyString = pair.getKey().toString();
                        double[] values = (double[])pair.getValue();
                        if (keyString.equalsIgnoreCase("NODE_DETAILS_Web")) {
                            double total_exe_time = values[0];
                            self_exe_time = values[1];
                            error_count = values[2];
                            entry_node = values[3];
                            this.updateExternalCalls(WEB_TOTAL_KEY, new double[]{1.0, total_exe_time, error_count, entry_node}, detailsHT);
                            this.updateExternalCalls(WEB_SELF_KEY, new double[]{1.0, self_exe_time, error_count, -5.0}, detailsHT);
                            continue;
                        }
                        if (keyString.equalsIgnoreCase("NODE_DETAILS_Thread")) {
                            double total_exe_time = values[0];
                            self_exe_time = values[1];
                            error_count = values[2];
                            entry_node = values[3];
                            this.updateExternalCalls(THREAD_TOTAL_KEY, new double[]{1.0, total_exe_time, error_count, entry_node}, detailsHT);
                            this.updateExternalCalls(THREAD_SELF_KEY, new double[]{1.0, self_exe_time, error_count, -5.0}, detailsHT);
                            continue;
                        }
                        int length = values.length;
                        if (length == 3) {
                            double v1 = values[0];
                            double v2 = values[1];
                            double v3 = values[2];
                            double v4 = -5.0;
                            values = new double[]{v1, v2, v3, v4};
                        }
                        if (KEY_MAPPING.containsKey(keyString)) {
                            formattedKeyString = (String)KEY_MAPPING.get(keyString);
                            this.updateExternalCalls(formattedKeyString, values, detailsHT);
                            continue;
                        }
                        formattedKeyString = null;
                        if (keyString.startsWith("EMAIL") || keyString.startsWith("HTTP") || keyString.startsWith("WEBSERVICE") || keyString.startsWith("EJB_HIDE") || keyString.startsWith("RMI") || keyString.startsWith("Custom_")) {
                            formattedKeyString = this.formatKeyString(keyString);
                        }
                        if (formattedKeyString == null) {
                            formattedKeyString = keyString;
                        }
                        KEY_MAPPING.put(keyString, formattedKeyString);
                        this.updateExternalCalls(formattedKeyString, values, detailsHT);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception occured while processing TFT data {} ", (Throwable)e);
            }
        }
        if ((finalMeasures = this.computeCallDetails(detailsHT)) == null) {
            logger.debug("{} No details found, so skipping measure sending", (Object)this.loggerDispStr);
            return;
        }
        Set keys = finalMeasures.keySet();
        for (String infoString : keys) {
            ArrayList measureList = (ArrayList)finalMeasures.get(infoString);
            logger.debug("{} Adding New Measure for descriptor : {} value : {} ", new Object[]{this.loggerDispStr, infoString, measureList});
            this.addNewMeasure(infoString, measureList);
            int sync_index = infoString.indexOf("_Sync:");
            if (sync_index > 0) {
                String asyncInfoString = infoString.replace("_Sync:", "_Async:");
                if (finalMeasures.containsKey(asyncInfoString)) continue;
                logger.debug("{} Adding additional descriptor : {} with default values : {} ", new Object[]{this.loggerDispStr, asyncInfoString, defaultValueList});
                this.addNewMeasure(asyncInfoString, defaultValueList);
                continue;
            }
            String syncInfoString = infoString.replace("_Async:", "_Sync:");
            if (finalMeasures.containsKey(syncInfoString)) continue;
            logger.debug("{} Adding additional descriptor : {} with default values : {} ", new Object[]{this.loggerDispStr, syncInfoString, defaultValueList});
            this.addNewMeasure(syncInfoString, defaultValueList);
        }
    }

    private static HashMap getNodeorderForTargetnames(HashMap targerComponentNames) {
        if (targerComponentNames == null || targerComponentNames.size() < 0) {
            return null;
        }
        ConcurrentHashMap<String, Integer> nodeOrder = APMWorkerHelper.getInstance().getAutoNameMap();
        if (nodeOrder == null || nodeOrder.size() < 0) {
            return null;
        }
        Iterator it = targerComponentNames.entrySet().iterator();
        HashMap map = new HashMap();
        while (it.hasNext()) {
            HashSet<String> autoNames = new HashSet<String>();
            Map.Entry pair = it.next();
            String keyString = pair.getKey().toString();
            TreeSet targetNames = (TreeSet)pair.getValue();
            for (String name : targetNames) {
                Set set = nodeOrder.keySet();
                Iterator its = set.iterator();
                while (its.hasNext()) {
                    String nodeorder = its.next().toString();
                    if (nodeorder.startsWith(name)) {
                        autoNames.add(nodeorder);
                        APMWorkerHelper.getInstance().addEntryIntoComputedNodeOrders(nodeorder);
                        continue;
                    }
                    if (!nodeorder.startsWith(keyString)) continue;
                    autoNames.add(nodeorder);
                }
            }
            if (autoNames.size() <= 0) continue;
            map.put(keyString, autoNames);
        }
        return map;
    }

    private HashMap getComponentsForAppflow() {
        HashMap uniqueGuidMapping = this.getUniqueGUIDMappingFromIniFile();
        HashMap targetguid = JavaTransactionFlowUtility.getAppflowTargetJvms();
        HashMap targerComponentNames = this.replaceGuidWithComponentName(uniqueGuidMapping, targetguid);
        logger.debug("{}  uniqueGuidMapping  : {} ", (Object)this.loggerDispStr, (Object)uniqueGuidMapping);
        logger.debug("{} targetguid  : {} ", (Object)this.loggerDispStr, (Object)targetguid);
        logger.debug("{} targerComponentNames  : {} ", (Object)this.loggerDispStr, (Object)targerComponentNames);
        return targerComponentNames;
    }

    private HashMap replaceGuidWithComponentName(HashMap uniqueGuidMapping, HashMap targetguid) {
        if (uniqueGuidMapping == null || uniqueGuidMapping.size() < 0 || targetguid == null || targetguid.size() < 0) {
            return null;
        }
        HashMap namesOnly = new HashMap();
        for (Map.Entry map : targetguid.entrySet()) {
            String id = (String)map.getKey();
            TreeSet nameSet = (TreeSet)map.getValue();
            String newName = (String)uniqueGuidMapping.get(id);
            if (newName == null) continue;
            Iterator innerItr = nameSet.iterator();
            TreeSet<String> targetNames = new TreeSet<String>();
            while (innerItr.hasNext()) {
                String innerTagetName = (String)innerItr.next();
                String newTargetName = (String)uniqueGuidMapping.get(innerTagetName);
                if (newTargetName == null) continue;
                targetNames.add(newTargetName);
            }
            if (targetNames.size() <= 0) continue;
            namesOnly.put(newName, targetNames);
        }
        return namesOnly;
    }

    private HashMap getUniqueGUIDMappingFromIniFile() {
        HashMap<String, String> uniqueIds = new HashMap<String, String>();
        try {
            IniFile inifileRead = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
            String[] allUniqueJvmDetailsKey = inifileRead.getVariables("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING");
            if (allUniqueJvmDetailsKey != null && allUniqueJvmDetailsKey.length > 0) {
                long length = allUniqueJvmDetailsKey.length;
                int i = 0;
                while ((long)i < length) {
                    String value = inifileRead.getValue("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", allUniqueJvmDetailsKey[i]);
                    if (value.startsWith("[")) {
                        uniqueIds.put(allUniqueJvmDetailsKey[i], value);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error("{} Exception while reading data from INI files {}", (Object)this.loggerDispStr, (Object)e);
        }
        return uniqueIds;
    }

    private void updateExternalCalls(String keyString, double[] values, Hashtable detailsHT) {
        try {
            if (detailsHT.containsKey(keyString)) {
                double[] currentValue = (double[])detailsHT.get(keyString);
                currentValue[0] = currentValue[0] + values[0];
                currentValue[1] = currentValue[1] + values[1];
                currentValue[2] = currentValue[2] + values[2];
                if (values.length > 3 && currentValue[3] < values[3]) {
                    currentValue[3] = values[3];
                }
            } else {
                detailsHT.put(keyString, values);
            }
        }
        catch (NullPointerException e) {
            detailsHT = new Hashtable<String, double[]>();
            detailsHT.put(keyString, values);
        }
    }

    private String formatKeyString(String keyType) {
        try {
            String requestType = null;
            int underscore_index = keyType.lastIndexOf("_");
            if (underscore_index > 0) {
                requestType = keyType.substring(underscore_index);
            }
            String keyWithoutReqType = keyType.substring(0, underscore_index);
            int hash_index = keyWithoutReqType.indexOf("#");
            String displayName = keyWithoutReqType.substring(0, hash_index);
            String resultKeyString = keyWithoutReqType.substring(hash_index + 1);
            int subKeyLength = 0;
            if (resultKeyString != null) {
                subKeyLength = resultKeyString.length();
            }
            if (displayName.equals("EMAIL")) {
                resultKeyString = subKeyLength == 0 ? "EMAIL" : this.getEmailEndPoint(resultKeyString);
            }
            if (displayName.equals("RMI")) {
                resultKeyString = resultKeyString.substring(1, subKeyLength - 1);
            }
            if (displayName.equals("EJB_HIDE") && !resultKeyString.startsWith("//")) {
                resultKeyString = resultKeyString.substring(resultKeyString.indexOf("/"), subKeyLength);
            }
            if (displayName.equals("Custom_")) {
                displayName = "CUSTOM";
            }
            if (displayName.equals("HTTP") || displayName.equals("WEBSERVICE")) {
                resultKeyString = this.HttpAndWebserviceUrlCreator(resultKeyString);
            }
            resultKeyString = String.valueOf(displayName) + "#" + resultKeyString + requestType;
            logger.debug("{} Found suitable Key for the input {} , it is {}", new Object[]{this.loggerDispStr, keyType, resultKeyString});
            return resultKeyString;
        }
        catch (Exception e) {
            logger.error("Exception occur while forming key {} ", (Throwable)e);
            return null;
        }
    }

    private String HttpAndWebserviceUrlCreator(String subKey) {
        StringBuffer TFTextUrl = new StringBuffer();
        try {
            URL endPoint = new URL(subKey);
            if (endPoint.getPort() < 0) {
                TFTextUrl.append(endPoint.getProtocol()).append("://").append(endPoint.getHost()).append(":").append(endPoint.getDefaultPort());
            } else {
                TFTextUrl.append(endPoint.getProtocol()).append("://").append(endPoint.getHost()).append(":").append(endPoint.getPort());
            }
        }
        catch (Exception mex) {
            logger.error("{} Error while creating webservice and http TFT URL : {}", (Object)this.loggerDispStr, (Object)mex);
        }
        return TFTextUrl.toString();
    }

    private Hashtable computeCallDetails(Hashtable details) {
        if (details == null || details.size() == 0) {
            return null;
        }
        Hashtable finalMeasures = new Hashtable();
        Set keySet = details.keySet();
        Iterator keyItrator = keySet.iterator();
        long test_Frequency = this.measurePeriod / 1000L / 60L;
        logger.debug("{} Transaction Flow Test Frequency :{} in minutes", (Object)this.loggerDispStr, (Object)test_Frequency);
        while (keyItrator.hasNext()) {
            int underscore_index;
            String keyString = (String)keyItrator.next();
            double[] values = (double[])details.get(keyString);
            double call_count = values[0];
            double call_exe_time = values[1];
            double error_call_count = values[2];
            double entry_node_call = values[3];
            double call_per_min = call_count / (double)test_Frequency;
            double error_call_per_min = error_call_count / (double)test_Frequency;
            double error_percentage = 0.0;
            double avg_call_exe_time = 0.0;
            if (call_count > 0.0) {
                error_percentage = error_call_count / call_count * 100.0;
                avg_call_exe_time = call_exe_time / call_count;
            }
            String displayName = null;
            String keyWithoutDisplayName = null;
            String requestType = "_Web";
            String resultKeyString = null;
            int hash_index = keyString.indexOf("#");
            if (hash_index > 0) {
                displayName = keyString.substring(0, hash_index);
                keyWithoutDisplayName = keyString.substring(hash_index + 1);
            }
            if (keyWithoutDisplayName != null && (underscore_index = keyWithoutDisplayName.lastIndexOf("_")) > 0) {
                resultKeyString = keyWithoutDisplayName.substring(0, underscore_index);
                requestType = keyWithoutDisplayName.substring(underscore_index);
            }
            ArrayList<Double> measureList = new ArrayList<Double>();
            measureList.add(new Double(call_count));
            measureList.add(new Double(avg_call_exe_time));
            measureList.add(new Double(call_per_min));
            measureList.add(new Double(error_call_count));
            measureList.add(new Double(error_call_per_min));
            measureList.add(new Double(error_percentage));
            measureList.add(new Double(entry_node_call));
            String display_name = "DB_Sync:";
            if (displayName != null && displayName.equals("SQL")) {
                Hashtable dbServerDetails = this.DataBaseInfo(resultKeyString);
                if (dbServerDetails == null || dbServerDetails.size() <= 0) continue;
                String serverType = (String)dbServerDetails.get("SERVERTYPE");
                String serverIp = (String)dbServerDetails.get("SERVERNAME");
                String portNo = (String)dbServerDetails.get("PORTNUMBER");
                String instanceName = (String)dbServerDetails.get("DATABASENAME");
                if (requestType != null && requestType.equals("_Thread")) {
                    display_name = "DB_Async:";
                }
                StringBuffer keyBuffer = new StringBuffer();
                keyBuffer.append(display_name).append(serverType).append(":").append(serverIp).append(":").append(portNo).append("_").append(instanceName);
                String descriptor = keyBuffer.toString();
                finalMeasures.put(descriptor, measureList);
                continue;
            }
            if (displayName != null && displayName.endsWith("_")) {
                displayName = displayName.substring(0, displayName.lastIndexOf("_"));
            }
            display_name = requestType != null && requestType.equals("_Thread") ? String.valueOf(displayName) + "_Async:" : String.valueOf(displayName) + "_Sync:";
            finalMeasures.put(String.valueOf(display_name) + resultKeyString, measureList);
        }
        return finalMeasures;
    }

    private ArrayList createDefaultValueList() {
        ArrayList<Double> defaultList = new ArrayList<Double>();
        defaultList.add(zeroValue);
        defaultList.add(zeroValue);
        defaultList.add(zeroValue);
        defaultList.add(zeroValue);
        defaultList.add(zeroValue);
        defaultList.add(zeroValue);
        defaultList.add(minusFive);
        logger.debug("{} Created default value list ....{}", (Object)this.loggerDispStr, defaultList);
        return defaultList;
    }
}

