/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class TibRollbackTest
extends GenericTest {
    private String tibSid = "";
    private String username = "";
    private String password = "";
    private double prevSysUndoHead = 0.0;
    private double prevSysUndoBlkCnt = 0.0;
    private double prevUndoHeadCnt = 0.0;
    private double prevUndoBlkCnt = 0.0;
    private double prevSum = 0.0;
    private String queryUndo = "";
    private String queryBlocks = "";
    private boolean isFirstTime = true;

    public TibRollbackTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        this.queryUndo = "select class, count,time from v$waitstat where class in ('system undo header', 'system undo block', 'undo header', 'undo block')";
        this.queryBlocks = "SELECT sum(value) FROM V$SYSSTAT WHERE name in ('db block gets','consistent block gets')";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block23: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            try {
                Object object;
                String string = "jdbc:tibero:thin:@";
                String string2 = string + "" + this.targetHost + ":" + this.portNo + ":" + this.tibSid;
                System.out.println("URL::" + string2);
                TbDataSource tbDataSource = new TbDataSource();
                tbDataSource.setURL(string2);
                tbDataSource.setUser(this.username);
                tbDataSource.setPassword(this.password);
                System.out.println("Bef Connection");
                try {
                    connection = tbDataSource.getConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(connection);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                resultSet = statement.executeQuery(this.queryUndo);
                while (resultSet.next()) {
                    object = resultSet.getString(1);
                    if (((String)object).equalsIgnoreCase("system undo header")) {
                        d = resultSet.getDouble(2);
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("system undo block")) {
                        d2 = resultSet.getDouble(2);
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("undo header")) {
                        d3 = resultSet.getDouble(2);
                        continue;
                    }
                    if (!((String)object).equalsIgnoreCase("undo block")) continue;
                    d4 = resultSet.getDouble(2);
                }
                this.closeRs(resultSet);
                resultSet = statement.executeQuery(this.queryBlocks);
                while (resultSet.next()) {
                    d5 = resultSet.getDouble(1);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                System.out.println(this.entity + " sum::" + d5 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                if (this.prevSysUndoHead > d || this.prevSysUndoBlkCnt > d2 || this.prevUndoHeadCnt > d3 || this.prevUndoBlkCnt > d4 || this.prevSum > d5) {
                    d6 = -5.0;
                    d7 = -5.0;
                } else if (this.isFirstTime) {
                    d6 = -5.0;
                    d7 = -5.0;
                } else {
                    d8 = d - this.prevSysUndoHead + (d2 - this.prevSysUndoBlkCnt);
                    d9 = d3 - this.prevUndoHeadCnt + (d4 - this.prevUndoBlkCnt);
                    d10 = d5 - this.prevSum;
                    System.out.println(this.entity + " sysDiff::" + d8 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    System.out.println(this.entity + " headDiff::" + d9 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    System.out.println(this.entity + " sumDiff::" + d10 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    if (d10 == 0.0) {
                        d6 = 0.0;
                        d7 = 0.0;
                    } else {
                        d6 = d8 * 100.0 / d10;
                        d7 = d9 * 100.0 / d10;
                    }
                }
                object = new ArrayList();
                ((ArrayList)object).add(new Double(d6));
                ((ArrayList)object).add(new Double(d7));
                this.addNewMeasure((ArrayList)object);
                System.out.println(this.entity + " measureList::" + object + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                this.prevSum = d5;
                this.prevSysUndoHead = d;
                this.prevSysUndoBlkCnt = d2;
                this.prevUndoHeadCnt = d3;
                this.prevUndoBlkCnt = d4;
                this.isFirstTime = false;
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                break block23;
            }
            finally {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            this.closeStmt(statement);
            this.closeConn(connection);
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        TibRollbackTest tibRollbackTest = new TibRollbackTest(stringArray);
        tibRollbackTest.computeMeasures(new Hashtable());
    }
}

