/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class StratusHwTrapTest
extends EgLogSnmpTrapd {
    private static final int MEASURES_COUNT = 15;
    private static final String TRAP_DEVICE_CLASS_OID = ".1.3.6.1.4.1.458.105.3.2.0";
    private static final String TRAP_STATE_OID = ".1.3.6.1.4.1.458.105.3.3.0";
    private static final String TRAP_REASON_OID = ".1.3.6.1.4.1.458.105.3.4.0";
    private static final int STATE_EMPTY = 65536;
    private static final int STATE_NOT_PRESENT = 65560;
    private static final int STATE_REMOVED = 131073;
    private static final int STATE_DUMPING = 131076;
    private static final int STATE_DIAGNOSTICS_PASSED = 131078;
    private static final int STATE_INITIALISING = 131079;
    private static final int STATE_SYNCING = 131080;
    private static final int STATE_OFFLINE = 131082;
    private static final int STATE_FIRMWARE_UPDATE_COMPLETE = 131088;
    private static final int STATE_DIAGNOSTICS = 262149;
    private static final int STATE_ONLINE = 524308;
    private static final int STATE_SIMPLEX = 524309;
    private static final int STATE_DUPLEX = 1572886;
    private static final int STATE_SHOT = 0x200002;
    private static final int STATE_BROKEN = 0x200003;
    private HashMap deviceStateMap;
    private HashMap stateReasonMap;
    private HashMap trapTimeMap;
    private static ArrayList deviceList;

    public StratusHwTrapTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(15);
        this.isDynamicInfoTest = true;
        this.showOid = "true";
        deviceList = this.discoverDevices();
    }

    /*
     * WARNING - void declaration
     */
    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList;
        Collection<Object> collection;
        if (this.deviceStateMap == null) {
            return;
        }
        this.deviceStateMap = new HashMap();
        this.initDeviceStateMap();
        this.stateReasonMap = new HashMap();
        this.trapTimeMap = new HashMap();
        this.storeOutputFromFile();
        if (this.al_StoreOutput != null && (collection = this.al_StoreOutput[0]) != null) {
            void string;
            int n = ((ArrayList)collection).size();
            boolean i = false;
            while (string < n) {
                arrayList = (ArrayList)((ArrayList)collection).get((int)string);
                int n2 = arrayList.size();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                Date date = (Date)arrayList.get(1);
                for (int j = 2; j < n2; ++j) {
                    String string5 = (String)arrayList.get(j);
                    if ((string5 = string5.trim()).length() <= 0) continue;
                    if (string5.indexOf(TRAP_DEVICE_CLASS_OID) != -1) {
                        string2 = this.getTrapValue(string5);
                        continue;
                    }
                    if (string5.indexOf(TRAP_STATE_OID) != -1) {
                        string3 = this.getTrapValue(string5);
                        continue;
                    }
                    if (string5.indexOf(TRAP_REASON_OID) == -1) continue;
                    string4 = this.getTrapValue(string5);
                }
                this.setTrapDetails(date, string2, string3, string4);
                ++string;
            }
        }
        collection = this.deviceStateMap.keySet();
        for (String string : collection) {
            arrayList = (ArrayList)this.deviceStateMap.get(string);
            this.addNewMeasure(string, arrayList);
        }
    }

    private void setTrapDetails(Date date, String string, String string2, String string3) {
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (n) {
            case 65536: {
                this.storeTrapDetails(date, string, 0, string3);
                break;
            }
            case 65560: {
                this.storeTrapDetails(date, string, 1, string3);
                break;
            }
            case 131073: {
                this.storeTrapDetails(date, string, 2, string3);
                break;
            }
            case 131076: {
                this.storeTrapDetails(date, string, 3, string3);
                break;
            }
            case 131078: {
                this.storeTrapDetails(date, string, 4, string3);
                break;
            }
            case 131079: {
                this.storeTrapDetails(date, string, 5, string3);
                break;
            }
            case 131080: {
                this.storeTrapDetails(date, string, 6, string3);
                break;
            }
            case 131082: {
                this.storeTrapDetails(date, string, 7, string3);
                break;
            }
            case 131088: {
                this.storeTrapDetails(date, string, 8, string3);
                break;
            }
            case 262149: {
                this.storeTrapDetails(date, string, 9, string3);
                break;
            }
            case 524308: {
                this.storeTrapDetails(date, string, 10, string3);
                break;
            }
            case 524309: {
                this.storeTrapDetails(date, string, 11, string3);
                break;
            }
            case 1572886: {
                this.storeTrapDetails(date, string, 12, string3);
                break;
            }
            case 0x200002: {
                this.storeTrapDetails(date, string, 13, string3);
                break;
            }
            case 0x200003: {
                this.storeTrapDetails(date, string, 14, string3);
            }
        }
    }

    private String getTrapValue(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() == 2) {
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            if (string2.lastIndexOf(44) >= 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    private void storeTrapDetails(Date date, String string, int n, String string2) {
        ArrayList arrayList = (ArrayList)this.deviceStateMap.get(string);
        ArrayList arrayList2 = (ArrayList)this.stateReasonMap.get(string);
        ArrayList arrayList3 = (ArrayList)this.trapTimeMap.get(string);
        if (arrayList == null) {
            arrayList = this.createDeviceStateList();
        }
        if (arrayList2 == null) {
            arrayList2 = this.createEmptyList();
        }
        if (arrayList3 == null) {
            arrayList3 = this.createEmptyList();
        }
        arrayList.set(n, new Double(1.0));
        arrayList2.set(n, new String(string2));
        arrayList3.set(n, date);
        this.deviceStateMap.put(string, arrayList);
        this.stateReasonMap.put(string, arrayList2);
        this.trapTimeMap.put(string, arrayList3);
        this.checkDeviceList(string);
    }

    private ArrayList createDeviceStateList() {
        ArrayList<Double> arrayList = new ArrayList<Double>(15);
        for (int i = 0; i < 15; ++i) {
            arrayList.add(new Double(0.0));
        }
        return arrayList;
    }

    private ArrayList createEmptyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>(15);
        for (int i = 0; i < 15; ++i) {
            arrayList.add(null);
        }
        return arrayList;
    }

    public boolean isDataAvailable() {
        return this.trapTimeMap != null && this.trapTimeMap.size() > 0;
    }

    public String getReason(String string, int n) {
        ArrayList arrayList = (ArrayList)this.stateReasonMap.get(string);
        if (arrayList != null) {
            String string2 = (String)arrayList.get(n);
            if (string2 != null) {
                return this.getReasonDescription(string2);
            }
            return null;
        }
        return null;
    }

    public Date getTrapTime(String string, int n) {
        ArrayList arrayList = (ArrayList)this.trapTimeMap.get(string);
        if (arrayList != null) {
            return (Date)arrayList.get(n);
        }
        return null;
    }

    private String getReasonDescription(String string) {
        String string2;
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (n) {
            case 0: {
                string2 = "none";
                break;
            }
            case 1: {
                string2 = "below mtbf";
                break;
            }
            case 2: {
                string2 = "diagnostics failed";
                break;
            }
            case 3: {
                string2 = "hardware incompatible";
                break;
            }
            case 4: {
                string2 = "holding dump";
                break;
            }
            case 5: {
                string2 = "bringup failed";
                break;
            }
            case 6: {
                string2 = "parent broken";
                break;
            }
            case 7: {
                string2 = "media disconnect";
                break;
            }
            case 8: {
                string2 = "firmware burn fail";
                break;
            }
            case 9: {
                string2 = "firmware file not found";
                break;
            }
            case 10: {
                string2 = "firmware file error";
                break;
            }
            case 11: {
                string2 = "firmware prom error";
                break;
            }
            case 12: {
                string2 = "autoburm disabled";
                break;
            }
            case 13: {
                string2 = "idprom read error";
                break;
            }
            case 14: {
                string2 = "primary";
                break;
            }
            case 15: {
                string2 = "secondary";
                break;
            }
            case 16: {
                string2 = "parent empty";
                break;
            }
            case 17: {
                string2 = "deferred bringup";
                break;
            }
            case 18: {
                string2 = "tertiary";
                break;
            }
            case 19: {
                string2 = "dump and go";
                break;
            }
            case 20: {
                string2 = "power failure";
                break;
            }
            case 21: {
                string2 = "asic detected failure";
                break;
            }
            case 24: {
                string2 = "split";
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    private ArrayList discoverDevices() {
        String string = EgInstallInfo.getInstallDir() + "\\agent\\config\\eg_stratus.ini";
        IniFile iniFile = new IniFile(string);
        String string2 = iniFile.getValue("DEVICE_CLASS", "devices");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private void initDeviceStateMap() {
        if (deviceList != null && deviceList.size() > 0) {
            for (int i = 0; i < deviceList.size(); ++i) {
                this.deviceStateMap.put(deviceList.get(i), this.createDeviceStateList());
            }
        }
    }

    private void checkDeviceList(String string) {
        if (!deviceList.contains(string)) {
            deviceList.add(string);
            this.saveDeviceList();
        }
    }

    private void saveDeviceList() {
        int n = deviceList.size();
        if (deviceList != null && n > 0) {
            String string = EgInstallInfo.getInstallDir() + "\\agent\\config\\eg_stratus.ini";
            IniFile iniFile = new IniFile(string, true);
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + (String)deviceList.get(i);
                if (i + 1 >= n) continue;
                string2 = string2 + ",";
            }
            iniFile.setValue("DEVICE_CLASS", "devices", string2);
            iniFile.saveFile();
        }
    }
}

