/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;

public class SSLCertificateBase
extends GenericTest {
    protected String timeout = "60000";
    protected ArrayList targets = new ArrayList();
    protected ArrayList targetsUrl = new ArrayList();
    protected Hashtable infoTable = new Hashtable();
    protected Hashtable targetTable = new Hashtable();
    protected KeyStore ks = null;
    private boolean hasKeyStore = false;
    private boolean hasCertificate = false;
    private boolean hasURL = false;
    boolean isAvailUrl = false;
    ArrayList cerSysPropKey = new ArrayList();
    ArrayList cerSysPropVal = new ArrayList();
    public static final String PUBLIC_CA_SIGNED = "PUBLIC_CA_SIGNED";
    public static final String LOCAL_CA_SIGNED = "LOCAL_CA_SIGNED";
    public static final String REVOKED = "REVOKED";
    public static final String SELF_SIGNED = "SELF_SIGNED";
    public static final String NOTDONE = "NOTDONE";
    public static final String SELF_SIGN_MESSAGE = "The certificate is self-signed";
    public static final String REVOKED_MESSAGE = "The certificate is revoked by CRL";
    public static final String LOCAL_CA_MESSAGE = "The certificate is from Local CA";

    public SSLCertificateBase(String[] stringArray) {
        super(stringArray);
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.timeout = this.getValueForParam("timeout");
        this.timeout = this.timeout == null ? "60000" : this.timeout + "000";
        String string = this.getValueForParam("targets");
        String string2 = this.getValueForParam("targetFiles");
        String string3 = this.getValueForParam("keystore_type");
        String string4 = this.getValueForParam("keystore_file");
        String string5 = this.getValueForParam("keystore_password");
        String string6 = this.getValueForParam("systempropskey");
        String string7 = this.getValueForParam("systempropsvalue");
        if (string4 != null && !string4.equalsIgnoreCase("none") && string5 != null && !string5.equalsIgnoreCase("none")) {
            this.hasKeyStore = true;
            object6 = new ArrayList();
            ((ArrayList)object6).add(string4);
            ((ArrayList)object6).add(string5);
            ((ArrayList)object6).add(string3);
            this.targetTable.put("KeyStoreFile", object6);
        }
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            this.hasCertificate = true;
            object6 = new StringTokenizer(string2, ",");
            object5 = new ArrayList();
            while (((StringTokenizer)object6).hasMoreTokens()) {
                object4 = ((StringTokenizer)object6).nextToken().trim();
                object3 = new String[]{"certificate", object4};
                this.targets.add(object3);
                ((ArrayList)object5).add(object4);
                this.infoTable.put((String)object3[0] + ":" + (String)object3[1], object4);
            }
            if (((ArrayList)object5).size() > 0) {
                this.targetTable.put("certificates", object5);
            }
        }
        if (string != null && !string.equalsIgnoreCase("none")) {
            object6 = new StringTokenizer(string, ",");
            object5 = new ArrayList();
            object4 = new ArrayList();
            while (((StringTokenizer)object6).hasMoreTokens()) {
                object3 = ((StringTokenizer)object6).nextToken().trim();
                if (((String)object3).indexOf("certificate:") > -1 || ((String)object3).indexOf("Certificate:") > -1) {
                    this.hasCertificate = true;
                    object2 = ((String)object3).substring(((String)object3).indexOf(":") + 1);
                    object = new String[]{"certificate", object2};
                    this.targets.add(object);
                    ((ArrayList)object5).add(object2);
                    this.infoTable.put((String)object[0] + ":" + (String)object[1], object2);
                    continue;
                }
                this.hasURL = true;
                int n = ((String)object3).lastIndexOf(":");
                if (n >= 0) {
                    object = ((String)object3).substring(0, n).trim();
                    String string8 = ((String)object3).substring(n + 1);
                    if (((String)object).startsWith("https") && ((String)object).length() == 5) {
                        object = ((String)object3).substring(8);
                        string8 = "443";
                    } else if (((String)object).startsWith("https") && ((String)object).length() > 5) {
                        object = ((String)object).substring(8);
                    }
                    String[] stringArray2 = new String[]{object, string8};
                    this.targetsUrl.add(stringArray2);
                    ((ArrayList)object4).add((String)object + ":" + string8);
                    object3 = this.getValidInfoString((String)object3);
                    this.infoTable.put(stringArray2[0] + ":" + stringArray2[1], object3);
                    continue;
                }
                object = new String[]{object3, "443"};
                this.targetsUrl.add(object);
                ((ArrayList)object4).add((String)object3 + ":443");
                object3 = this.getValidInfoString((String)object3);
                this.infoTable.put((String)object[0] + ":" + (String)object[1], object3);
            }
            if (((ArrayList)object5).size() > 0) {
                if (this.targetTable.containsKey("certificates")) {
                    object3 = (ArrayList)this.targetTable.get("certificates");
                    ((ArrayList)object3).addAll(object5);
                    this.targetTable.put("certificates", object3);
                } else {
                    this.targetTable.put("certificates", object5);
                }
            }
            if (((ArrayList)object4).size() > 0) {
                this.isAvailUrl = true;
                this.targetTable.put("URLs", object4);
            }
        }
        if (!(this.hasKeyStore || this.hasCertificate || this.hasURL)) {
            object6 = new String[]{this.targetHost, this.portNo};
            this.targets.add(object6);
            System.out.println("[" + this.entity + "] is configured with default parameters alone !!!");
        }
        if (string6 != null && !string6.equals("")) {
            object6 = new StringTokenizer(string6, ",");
            while (((StringTokenizer)object6).hasMoreTokens()) {
                object5 = ((StringTokenizer)object6).nextToken().trim();
                this.cerSysPropKey.add(object5);
            }
            object5 = new StringTokenizer(string7, ",");
            while (((StringTokenizer)object5).hasMoreTokens()) {
                object4 = ((StringTokenizer)object5).nextToken().trim();
                this.cerSysPropVal.add(object4);
            }
        }
        try {
            object6 = EgSSL.getInstance();
            EgSSL.enableSSL();
            object5 = new MyX509TrustManager();
            object4 = null;
            object3 = new TrustManager[]{object5};
            object2 = SSLContext.getInstance("SSL");
            ((SSLContext)object2).init((KeyManager[])object4, (TrustManager[])object3, new SecureRandom());
            object = ((SSLContext)object2).getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)object);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            System.err.println("[SSLCertificateBase][SSLCertificateBase]: " + exception.toString());
        }
    }

    protected static byte[] getAuthorityKeyId(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.35");
        if (byArray == null) {
            return null;
        }
        DEROctetString dEROctetString = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)aSN1InputStream.readObject());
        return authorityKeyIdentifier.getKeyIdentifier();
    }

    protected static ArrayList getCrlDistributionPoint(X509Certificate x509Certificate) throws CertificateParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x509Certificate.getEncoded());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            TBSCertificateStructure tBSCertificateStructure = x509CertificateStructure.getTBSCertificate();
            X509Extensions x509Extensions = tBSCertificateStructure.getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(aSN1ObjectIdentifier);
                    ASN1OctetString aSN1OctetString = x509Extension.getValue();
                    ASN1InputStream aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
                    if (!aSN1ObjectIdentifier.equals((ASN1Primitive)X509Extensions.CRLDistributionPoints)) continue;
                    CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1InputStream2.readObject());
                    DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
                    for (int i = 0; i != distributionPointArray.length; ++i) {
                        DistributionPoint distributionPoint = distributionPointArray[i];
                        DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                        GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
                        GeneralName[] generalNameArray = generalNames.getNames();
                        for (int j = 0; j < generalNameArray.length; ++j) {
                            if (generalNameArray[j].getTagNo() != 6) continue;
                            ASN1String aSN1String = (ASN1String)generalNameArray[j].getName();
                            arrayList.add(aSN1String.getString());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[SSLCertificateBase][getCrlDistributionPoint]: " + exception.toString());
        }
        return arrayList;
    }

    protected static ASN1Primitive getExtensionValue(X509Certificate x509Certificate, String string) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
        return aSN1InputStream.readObject();
    }

    protected static String getStringFromGeneralNames(ASN1Primitive aSN1Primitive) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Primitive), (boolean)false);
        if (aSN1Sequence.size() == 0) {
            return null;
        }
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(0);
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)dERTaggedObject, (boolean)false).getOctets());
    }

    protected static String getThumbPrint(X509Certificate x509Certificate, MessageDigest messageDigest) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] byArray = x509Certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        if (byArray2 != null) {
            return SSLCertificateBase.hexify(byArray2);
        }
        return null;
    }

    protected static String hexify(byte[] byArray) {
        StringBuffer stringBuffer = null;
        if (byArray != null) {
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            stringBuffer = new StringBuffer(byArray.length * 2);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
                stringBuffer.append(cArray[byArray[i] & 0xF]);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private String getValidInfoString(String string) {
        int n;
        if (string.startsWith("tcp_")) {
            string = string.substring(4);
        }
        if ((n = string.indexOf("_")) > -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

