/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.EgCrypt;
import com.eg.IniFile;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public abstract class RedisBase
extends GenericTest {
    public RedisInfo redisInfo = null;
    boolean isItAgentLessComp = false;
    private static final String COLON_DELIMITER = ":";
    private static final String COMMA_DELIMITER = ",";
    private static final String EQUALS_DELIMITER = "=";
    private static final String HASH_DELIMITER = "#";
    private static final int REDIS_DEFAULT_PORT = 6379;
    private static final String REDIS_DEFAULT_IP = "127.0.0.1";
    public static String installDir = EgInstallInfo.getInstallDir();
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    public static final Logger logger = AgentLogger.testLogger;
    protected final String testStart = " " + this.entity + " - Test cycle START";
    protected final String testEnd = " " + this.entity + " - Test cycle END";
    protected String logPrefix = " [" + this.reportingName + ":" + this.portNo + "] [" + this.entity + "] ";
    private String descriptorName = "";
    boolean isDescriptorName = false;
    public Hashtable hshValidatorList = new Hashtable();
    private double previousUpTime = 0.0;
    private boolean isRestarted = false;

    public RedisBase(String[] stringArray) {
        super(stringArray);
        try {
            logger.info("{} Initializing RedisBase ...", (Object)this.logPrefix);
            this.redisInfo = new RedisInfo(this.reportingName);
            String string = this.getValueForParam("expected_redis_role");
            if (string == null || string.length() <= 0 || string.equalsIgnoreCase("none")) {
                logger.info("{} Expected REDIS Role is null or empty or none : {}", (Object)this.logPrefix, (Object)string);
                logger.info("{} Continuing without REDIS Role", (Object)this.logPrefix);
                this.redisInfo.setRedisRole(string);
            } else {
                this.redisInfo.setRedisRole(string);
                logger.info("{} Redis Server is configured with expected Redis role :{}", (Object)this.logPrefix, (Object)string);
            }
            String string2 = this.getValueForParam("username");
            if (string2 == null || string2.length() <= 0 || string2.equalsIgnoreCase("none")) {
                logger.info("{} REDIS username is null or empty or none : {}", (Object)this.logPrefix, (Object)string2);
                logger.info("{} Continuing without username", (Object)this.logPrefix);
            } else {
                this.redisInfo.setRedisUser(string2);
                logger.info("{} Redis Server is enabled with username authentication.", (Object)this.logPrefix);
            }
            String string3 = this.getValueForParam("Redis_password");
            if (string3 == null || string3.length() <= 0 || string3.equalsIgnoreCase("none")) {
                logger.info("{} REDIS password is null or empty or none : {}", (Object)this.logPrefix, (Object)string3);
                logger.info("{} Continuing without password", (Object)this.logPrefix);
            } else {
                this.redisInfo.setRedisPass(string3);
                logger.info("{} Redis Server is enabled with password authentication.", (Object)this.logPrefix);
            }
            this.isItAgentLessComp = this.isSSH && this.alos != null && this.alos.equalsIgnoreCase("LINUX");
            logger.debug("{} isItAgentLessComp flag : {}", (Object)this.logPrefix, (Object)this.isItAgentLessComp);
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info("{} REDIS IPAddress is null or empty or none : {}", (Object)this.logPrefix, (Object)this.targetHost);
                logger.info("{} Using Default REDIS IPAddress :", (Object)this.logPrefix, (Object)REDIS_DEFAULT_IP);
                this.redisInfo.setRedisIp(REDIS_DEFAULT_IP);
            } else {
                logger.info("{} Using REDIS IPAddress : {}", (Object)this.logPrefix, (Object)this.targetHost);
                this.redisInfo.setRedisIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info("{} REDIS Port is null or empty or none : {}", (Object)this.logPrefix, (Object)this.portNo);
                logger.info("{} Using Default REDIS port : {}", (Object)this.logPrefix, (Object)6379);
                this.redisInfo.setRedisPort(6379);
            } else {
                try {
                    int n = Integer.parseInt(this.portNo);
                    logger.info("{} Using REDIS Port : {}", (Object)this.logPrefix, (Object)n);
                    this.redisInfo.setRedisPort(n);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info("{} Invalid Redis port number :{}", (Object)this.logPrefix, (Object)this.portNo);
                    logger.info("{} Using Default REDIS port : {}", (Object)this.logPrefix, (Object)6379);
                    this.redisInfo.setRedisPort(6379);
                }
            }
            try {
                String string4 = this.getValueForParam("ssl");
                boolean bl = Boolean.parseBoolean(string4);
                this.redisInfo.setRedisSsl(bl);
                logger.info("{} Using Redis SSL : {}", (Object)this.logPrefix, (Object)this.redisInfo.isRedisSsl());
            }
            catch (Exception exception) {
                logger.warn("{} Exception while getting ssl param {}", (Object)this.logPrefix, (Object)exception);
            }
            this.updateINIFileObject();
            logger.info("{} RedisBase initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisBase {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys(String string, int n) {
        ArrayList arrayList = new ArrayList();
        Jedis jedis = null;
        try {
            ScanResult scanResult;
            jedis = this.getConnection();
            ScanParams scanParams = new ScanParams();
            scanParams.count(Integer.valueOf(n));
            scanParams.match(string);
            String string2 = "0";
            do {
                List list;
                if ((list = (scanResult = jedis.scan(string2, scanParams)).getResult()) == null || list.size() <= 0) continue;
                arrayList.addAll(list);
            } while (!(string2 = scanResult.getCursor()).equals("0"));
            arrayList = this.getKeyTypeAsStream(arrayList, jedis);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while getKeysFromClusterNode {}", (Object)this.logPrefix, (Object)exception);
            this.logToErrorFile("ERROR", this.entity, "Exception occurred in getKeys: : " + exception.getMessage());
        }
        finally {
            jedis.close();
        }
        logger.info("{} RedisBase keys successfully", (Object)this.logPrefix, arrayList);
        return arrayList;
    }

    public ArrayList getKeyTypeAsStream(ArrayList arrayList, Jedis jedis) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                String string2 = jedis.type(string);
                if (string2 == null || string2.length() <= 0 || !string2.equalsIgnoreCase("stream")) continue;
                arrayList2.add(string);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception while getKeyTypeAsStream {}", (Object)this.logPrefix, (Object)exception);
            this.logToErrorFile("ERROR", this.entity, "Exception occurred in getKeyTypeAsStream: : " + exception.getMessage());
        }
        logger.info("{} RedisBase updated keys ", (Object)this.logPrefix, arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetrics(String string) {
        if (string == null || string.length() <= 0) {
            logger.info("{} REDIS_COMMAND is NULL or EMPTY hence returning null String", (Object)this.logPrefix);
            return null;
        }
        String string2 = null;
        Jedis jedis = null;
        try {
            jedis = this.getConnection();
            if (jedis == null) {
                logger.info("{} JEDIS Connection object is NULL hence returning null String", (Object)this.logPrefix);
                String string3 = null;
                return string3;
            }
            string2 = jedis.info(string);
            logger.debug("{} Successfully executed the REDIS Command", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} [getRedisMetrics] Exception occured while connecting to Redis..", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            this.closeConnection(jedis);
            jedis = null;
        }
        logger.debug("{} Result for REDIS Command [" + string + "] :{}", (Object)this.logPrefix, (Object)string2);
        return string2;
    }

    public Jedis getConnection() throws Exception {
        Jedis jedis = null;
        try {
            jedis = new Jedis(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort(), this.redisInfo.isRedisSsl());
            String string = this.redisInfo.getRedisUser();
            String string2 = this.redisInfo.getRedisPass();
            logger.debug("{} {}", (Object)this.logPrefix, (Object)this.redisInfo);
            try {
                if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("none") && string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                    jedis.auth(string2);
                    this.hshValidatorList.put("Connection", "connection ok with authenication");
                    logger.trace("{} JEDIS Connection authenticated with username {}, password[Encrypted] :{} .", new Object[]{this.logPrefix, string, EgCrypt.encrypt(string2)});
                    logger.debug("{} JEDIS Connection is created successfully with username & password", (Object)this.logPrefix);
                    return jedis;
                }
            }
            catch (Throwable throwable) {
                logger.warn("{} [getConnection] Error while connecting to Redis Server {}", (Object)this.logPrefix, (Object)throwable);
            }
            if (string2 == null || string2.length() <= 0 || string2.equalsIgnoreCase("none")) {
                logger.debug("{} REDIS password is null or empty or none : {} Hence returning the JEDIS Connection WITHOUT authenticating.", (Object)this.logPrefix, (Object)string2);
                logger.debug("{} JEDIS Connection is created successfully !!!", (Object)this.logPrefix);
                this.hshValidatorList.put("Connection", "connection ok with out authenication");
                return jedis;
            }
            jedis.auth(string2);
            this.hshValidatorList.put("Connection", "connection ok with authenication");
            logger.trace("{} Password authentication is success !!!", (Object)this.logPrefix);
            logger.debug("{} JEDIS Connection is created successfully with password authentication !!!", (Object)this.logPrefix);
            return jedis;
        }
        catch (JedisConnectionException jedisConnectionException) {
            logger.warn("{} [getConnection] Error while connecting to Redis Server {}", (Object)this.logPrefix, (Object)jedisConnectionException);
            this.hshValidatorList.put("Connection", "JedisConnectionException:" + jedisConnectionException.getMessage());
            this.closeConnection(jedis);
            throw jedisConnectionException;
        }
        catch (JedisDataException jedisDataException) {
            logger.warn("{} [getConnection] Error while authenticating Redis Server {}", (Object)this.logPrefix, (Object)jedisDataException);
            this.hshValidatorList.put("Connection", "dataError:" + jedisDataException.getMessage());
            this.closeConnection(jedis);
            throw jedisDataException;
        }
        catch (Exception exception) {
            logger.warn("{} [getConnection] Error while authenticating Redis Server {}", (Object)this.logPrefix, (Object)exception);
            this.hshValidatorList.put("Connection", "Exception:" + exception.getMessage());
            this.closeConnection(jedis);
            throw exception;
        }
    }

    public void closeConnection(Jedis jedis) {
        if (jedis == null) {
            logger.trace("{} JEDIS Connection null or already closed !!!", (Object)this.logPrefix);
        } else {
            try {
                if (jedis.isConnected()) {
                    jedis.close();
                    jedis = null;
                    logger.debug("{} JEDIS Connection is closed successfully !!!", (Object)this.logPrefix);
                } else {
                    jedis = null;
                    logger.debug("{} JEDIS Connection is already closed !!!", (Object)this.logPrefix);
                }
            }
            catch (Exception exception) {
                logger.warn("{} [closeConnection] Error while closing the Jedis connection {}", (Object)this.logPrefix, (Object)exception);
            }
        }
    }

    public void updateINIFileObject() {
        if (iniFilePath != null && iniFilePath.length() != 0 && !iniFilePath.equalsIgnoreCase("none")) {
            try {
                IniFile iniFile = new IniFile(installDir + iniFilePath);
                this.redisInfo.setEgMeasures(iniFile);
                logger.debug("{} [updateINIFileObject] updating the INI File : {}", (Object)this.logPrefix, (Object)iniFilePath);
            }
            catch (Exception exception) {
                logger.warn("{} [updateINIFileObject] Exception Occured  : {} {}", new Object[]{this.logPrefix, iniFilePath, exception});
            }
        }
    }

    private boolean hasDescriptorName(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.indexOf(COLON_DELIMITER) > -1 && string.indexOf(EQUALS_DELIMITER) > -1;
    }

    public boolean isValidMeasureLine(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.indexOf(string2) > -1;
    }

    public boolean isValidCategoryLine(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.indexOf(HASH_DELIMITER) >= 0;
    }

    public Hashtable parseMetrics(String string, boolean bl) {
        logger.debug("{} Inside [parseMetrics] the redis measures are being parsed ", (Object)this.logPrefix);
        Hashtable hashtable = new Hashtable();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String string2 = "";
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            Hashtable<String, Hashtable<String, String>> hashtable4 = new Hashtable<String, Hashtable<String, String>>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = stringTokenizer.nextToken().trim();
                if (this.isValidMeasureLine(string6, COLON_DELIMITER)) {
                    if (bl && this.hasDescriptorName(string6)) {
                        string3 = string6.substring(0, string6.indexOf(COLON_DELIMITER)).trim();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string6.substring(string6.indexOf(COLON_DELIMITER) + 1).trim(), COMMA_DELIMITER);
                        hashtable3 = new Hashtable();
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string7 = stringTokenizer2.nextToken();
                            if (!this.isValidMeasureLine(string7, EQUALS_DELIMITER)) continue;
                            string4 = string7.substring(0, string7.indexOf(EQUALS_DELIMITER)).trim();
                            string5 = string7.substring(string7.indexOf(EQUALS_DELIMITER) + 1).trim();
                            string4 = string4.contains(COLON_DELIMITER) ? string4.replace(COLON_DELIMITER, "") : string4;
                            hashtable3.put(string4, string5);
                        }
                        hashtable4.put(string3, hashtable3);
                        continue;
                    }
                    string4 = string6.substring(0, string6.indexOf(COLON_DELIMITER)).trim();
                    string5 = string6.substring(string6.indexOf(COLON_DELIMITER) + 1).trim();
                    hashtable2.put(string4, string5);
                    continue;
                }
                if (!this.isValidCategoryLine(string6)) continue;
                string2 = string6.substring(1).trim();
            }
            if (bl) {
                logger.debug("{} [parseMetrics] the result table is info based ", (Object)this.logPrefix);
                hashtable.put(string2, hashtable4);
            } else {
                logger.debug("{} [parseMetrics] the result table is non-info based ", (Object)this.logPrefix);
                hashtable.put(string2, hashtable2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} [parseMetrics] Exception occured while fetching the values from testTable ", (Object)this.logPrefix, (Object)exception);
        }
        logger.info("{} [parseMetrics] The Resultant table of parsed metrics : \n {}", (Object)this.logPrefix, hashtable);
        return hashtable;
    }

    public long getModifiedTime() {
        IniFile iniFile = this.redisInfo.getEgMeasures();
        long l = IniFile.getLastModified(installDir + iniFilePath);
        logger.info("{} [getModifiedTime] The INI File : {} was modified latestly on {}", new Object[]{this.logPrefix, iniFilePath, l});
        return l;
    }

    public Hashtable getIndexTable(String string) {
        IniFile iniFile = this.redisInfo.getEgMeasures();
        String[] stringArray = iniFile.getVariables(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], iniFile.getValue(string, stringArray[i]));
        }
        logger.info("{} [getIndexTable] returning the table of INI name and index of the Subject {} in indexMappingTable : {}", new Object[]{this.logPrefix, string, hashtable});
        return hashtable;
    }

    public Hashtable getNameTable(String string) {
        IniFile iniFile = this.redisInfo.getEgMeasures();
        String[] stringArray = iniFile.getVariables(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = iniFile.getValue(string, stringArray[i]);
            String string3 = "";
            if (string2.contains(COMMA_DELIMITER)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, COMMA_DELIMITER);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    hashtable.put(string3, stringArray[i]);
                }
                continue;
            }
            hashtable.put(string2, stringArray[i]);
        }
        logger.info("{} [getNameTable] returning the table of redis name and INI name of the Subject {} in nameMappingTable : ", new Object[]{this.logPrefix, string, hashtable});
        return hashtable;
    }

    public ArrayList getNameList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable hashtable = this.getNameTable(string);
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            arrayList.add(string2);
        }
        logger.info("{} [getNameList] returning the list of redis name of the Subject {} in redisNameList : {}", new Object[]{this.logPrefix, string, arrayList});
        return arrayList;
    }

    public ArrayList finalMeasures(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(-5.0));
        }
        logger.trace("{} [finalMeasures] creating and initializing the measure list ", (Object)this.logPrefix);
        return arrayList;
    }

    public void getRedisMeasureNonInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureNonInfoBased]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)hashtable2);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)hashtable3);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug("{} [getRedisMeasureNonInfoBased] The Metric key and value table is : ", (Object)this.logPrefix, (Object)hashtable4);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d = Double.parseDouble(object.toString());
                        arrayList2.set(n, new Double(d));
                        logger.debug("{} [getRedisMeasureNonInfoBased] index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, n, string4, d});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                    }
                }
                logger.info("{} [getRedisMeasureNonInfoBased]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList2);
                this.addMeasures(arrayList2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureNonInfoBased] {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public void getRedisMeasureInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureInfoBased]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
                l = l2;
            }
            logger.debug(" metricObject      : {}", (Object)hashtable);
            logger.debug(" measureIndexTable : {}", (Object)hashtable2);
            logger.debug(" measureNameTable  : {}", (Object)hashtable3);
            logger.debug(" redisNameList     : {}", (Object)arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                logger.debug("{} [getRedisMeasureInfoBased] The Test Name is  : {}", (Object)this.logPrefix, (Object)string3);
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug("{} [getRedisMeasureInfoBased] The Discriptor Table is : {}", (Object)this.logPrefix, (Object)hashtable4);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureInfoBased] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Hashtable hashtable5 = null;
                    try {
                        hashtable5 = (Hashtable)hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureInfoBased] Exception occured while getting fetching the values from discriptor table {}", (Object)this.logPrefix, (Object)exception);
                    }
                    this.isDescriptorName = true;
                    this.descriptorName = string4;
                    if (hashtable5 == null || hashtable5.size() <= 0) continue;
                    Iterator iterator3 = (Iterator)((Object)hashtable5.keys());
                    while (iterator3.hasNext()) {
                        String string5 = (String)iterator3.next();
                        Object object = null;
                        try {
                            object = hashtable5.get(string5);
                        }
                        catch (Exception exception) {
                            logger.warn("{} [getRedisMeasureInfoBased] Exception occured while getting fetching the values from metric table {} {}", new Object[]{this.logPrefix, hashtable5, exception});
                        }
                        if (!arrayList.contains(string5)) continue;
                        String string6 = (String)hashtable3.get(string5);
                        int n = Integer.parseInt(hashtable2.get(string6).toString());
                        try {
                            double d = Double.parseDouble(object.toString());
                            arrayList2.set(n, new Double(d));
                            logger.debug("{} [getRedisMeasureInfoBased] discriptor : {} index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, this.descriptorName, n, string5, d});
                        }
                        catch (Exception exception) {
                            logger.warn("{} [getRedisMeasureInfoBased] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                        }
                    }
                    logger.info("{} [getRedisMeasureInfoBased] {},The ArrayList  measure contains = ", new Object[]{this.logPrefix, this.descriptorName, arrayList2});
                    this.addMeasures(this.descriptorName, arrayList2);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureNonInfoBased] {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public boolean isRedisRestarted() {
        String string = this.getMetrics("Server");
        Hashtable hashtable = this.parseMetrics(string, false);
        Hashtable hashtable2 = (Hashtable)hashtable.get("Server");
        Object v = hashtable2.get("uptime_in_seconds");
        try {
            double d = Double.parseDouble(v.toString());
            logger.debug("{} The up time of Redis : {}", (Object)this.logPrefix, (Object)d);
            logger.debug("{} The previous uptime of Redis : {}", (Object)this.logPrefix, (Object)this.previousUpTime);
            if (this.previousUpTime > d && this.previousUpTime > 0.0) {
                this.isRestarted = true;
                this.previousUpTime = d;
                logger.debug("{} [getRedisMeasureForCommandStats] Redis Server has been restarted......", (Object)this.logPrefix);
            } else {
                this.isRestarted = false;
                this.previousUpTime = d;
            }
        }
        catch (Exception exception) {
            logger.warn("{} [getRedisMeasureForCommandStats] Exception occured while parsing the String to Double {}", (Object)this.logPrefix, (Object)exception);
            this.isRestarted = false;
        }
        logger.debug("{} Is Redis server restarted : {}", (Object)this.logPrefix, (Object)this.isRestarted);
        return this.isRestarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getclientList() {
        Jedis jedis = null;
        String string = "";
        try {
            jedis = this.getConnection();
            if (jedis == null) {
                logger.debug("[getRedisMeasureClient] [getclientList] jedis is returning null...");
            } else {
                string = jedis.clientList();
                logger.debug("[getRedisMeasureClient] [getclientList] The Client List is :  \n {}", (Object)string);
                jedis.close();
            }
        }
        catch (Exception exception) {
            logger.warn("{} {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            this.closeConnection(jedis);
        }
        return string;
    }
}

