/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PsPartPacketTest
extends EgSnmpGenericTest {
    private static String descOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.2";
    private static String packetOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.6";
    private static String tcpPacketOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.7";
    private static String tcpReXmitPktOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.8";
    private static String LBLateDropPacketOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.41";
    private static String HBLateDropPacketOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.42";
    private static String LBSchedulerDropPktOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.45";
    private static String HBSchedulerDropPktOid = ".1.3.6.1.4.1.2334.2.1.3.2.1.46";
    private Hashtable prevPacketCountHT = new Hashtable();
    private Hashtable prevTCPacketHT = new Hashtable();
    Hashtable prevTCPReXmitPacketHT = new Hashtable();
    Hashtable prevLBLateDropPacketHT = new Hashtable();
    Hashtable prevHBLateDropPacketHT = new Hashtable();
    Hashtable prevLBSchedulerDropPktHT = new Hashtable();
    Hashtable prevHBSchedulerDropPktHT = new Hashtable();
    Hashtable partitionNamesHT = new Hashtable();
    Hashtable packetCountHT = new Hashtable();
    Hashtable tcpPacketHT = new Hashtable();
    Hashtable tcpReXmitPktHT = new Hashtable();
    Hashtable LBLateDropPacketHT = new Hashtable();
    Hashtable HBLateDropPacketHT = new Hashtable();
    Hashtable LBSchedulerDropPktHT = new Hashtable();
    Hashtable HBSchedulerDropPktHT = new Hashtable();
    private static final int PsPartPacket_MeasureCount = 7;

    public PsPartPacketTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
    }

    private void finish() {
        this.prevPacketCountHT = this.packetCountHT;
        this.prevTCPacketHT = this.tcpPacketHT;
        this.prevTCPReXmitPacketHT = this.tcpReXmitPktHT;
        this.prevLBLateDropPacketHT = this.LBLateDropPacketHT;
        this.prevHBLateDropPacketHT = this.HBLateDropPacketHT;
        this.prevLBSchedulerDropPktHT = this.LBSchedulerDropPktHT;
        this.prevHBSchedulerDropPktHT = this.HBSchedulerDropPktHT;
    }

    private void start() {
        this.partitionNamesHT = new Hashtable();
        this.packetCountHT = new Hashtable();
        this.tcpPacketHT = new Hashtable();
        this.tcpReXmitPktHT = new Hashtable();
        this.LBLateDropPacketHT = new Hashtable();
        this.HBLateDropPacketHT = new Hashtable();
        this.LBSchedulerDropPktHT = new Hashtable();
        this.HBSchedulerDropPktHT = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        this.start();
        try {
            this.partitionNamesHT = this.getStringFromSnmp(descOid);
            this.packetCountHT = this.getStringFromSnmp(packetOid);
            this.tcpPacketHT = this.getStringFromSnmp(tcpPacketOid);
            this.tcpReXmitPktHT = this.getStringFromSnmp(tcpReXmitPktOid);
            this.LBLateDropPacketHT = this.getStringFromSnmp(LBLateDropPacketOid);
            this.HBLateDropPacketHT = this.getStringFromSnmp(HBLateDropPacketOid);
            this.LBSchedulerDropPktHT = this.getStringFromSnmp(LBSchedulerDropPktOid);
            this.HBSchedulerDropPktHT = this.getStringFromSnmp(HBSchedulerDropPktOid);
            Hashtable hashtable2 = this.getDiff(this.packetCountHT, this.prevPacketCountHT);
            Hashtable hashtable3 = this.getDiff(this.tcpPacketHT, this.prevTCPacketHT);
            Hashtable hashtable4 = this.getDiff(this.tcpReXmitPktHT, this.prevTCPReXmitPacketHT);
            Hashtable hashtable5 = this.getDiff(this.LBLateDropPacketHT, this.prevLBLateDropPacketHT);
            Hashtable hashtable6 = this.getDiff(this.HBLateDropPacketHT, this.prevHBLateDropPacketHT);
            Hashtable hashtable7 = this.getDiff(this.LBSchedulerDropPktHT, this.prevLBSchedulerDropPktHT);
            Hashtable hashtable8 = this.getDiff(this.HBSchedulerDropPktHT, this.prevHBSchedulerDropPktHT);
            Enumeration enumeration = this.partitionNamesHT.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                if (string.startsWith(".")) continue;
                String string2 = (String)this.partitionNamesHT.get(string);
                double d7 = (Double)hashtable2.get(string);
                d = (Double)hashtable3.get(string);
                d2 = (Double)hashtable4.get(string);
                d3 = (Double)hashtable5.get(string);
                d4 = (Double)hashtable6.get(string);
                d5 = (Double)hashtable7.get(string);
                d6 = (Double)hashtable8.get(string);
                if (debug) {
                    System.out.println("[PsPartPacketTest] Packet_count Diff value " + d7);
                    System.out.println("[PsPartPacketTest] Tcp_packet_count Diff value " + d);
                    System.out.println("[PsPartPacketTest] Tcp_Retransmit packet_count Diff value " + d2);
                    System.out.println("[PsPartPacketTest] lowerbyte_dropPacketCount_count Diff value " + d3);
                    System.out.println("[PsPartPacketTest] Highbyte_dropPacketCount_count Diff value " + d4);
                    System.out.println("[PsPartPacketTest] lowerbyte_schedulerPacketCount_count Diff value " + d5);
                    System.out.println("[PsPartPacketTest] lowerbyte_schedulerPacketCount_count Diff value " + d6);
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                if (debug) {
                    System.out.println("[PsPartPacketTest] ===>" + string2 + " ===> " + arrayList);
                }
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", this.entity + ",error occur in computeMeasures", exception.toString());
            exception.printStackTrace();
        }
        this.finish();
    }

    private Hashtable getStringFromSnmp(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                String string2 = this.rhs[i];
                if (string2 == null || string2.trim().length() == 0) continue;
                hashtable.put(this.lhs[i], string2.trim());
                continue;
            }
            catch (Exception exception) {
                this.logToErrorFile("Error:", this.entity + ",error in getStringFromSnmp", exception.toString());
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    private Hashtable getDiff(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        if (hashtable == null || hashtable2 == null) {
            return hashtable3;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            String string3 = (String)hashtable2.get(string);
            double d = -5.0;
            double d2 = -5.0;
            try {
                if (string2 == null || string2.trim().length() <= 0) continue;
                d = Double.parseDouble(string2);
                if (string3 == null || string3.trim().length() <= 0) {
                    hashtable3.put(string, new Double(-5.0));
                    continue;
                }
                d2 = Double.parseDouble(string3);
                double d3 = -5.0;
                if (d2 >= 0.0 && d >= d2) {
                    d3 = d - d2;
                }
                if (d3 < 0.0) {
                    d3 = -5.0;
                }
                hashtable3.put(string, new Double(d3));
            }
            catch (Exception exception) {
                this.logToErrorFile("Error:", "PsPartPacketTest.getDiff", exception.toString());
                exception.printStackTrace();
            }
        }
        return hashtable3;
    }

    public static void main(String[] stringArray) {
        PsPartPacketTest psPartPacketTest = new PsPartPacketTest(stringArray);
        psPartPacketTest.computeMeasures(new Hashtable());
    }
}

