/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraClientConnsTest
extends GenericTest {
    EgUtilities egutil = EgUtilities.createInstance();
    private double cpuUtil;
    private double memUtil;
    private int countProcesses;
    private String sidName;
    private int ramSize = -1;
    private static int numProcessors = -1;
    private int defValue = 0;
    private static int pageSize = EgInstallInfo.pageSize;
    private String listenerName = "";

    public static void main(String[] stringArray) {
        OraClientConnsTest oraClientConnsTest = new OraClientConnsTest(stringArray);
        oraClientConnsTest.computeMeasures(new Hashtable());
    }

    public OraClientConnsTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(3);
        this.sidName = this.getValueForParam("sid");
        if (this.sidName == null || this.sidName.length() == 0) {
            this.sidName = this.getValueForParam("info");
        }
        this.listenerName = this.getValueForParam("listener_name");
        this.defValue = this.isPassive ? -5 : 0;
        if (numProcessors < 0) {
            numProcessors = EgInstallInfo.numProcessors();
        }
        if (this.ramSize < 0) {
            this.ramSize = EgInstallInfo.findRamSize();
        }
        this.setSid(this.sidName);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.countProcesses = 0;
        this.cpuUtil = this.memUtil = (double)0;
        String string = "egprocess_check";
        ArrayList arrayList2 = this.egutil.getExecOutputLines(string);
        if (arrayList2 == null || arrayList2.size() < 2) {
            return;
        }
        if ((arrayList2 = (ArrayList)arrayList2.get(0)) == null || arrayList2.size() == 0) {
            return;
        }
        int n = arrayList2.size();
        numProcessors = EgInstallInfo.numProcessors();
        for (int i = 0; i < n; ++i) {
            StringTokenizer stringTokenizer;
            String string2 = (String)arrayList2.get(i);
            if (string2.startsWith("USER") || string2.indexOf(this.listenerName) < 0 || string2.indexOf("LOCAL=") <= 0 || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 4) continue;
            stringTokenizer.nextToken();
            String string3 = new String(stringTokenizer.nextToken());
            String string4 = new String(stringTokenizer.nextToken());
            double d = Double.parseDouble(string4);
            ++this.countProcesses;
            this.cpuUtil += Double.parseDouble(string3);
            this.memUtil += d;
        }
        if (this.isPassive && this.countProcesses == 0) {
            arrayList.add(new Double(this.defValue));
            arrayList.add(new Double(this.defValue));
            arrayList.add(new Double(this.defValue));
            this.addNewMeasure(arrayList);
        } else {
            this.memUtil *= (double)pageSize;
            this.memUtil /= 1024.0;
            this.memUtil = this.memUtil / (double)this.ramSize * 100.0;
            this.cpuUtil /= (double)numProcessors;
            arrayList.add(new Double(this.countProcesses));
            arrayList.add(new Double(this.cpuUtil));
            double d = this.memUtil;
            if (this.countProcesses > 0 && d > 0.0) {
                d /= (double)this.countProcesses;
            }
            arrayList.add(new Double(d));
            this.addNewMeasure(arrayList);
        }
    }
}

