/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUptimeTest
extends NodeBase {
    private static final String nodeJsInfoProps = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/logs/nodejsinfo.properties";
    private static final String nodeSync = new String("NodeSync");
    private HashMap<String, String> nodeUptimeDDLines = new HashMap();
    private String reportMgrTime = new String("");
    private boolean isReportMgrTime = true;

    public NodeUptimeTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            File f = new File(nodeJsInfoProps);
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (IOException f) {
            // empty catch block
        }
        try {
            logger.info("{} Initializing NodeUpTimeTest ...", (Object)this.logPrefix);
            this.reportMgrTime = this.getValueForParam("reportmanagertime");
            this.isReportMgrTime = this.reportMgrTime == null || !this.reportMgrTime.equalsIgnoreCase("no") && !this.reportMgrTime.equalsIgnoreCase("false");
            logger.info("{} NodeUpTimeTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{} Exception while initializing {}", (Object)this.logPrefix, (Object)initException);
        }
    }

    @Override
    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        logger.debug("{} - NodeUptimeTest Test cycle starting ", (Object)this.logPrefix);
        Hashtable<String, Double> uptimeInfo = null;
        try {
            logger.debug("{} - params : {} nodeJvmGUID : {} ", new Object[]{this.logPrefix, params.toString(), this.apmComponentGUID});
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{} nodeJvmGUID: {} is not available", (Object)this.logPrefix, (Object)this.apmComponentGUID);
                return;
            }
            NodeInfraCluster nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            NodeInfra master = nodeInfraCluster.getMaster();
            if (master != null && master.isMaster()) {
                ArrayList measures = new ArrayList();
                String workerId = master.getWorkerId();
                uptimeInfo = this.pullNodeJsUptimeStatistics(workerId, master.getTotalUptime());
                this.addMeasures("Master", uptimeInfo, master.getProcessID());
                master.setTotalUptime(-5L);
            }
            HashMap<String, NodeInfra> workers = nodeInfraCluster.getWorkers();
            HashMap workersClone = null;
            if (workers != null && workers.size() > 0) {
                workersClone = (HashMap)workers.clone();
                for (String key : workersClone.keySet()) {
                    String discriptorName;
                    NodeInfra infraByPid = (NodeInfra)workersClone.get(key);
                    String string = discriptorName = infraByPid.getMode().equalsIgnoreCase("STANDALONE") ? key : "Worker_" + key;
                    if (key != null && key.equalsIgnoreCase("STANDALONE")) {
                        key = "-1";
                    }
                    long uptim = infraByPid.getTotalUptime();
                    uptimeInfo = this.pullNodeJsUptimeStatistics(key, uptim);
                    this.addMeasures(discriptorName, uptimeInfo, infraByPid.getProcessID());
                }
                workersClone.clear();
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while collecting NodeUptime object : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void addMeasures(String type, Hashtable<String, Double> uptimeInfo, String processId) {
        try {
            if (uptimeInfo != null && uptimeInfo.size() > 0) {
                Double reboot = uptimeInfo.get("Reboot");
                Double uptime = uptimeInfo.get("Uptime");
                Double totalUptime = uptimeInfo.get("TotalUptime");
                ArrayList<Double> measures = new ArrayList<Double>();
                measures.add(reboot);
                measures.add(uptime);
                measures.add(totalUptime);
                this.addNewMeasure(type, measures);
                logger.debug("{} Added measures for NodeJs Uptime Test{} : {}", new Object[]{this.logPrefix, type, measures});
            } else {
                logger.warn("{} NodeJs Uptime details are null or invalid for {} : {}", new Object[]{this.logPrefix, type, uptimeInfo});
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while adding measures for NodeJs Uptime Test : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private Hashtable<String, Double> pullNodeJsUptimeStatistics(String workerId, long currentUptime) {
        Hashtable<String, Double> uptimeDatas = new Hashtable<String, Double>();
        long currUpTime = 0L;
        double uptimeDiff = 0.0;
        double reboot = 0.0;
        double totalUpTime = 0.0;
        try {
            StringTokenizer stc;
            currUpTime = currentUptime;
            double prevUpTime = 0.0;
            long lastModify = 0L;
            String key = String.valueOf(this.reportingName) + ":" + this.portNo + ":" + this.entity + "_" + workerId;
            String s = this.getNodeJsPreviousValue(key);
            if (s != null && s.length() > 0 && s.indexOf("#") > -1 && (stc = new StringTokenizer(s, "#")).countTokens() == 2) {
                try {
                    prevUpTime = Double.parseDouble(stc.nextToken());
                    lastModify = Long.parseLong(stc.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (currUpTime < 0L) {
                reboot = -5.0;
                uptimeDiff = -5.0;
                totalUpTime = -5.0;
                this.setNodeJsCurrentValue(key, "0.0#" + System.currentTimeMillis());
            } else if ((double)currUpTime < prevUpTime) {
                uptimeDiff = (double)currUpTime / 1000.0;
                reboot = 1.0;
                totalUpTime = uptimeDiff;
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date dd = null;
                long realShutdown = 0L;
                long rebootTime = 0L;
                String shutDownTime = "";
                String whenReboot = "";
                long now = System.currentTimeMillis();
                if (this.isReportMgrTime) {
                    long diff = now - lastModify;
                    realShutdown = dateInfo.egetUTCDate() - diff;
                    shutDownTime = dateInfo.egetDate(realShutdown);
                    rebootTime = dateInfo.egetUTCDate() - currUpTime;
                    whenReboot = dateInfo.egetDate(rebootTime);
                } else {
                    realShutdown = lastModify;
                    dd = new Date(realShutdown);
                    shutDownTime = df.format(dd);
                    rebootTime = now - currUpTime;
                    dd = new Date(rebootTime);
                    whenReboot = df.format(dd);
                }
                long duration = rebootTime - realShutdown;
                if (duration > 0L) {
                    double downDuration = (double)duration / 1000.0 / 60.0;
                    String isUnderMaintenance = "No";
                    if (this.checkMaintenance()) {
                        isUnderMaintenance = "Yes";
                    }
                    String fieldSep = "#";
                    StringBuilder builder = new StringBuilder();
                    builder.append(shutDownTime).append(fieldSep).append(whenReboot).append(fieldSep).append(this.round(downDuration, 4)).append(fieldSep).append(isUnderMaintenance);
                    String nodeUptimeDDLine = builder.toString();
                    this.nodeUptimeDDLines.put(workerId, nodeUptimeDDLine);
                }
                this.setNodeJsCurrentValue(key, String.valueOf(String.valueOf(currUpTime) + "#" + System.currentTimeMillis()));
            } else {
                uptimeDiff = ((double)currUpTime - prevUpTime) / 1000.0;
                reboot = 0.0;
                totalUpTime = (double)currUpTime / 1000.0;
                this.setNodeJsCurrentValue(key, String.valueOf(String.valueOf(currUpTime) + "#" + System.currentTimeMillis()));
            }
            if (uptimeDiff == 0.0 && (double)currUpTime == prevUpTime) {
                uptimeDatas.put("Reboot", new Double(-5.0));
                uptimeDatas.put("Uptime", new Double(-5.0));
                uptimeDatas.put("TotalUptime", new Double(-5.0));
            } else {
                totalUpTime = this.secondsToMinutes(totalUpTime);
                uptimeDatas.put("Reboot", new Double(reboot));
                uptimeDatas.put("Uptime", new Double(uptimeDiff));
                uptimeDatas.put("TotalUptime", new Double(totalUpTime));
            }
            return uptimeDatas;
        }
        catch (Exception e) {
            e.printStackTrace();
            uptimeDatas = new Hashtable();
            uptimeDatas.put("Reboot", new Double(-5.0));
            uptimeDatas.put("Uptime", new Double(-5.0));
            uptimeDatas.put("TotalUptime", new Double(-5.0));
            return uptimeDatas;
        }
    }

    private double secondsToMinutes(double value) {
        if (value <= 0.0) {
            return value;
        }
        int min = (int)(value / 60.0);
        int sec = (int)(value % 60.0);
        double result = min + sec;
        String str = String.valueOf(min) + "." + sec;
        result = Double.parseDouble(str);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodeJsCurrentValue(String key, String value) {
        block15: {
            Properties JVMProps = new Properties();
            InputStream fis = null;
            try {
                try {
                    String string = nodeSync;
                    synchronized (string) {
                        fis = new FileInputStream(nodeJsInfoProps);
                        JVMProps.load(new BufferedInputStream(fis));
                        JVMProps.setProperty(key, value);
                        JVMProps.store(new BufferedOutputStream(new FileOutputStream(nodeJsInfoProps)), "eG Node JS Monitor Information file <P> PLEASE DO NOT DELETE <P>");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fis == null) break block15;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNodeJsPreviousValue(String key) {
        String s;
        block15: {
            s = null;
            Properties JVMProps = new Properties();
            InputStream fis = null;
            try {
                try {
                    String string = nodeSync;
                    synchronized (string) {
                        fis = new FileInputStream(nodeJsInfoProps);
                        JVMProps.load(new BufferedInputStream(fis));
                        s = JVMProps.getProperty(key);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fis == null) break block15;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return s;
    }

    public HashMap<String, String> getDDLine() {
        return this.nodeUptimeDDLines;
    }
}

