/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;

class NexentaMemTest
extends EgSnmpGenericTest {
    private static final int NEXENTA_MEM_MEASURE_COUNT = 4;

    public NexentaMemTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.setMeasureCount(4);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d = this.getMeasure(".1.3.6.1.4.1.2021.4.5.0");
        d2 = this.getMeasure(".1.3.6.1.4.1.2021.4.6.0");
        d3 = (d /= 1024.0) - (d2 /= 1024.0);
        d4 = d3 / d * 100.0;
        d4 = this.roundDouble(d4);
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ":  totalMemory==========>" + d);
            System.out.println(this.entity + " : " + this.reportingName + ":  freeMemory==========>" + d2);
            System.out.println(this.entity + " : " + this.reportingName + ":  usedMemory==========>" + d3);
            System.out.println(this.entity + " : " + this.reportingName + ":  usedPercent==========>" + d4);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ":  measure===>" + arrayList);
        }
        this.addNewMeasure(arrayList);
    }

    public double getMeasure(String string) {
        String string2 = "";
        double d = 0.0;
        boolean bl = this.runSnmpCmdForOid(string);
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + " :  OID  ===>" + string);
        }
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = 0.0;
                }
            }
        }
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + " : OID value ===>" + d);
        }
        return d;
    }

    private double roundDouble(double d) {
        DecimalFormat decimalFormat = new DecimalFormat(".##");
        String string = decimalFormat.format(d);
        double d2 = EgLangInfo.getDoubleValue(string);
        return d2;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.9.132", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        NexentaMemTest nexentaMemTest = new NexentaMemTest(stringArray2);
        nexentaMemTest.computeMeasures(new Hashtable());
    }
}

