/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluFlshDevTest
extends NAUSDCluBase {
    public NetCluFlshDevTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluFlshDevTest ", "Connection is null");
                this.printOut("Error", "NetCluFlshDevTest Connection is null");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluFlshDevTest error occured while connecting ", exception.toString());
            this.printOut("Error", "NetCluFlshDevTest error occured while connecting :" + exception.toString());
            exception.printStackTrace();
        }
        try {
            NaElement naElement = new NaElement("flash-device-get-iter");
            Iterator iterator = null;
            String string = "";
            while (string != null) {
                NaElement naElement2;
                naElement = new NaElement("flash-device-get-iter");
                naElement.addNewChild("max-records", "10");
                if (!string.equals("")) {
                    naElement.addNewChild("tag", string);
                }
                if ((naElement2 = this.execONTAPI(naServer, naElement)) == null) {
                    this.closeConnection(naServer);
                    this.printOut("DEBUG", "NetCluFlshDevTest output is null");
                    return;
                }
                string = naElement2.getChildContent("next-tag");
                int n = naElement2.getChildIntValue("num-records", 0);
                if (n <= 0) {
                    this.printOut("DEBUG", "NetCluFlshDevTest noOfRecords" + n);
                    break;
                }
                List list = naElement2.getChildByName("attributes-list").getChildren();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    NaElement naElement3 = (NaElement)iterator.next();
                    String string2 = naElement3.getChildContent("node");
                    String string3 = naElement3.getChildContent("status");
                    long l = naElement3.getChildLongValue("percent-online", 0L);
                    System.out.println("node:" + string2 + " status:" + string3 + " per_online:" + l);
                    arrayList = new ArrayList();
                    if (string3.equals("online")) {
                        arrayList.add(new Double(0.0));
                    } else if (string3.equals("offline_failed")) {
                        arrayList.add(new Double(1.0));
                    } else if (string3.equals("offline_threshold")) {
                        arrayList.add(new Double(2.0));
                    }
                    arrayList.add(new Double(l));
                    this.addNewMeasure(string2, arrayList);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluFlshDevTest error occured in computeMeasure ", exception.toString());
            this.printOut("Error", "NetCluFlshDevTest error occured in computeMeasure" + exception.toString());
            exception.printStackTrace();
        }
        this.closeConnection(naServer);
    }

    public static void main(String[] stringArray) {
        NetCluFlshDevTest netCluFlshDevTest = new NetCluFlshDevTest(stringArray);
        netCluFlshDevTest.computeMeasures(new Hashtable());
    }
}

