/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.eg.EgSSL;
import com.egurkha.util.EgUtilities;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MerakiClientBase
extends GenericTest {
    protected String apiKey = "";
    protected boolean isSSL = false;
    private boolean ssl_enabled = false;
    protected String url_string = "";
    private static final String ORGANIZATIONS_URI = "organizations";
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    protected static Hashtable totalClientHash = new Hashtable();
    private static Hashtable lastTimeHash = new Hashtable();
    private static String gSync = new String("gSync");
    private static Hashtable syncHash = new Hashtable();
    private String sync = new String("Meraki_Sync1");
    private long lastTime = 0L;
    private double measurePeriodFromMillis = this.measurePeriod / 1000L;
    EgUtilities egutil = EgUtilities.createInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MerakiClientBase(String[] stringArray) {
        super(stringArray);
        String string;
        this.needAgentlessDD = true;
        try {
            this.apiKey = this.getValueForParam("api_key");
            string = this.getValueForParam("ssl");
            if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                this.isSSL = true;
            }
            this.url_string = this.isSSL ? "https://" + this.targetHost + "/api/v0/" : "http://" + this.targetHost + "/api/v0/";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = gSync;
        synchronized (string) {
            String string2 = (String)syncHash.get(this.reportingName);
            if (string2 == null) {
                string2 = new String(this.reportingName);
                syncHash.put(this.reportingName, string2);
                this.setLastExectionTime();
            }
            this.sync = (String)syncHash.get(this.reportingName);
        }
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        this.lastTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectMetrics() {
        String string = this.sync;
        synchronized (string) {
            this.getLastExectionTime();
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            long l3 = (long)(0.9 * (double)this.measurePeriod);
            boolean bl = false;
            if (l2 >= l3) {
                bl = true;
                this.lastTime = l;
                this.setLastExectionTime();
            } else {
                bl = false;
            }
            if (bl) {
                this.collectClientList();
                this.lastTime = System.currentTimeMillis();
                this.setLastExectionTime();
            }
        }
    }

    private String getJSONDataFromURL(String string, boolean bl) {
        String string2 = this.url_string + string;
        return this.getJSONDataFromURL(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJSONDataFromURL(String string) {
        HttpURLConnection httpURLConnection = null;
        String string2 = null;
        try {
            Object object;
            StringBuilder stringBuilder;
            Object object2;
            Object object3;
            if (this.isSSL && !this.ssl_enabled) {
                object3 = EgSSL.getInstance();
                EgSSL.enableSSL();
                object2 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var6_7 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                stringBuilder = null;
                object = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init((KeyManager[])stringBuilder, (TrustManager[])object, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                this.ssl_enabled = true;
            }
            object3 = new URL(string);
            httpURLConnection = (HttpURLConnection)((URL)object3).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(500);
            httpURLConnection.addRequestProperty("X-Cisco-Meraki-API-Key", this.apiKey);
            httpURLConnection.addRequestProperty("Content-Type", "application/json");
            httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.connect();
            object2 = new ConnectionThread(httpURLConnection, false);
            int n = 0;
            boolean bl = this.checkForTimeout((ConnectionThread)object2);
            stringBuilder = new StringBuilder();
            if (bl) {
                n = ((ConnectionThread)object2).code;
                if (n != 200 && string.endsWith(ORGANIZATIONS_URI)) {
                    this.putErrorMessageToLogfile("Error in getJSONDataFromURL method REST url connection ..." + n);
                } else {
                    this.putInfoMessageToLogfile("Error in getJSONDataFromURL method REST url connection ..." + n);
                }
                object = ((ConnectionThread)object2).data;
                if ((object == null || ((ArrayList)object).isEmpty() || ((ArrayList)object).size() == 0) && string.endsWith(ORGANIZATIONS_URI)) {
                    this.putWarningMessageToLogfile(" Data null or empty data");
                } else {
                    this.putInfoMessageToLogfile(" Data null or empty data");
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    stringBuilder.append((String)((ArrayList)object).get(i));
                }
            }
            if ((!bl || n != 200) && string.endsWith(ORGANIZATIONS_URI)) {
                this.putWarningMessageToLogfile(" Timing out or invalid response code:" + n);
            } else {
                this.putInfoMessageToLogfile(" Timing out or invalid response code:" + n);
            }
            string2 = stringBuilder.toString();
        }
        catch (Exception exception) {
            this.putErrorMessageToLogfile("Error in getJSONDataFromURL " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            httpURLConnection = null;
        }
        return string2;
    }

    public void collectClientList() {
        Hashtable hashtable = new Hashtable();
        try {
            Hashtable hashtable2 = this.deviceHash();
            String string = "";
            if (hashtable2 != null && hashtable2.size() > 0) {
                Hashtable hashtable3 = (Hashtable)hashtable2.get("devices");
                Enumeration enumeration = hashtable3.keys();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                Hashtable hashtable4 = new Hashtable();
                Hashtable hashtable5 = new Hashtable();
                Hashtable hashtable6 = new Hashtable();
                Hashtable hashtable7 = new Hashtable();
                Hashtable hashtable8 = new Hashtable();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (enumeration.hasMoreElements()) {
                    String string9 = (String)enumeration.nextElement();
                    ArrayList arrayList2 = (ArrayList)hashtable3.get(string9);
                    String string10 = (String)arrayList2.get(0);
                    String string11 = (String)arrayList2.get(1);
                    String string12 = (String)arrayList2.get(2);
                    String string13 = "";
                    if (string11 == null || string11.equals("-")) {
                        string11 = string12;
                    }
                    if (string9.indexOf("^") > -1) {
                        string13 = string9.substring(0, string9.indexOf("^"));
                    }
                    String string14 = string13 + ":" + string11;
                    if (string9 != null && string9.indexOf("^") > -1) {
                        string = string9.substring(string9.indexOf("^") + 1, string9.trim().length());
                    }
                    String string15 = this.getJSONDataFromURL("devices/" + string + "/clients?timespan=300", true);
                    JSONArray jSONArray = null;
                    try {
                        jSONArray = new JSONArray(string15);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    JSONObject jSONObject = null;
                    JSONObject jSONObject2 = null;
                    if (jSONArray != null && jSONArray.length() > 0) {
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            jSONObject2 = jSONArray.getJSONObject(i);
                            jSONObject = this.getJSONObjectFromJSONObject(jSONObject2, "usage");
                            string6 = this.getValueFromJSONObject(jSONObject, "sent");
                            string7 = this.getValueFromJSONObject(jSONObject, "recv");
                            string2 = this.getValueFromJSONObject(jSONObject2, "id");
                            string3 = this.getValueFromJSONObject(jSONObject2, "description");
                            string4 = this.getValueFromJSONObject(jSONObject2, "mac");
                            string5 = this.getValueFromJSONObject(jSONObject2, "ip");
                            string8 = this.getValueFromJSONObject(jSONObject2, "switchport");
                            arrayList = new ArrayList();
                            arrayList.add(string6);
                            arrayList.add(string7);
                            arrayList.add(string2);
                            arrayList.add(string4);
                            arrayList.add(string5);
                            arrayList.add(string8);
                            String string16 = "";
                            string16 = string3 == null || string3.equals("-") ? string14 + "/" + string4 : string14 + "/" + string3;
                            if (string10.startsWith("MS") || string10.startsWith("ms")) {
                                hashtable4.put(string16, arrayList);
                            }
                            if (string10.startsWith("MR") || string10.startsWith("mr")) {
                                hashtable5.put(string16, arrayList);
                            }
                            if (string10.startsWith("MX") || string10.startsWith("mx") || string10.startsWith("vMX")) {
                                hashtable6.put(string16, arrayList);
                            }
                            if (string10.startsWith("MV") || string10.startsWith("mv")) {
                                hashtable7.put(string16, arrayList);
                            }
                            if (!string10.startsWith("MC") && !string10.startsWith("mc")) continue;
                            hashtable8.put(string16, arrayList);
                        }
                    } else {
                        ArrayList arrayList3 = new ArrayList();
                        if (string10.startsWith("MS")) {
                            hashtable4.put(string14, arrayList3);
                        }
                        if (string10.startsWith("MR")) {
                            hashtable5.put(string14, arrayList3);
                        }
                        if (string10.startsWith("MX") || string10.startsWith("vMX")) {
                            hashtable6.put(string14, arrayList3);
                        }
                        if (string10.startsWith("MV") || string10.startsWith("mv")) {
                            hashtable7.put(string14, arrayList3);
                        }
                        if (!string10.startsWith("MC") && !string10.startsWith("mc")) continue;
                        hashtable8.put(string14, arrayList3);
                    }
                    hashtable.put("Switch", hashtable4);
                    hashtable.put("Wireless", hashtable5);
                    hashtable.put("Security", hashtable6);
                }
            }
            totalClientHash.put(this.reportingName, hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable deviceHash() {
        String string = "deviceList";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        try {
            Object object;
            String string7;
            String string8;
            String string9;
            String string10;
            string6 = this.getJSONDataFromURL(ORGANIZATIONS_URI, true);
            if (string6 == null) {
                return null;
            }
            JSONArray jSONArray = null;
            try {
                jSONArray = new JSONArray(string6);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JSONObject jSONObject = null;
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    jSONObject = jSONArray.getJSONObject(i);
                    string2 = this.getValueFromJSONObject(jSONObject, "id");
                    string3 = this.getValueFromJSONObject(jSONObject, "name");
                    string10 = this.getJSONDataFromURL("organizations/" + string2 + "/networks", true);
                    if (string10 == null) {
                        return null;
                    }
                    string9 = null;
                    try {
                        string9 = new JSONArray(string10);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    string8 = null;
                    for (int j = 0; j < string9.length(); ++j) {
                        string8 = string9.getJSONObject(j);
                        string5 = this.getValueFromJSONObject((JSONObject)string8, "id");
                        string4 = this.getValueFromJSONObject((JSONObject)string8, "name");
                        string7 = string2 + ":" + string5;
                        object = "NETWORK_ID:" + string5 + " NETWORK_NAME:" + string4;
                        hashtable.put(string7, string4);
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            String string11 = "";
            string10 = "";
            string9 = "";
            string8 = "";
            String string12 = "";
            string7 = "";
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string13 = (String)object.nextElement();
                String string14 = (String)hashtable.get(string13);
                if (string13 == null || string13.indexOf(":") <= -1 || (string11 = string13.substring(string13.indexOf(":") + 1, string13.trim().length()).trim()) == null) continue;
                String string15 = this.getJSONDataFromURL("networks/" + string11 + "/devices", true);
                if (string15 == null) {
                    return null;
                }
                JSONArray jSONArray2 = null;
                try {
                    jSONArray2 = new JSONArray(string15);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                JSONObject jSONObject2 = null;
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    jSONObject2 = jSONArray2.getJSONObject(i);
                    string10 = this.getValueFromJSONObject(jSONObject2, "serial");
                    string9 = this.getValueFromJSONObject(jSONObject2, "name");
                    string7 = this.getValueFromJSONObject(jSONObject2, "model");
                    string12 = this.getValueFromJSONObject(jSONObject2, "mac");
                    string11 = this.getValueFromJSONObject(jSONObject2, "networkId");
                    String string16 = string14 + "^" + string10;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string7);
                    arrayList.add(string9);
                    arrayList.add(string12);
                    arrayList.add(string11);
                    hashtable2.put(string16, arrayList);
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable3.put("devices", hashtable2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable3;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get(string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (JSONException jSONException) {
            string2 = "-";
            jSONException.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get(string);
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return jSONObject2;
    }
}

