/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class IgniteValidator
extends EgServerValidator {
    protected String jndiName = "jmxrmi";
    protected String jvmPort = "";
    protected String userName = "";
    protected String password = "";
    protected String reportingName = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    protected MBeanServerConnection beanServerConnection = null;
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected boolean isSSL = false;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASIC = "Basic" + SPACE;
    protected static long collectionTimeout = 120L;
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "IgniteValidator";
    protected static final String LOG_FILE_NAME = "IgniteValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "IgniteValidatorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "IgniteValidatorLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double debugLogSizeLimitInMB = 1048576.0;
    String protoType = "";
    boolean deep_debug = false;
    String port = null;
    String tmp_timeout = null;
    String entity = this.getClass().getName();
    EgUtilities egutil = EgUtilities.createInstance();
    String javaOptions = "java";
    String heapDumpPath = null;
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public boolean isFromManager = false;
    String className = this.getClass().getName();

    public IgniteValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                    this.host = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-port")) {
                    if (this.port != null && this.port.trim().length() != 0 && !this.port.equalsIgnoreCase(NULL) && !this.port.equalsIgnoreCase(NONE)) continue;
                    this.port = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-Jmx_Remote_Port")) {
                    this.jvmPort = string4.trim();
                    if (this.isStringNull(this.jvmPort)) {
                        this.logMessage = string + "JMX JVM Port  is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        this.jvmPort = NONE;
                        continue;
                    }
                    this.logMessage = string + "JMX JVM Port " + this.jvmPort;
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-Jmx_user")) {
                    this.userName = string4.trim();
                    if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase(NULL) || this.userName.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "JMX User  is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        this.userName = NONE;
                        continue;
                    }
                    this.logMessage = string + "JMX User name " + this.userName;
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-Jmx_password")) {
                    if ((string4 = EgCrypt.decrypt(string4)).indexOf("~EG~") != -1) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                    this.password = string4;
                    if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "JMX Password  is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        this.password = NONE;
                        continue;
                    }
                    this.logMessage = string + "JMX password  : *********";
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string3 == null || !string3.equalsIgnoreCase("-rptname")) continue;
                this.reportingName = string4.trim();
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            this.strLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
            if (this.strLogSizeLimitInMB != null && this.strLogSizeLimitInMB.length() > 0) {
                this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
                try {
                    this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                    this.debugLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.debugLogSizeLimitInMB = 1048576.0;
                }
            } else {
                this.debugLogSizeLimitInMB = 1048576.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "Ignite host           :" + this.host);
        this.printOut(string + "Ignite port           :" + this.port);
        this.printOut(string + "Ignite JMX port       :" + this.jvmPort);
        this.printOut(string + "Ignite username       :" + this.userName);
        this.printOut(string + "Ignite password       :**********");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "JMX Port$#$NA");
        } else if (!this.isSpecificPortReachable(this.jvmPort)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "JMX Port$#$JMX Port " + this.jvmPort + " is down or listener is down");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "JMX Port$#$OK");
            this.checkIgniteConnectivity();
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public void checkIgniteConnectivity() {
        String string = "checkIgniteConnectivity";
        string = this.methodNameTemplate(string);
        String string2 = "";
        try {
            Object object;
            String string3 = "service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.jvmPort + "/jmxrmi";
            JMXServiceURL jMXServiceURL = null;
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            try {
                jMXServiceURL = new JMXServiceURL(string3);
            }
            catch (Exception exception) {
                this.putErrorMessageToLogfile(string + "JMXServiceURL : " + string3);
                this.putErrorMessageToLogfile(string + "Error in JMXServiceURL " + exception);
                this.disconnect();
                this.validationMsgs.add(2, "Ignite Connectivity$#$Connection is not established");
                return;
            }
            if (this.userName.equalsIgnoreCase(NONE) && this.password.equalsIgnoreCase(NONE)) {
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(jMXServiceURL);
                    this.printOut(string + "jmxConnector " + this.jmxConnector);
                }
                catch (Exception exception) {
                    this.printOut(string + "JMX connection error with user/pass : none/none " + exception);
                    this.isSSL = true;
                }
            } else {
                hashMap.put("jmx.remote.credentials", new String[]{this.userName, this.password});
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
                }
                catch (Exception exception) {
                    this.putErrorMessageToLogfile("Error in jmxConnector " + exception);
                    this.isSSL = true;
                }
            }
            if (this.isSSL) {
                try {
                    object = new SslRMIClientSocketFactory();
                    Registry registry = LocateRegistry.getRegistry(this.host, Integer.parseInt(this.jvmPort), (RMIClientSocketFactory)object);
                    RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                    this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                    this.rmiConnector.connect(hashMap);
                    this.beanServerConnection = this.rmiConnector.getMBeanServerConnection();
                }
                catch (Exception exception) {
                    this.printOut(string + "JMX connection error in SSL " + exception);
                    this.disconnect();
                    this.validationMsgs.add(2, "Ignite Connectivity$#$Error due to invalid credentials");
                    return;
                }
            }
            try {
                this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
                this.printOut(string + "beanServerConnection : " + this.beanServerConnection);
            }
            catch (Exception exception) {
                this.printOut(string + "JMX connection error in beanServerConnection " + exception);
                this.disconnect();
                this.validationMsgs.add(2, "Ignite Connectivity$#$Connection is not established");
                return;
            }
            if (this.beanServerConnection == null) {
                this.printOut("beanServerConnection  is null ,Connection to JMX Agent is not established ");
                this.putErrorMessageToLogfile("beanServerConnection  is null ,Connection to JMX Agent is not established ");
                this.disconnect();
                this.validationMsgs.add(2, "Ignite Connectivity$#$Connection is not established");
                return;
            }
            try {
                this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
                object = this.beanServerConnection.queryNames(null, null);
                this.printOut(string + "beanSet" + object);
                this.validationMsgs.add(2, "Ignite Connectivity$#$OK");
                this.disconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.validationMsgs.add(2, "Ignite Connectivity$#$Connection is not established");
                return;
            }
        }
        catch (Exception exception) {
            exception.getMessage();
        }
    }

    protected void disconnect() {
        String string = "disconnect";
        string = this.methodNameTemplate(string);
        try {
            if (this.beanServerConnection != null) {
                this.beanServerConnection = null;
            }
        }
        catch (Exception exception) {
            this.printOut("Error in closing beanServerConnection");
            this.putErrorMessageToLogfile("Error in closing beanServerConnection");
            return;
        }
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
        }
        catch (Exception exception) {
            this.printOut("Error in closing connection in jmxConnector");
            this.putErrorMessageToLogfile("Error in closing connection in jmxConnector");
            return;
        }
        try {
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            this.printOut("Error in closing connection in rmiConnector");
            this.putErrorMessageToLogfile("Error in closing connection in rmiConnector");
            return;
        }
    }

    protected boolean isStringNull(String string) {
        return string == "" || string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            IgniteValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            IgniteValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            IgniteValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            IgniteValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            IgniteValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        IgniteValidator igniteValidator = new IgniteValidator(stringArray, new Boolean(false));
        igniteValidator.getValidationMsgs();
    }
}

