/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class ISCSIConnStatsTest
extends NAUSDBase {
    private static final int measureCount = 5;
    private boolean iscsiinit = true;
    private boolean iscsiconn = true;
    private boolean iscisession = true;

    public ISCSIConnStatsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = this.getConnection();
        if (naServer == null) {
            return;
        }
        int n = -5;
        int n2 = -5;
        int n3 = -5;
        int n4 = -5;
        int n5 = this.getLoginDetails(naServer);
        ArrayList arrayList = this.getExistingDetail(naServer);
        ArrayList arrayList2 = this.getSessionDetail(naServer);
        this.closeConnection(naServer);
        if (arrayList != null && arrayList.size() > 0) {
            n = (Integer)arrayList.get(0);
            n2 = (Integer)arrayList.get(1);
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            n3 = (Integer)arrayList2.get(0);
            n4 = (Integer)arrayList2.get(1);
        }
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        arrayList3.add(new Double(n5));
        arrayList3.add(new Double(n));
        arrayList3.add(new Double(n2));
        arrayList3.add(new Double(n3));
        arrayList3.add(new Double(n4));
        this.addNewMeasure(arrayList3);
    }

    private int getLoginDetails(NaServer naServer) {
        int n = -5;
        try {
            NaElement naElement = new NaElement("iscsi-initiator-list-info");
            Object object = this.execONTAPIlog(naServer, naElement);
            NaAPIFailedException naAPIFailedException = null;
            NaElement naElement2 = null;
            if (object instanceof Exception) {
                if (object instanceof NaAPIFailedException) {
                    naAPIFailedException = (NaAPIFailedException)object;
                    int n2 = naAPIFailedException.getErrno();
                    if (13008 == n2) {
                        if (this.iscsiinit) {
                            this.logToErrorFile("INFO", "ISCSIConnStatsTest", "NaAPIFailedException[iscsi-initiator-list-info] This test cannot be monitored without ISCSI License");
                            this.iscsiinit = false;
                        }
                    } else {
                        this.logToErrorFile("INFO", "ISCSIConnStatsTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                    }
                } else {
                    this.logToErrorFile("INFO", "ISCSIConnStatsTest", "Exception" + object.toString());
                }
            } else {
                naElement2 = (NaElement)object;
                NaElement naElement3 = naElement2.getChildByName("iscsi-initiator-list-entries");
                List list = naElement3.getChildren();
                n = list.size();
            }
        }
        catch (Exception exception) {
            n = -5;
        }
        return n;
    }

    private ArrayList getExistingDetail(NaServer naServer) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NaElement naElement = new NaElement("iscsi-connection-list-info");
        Object object = this.execONTAPIlog(naServer, naElement);
        NaAPIFailedException naAPIFailedException = null;
        NaElement naElement2 = null;
        if (object instanceof Exception) {
            if (object instanceof NaAPIFailedException) {
                naAPIFailedException = (NaAPIFailedException)object;
                int n = naAPIFailedException.getErrno();
                if (13008 == n) {
                    if (this.iscsiconn) {
                        this.logToErrorFile("INFO", "ISCSIConnStatsTest", "NaAPIFailedException[iscsi-connection-list-info] This test cannot be monitored without ISCSI License");
                        this.iscsiconn = false;
                    }
                } else {
                    this.logToErrorFile("INFO", "ISCSIConnStatsTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                }
            } else {
                this.logToErrorFile("INFO", "ISCSIConnStatsTest", "Exception" + object.toString());
            }
        } else {
            naElement2 = (NaElement)object;
            NaElement naElement3 = naElement2.getChildByName("iscsi-connection-list-entries");
            List list = naElement3.getChildren();
            int n = list.size();
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string = naElement4.getChildContent("has-session");
                if (!string.equals("false")) continue;
                ++n2;
            }
            arrayList.add(new Integer(n));
            arrayList.add(new Integer(n2));
        }
        return arrayList;
    }

    private ArrayList getSessionDetail(NaServer naServer) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NaElement naElement = new NaElement("iscsi-session-list-info");
        Object object = this.execONTAPIlog(naServer, naElement);
        NaAPIFailedException naAPIFailedException = null;
        NaElement naElement2 = null;
        if (object instanceof Exception) {
            if (object instanceof NaAPIFailedException) {
                naAPIFailedException = (NaAPIFailedException)object;
                int n = naAPIFailedException.getErrno();
                if (13008 == n) {
                    if (this.iscisession) {
                        this.logToErrorFile("INFO", "ISCSIConnStatsTest", "NaAPIFailedException[iscsi-session-list-info] This test cannot be monitored without ISCSI License");
                        this.iscisession = false;
                    }
                } else {
                    this.logToErrorFile("INFO", "ISCSIConnStatsTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                }
            } else {
                this.logToErrorFile("INFO", "ISCSIConnStatsTest", "Exception" + object.toString());
            }
        } else {
            naElement2 = (NaElement)object;
            NaElement naElement3 = naElement2.getChildByName("iscsi-session-list-entries");
            List list = naElement3.getChildren();
            Iterator iterator = list.iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string = naElement4.getChildContent("session-type");
                if (string.equals("normal")) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            arrayList.add(new Integer(n));
            arrayList.add(new Integer(n2));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        ISCSIConnStatsTest iSCSIConnStatsTest = new ISCSIConnStatsTest(stringArray);
        while (true) {
            try {
                while (true) {
                    iSCSIConnStatsTest.computeMeasures(new Hashtable());
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

