/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBThreadStTest
extends IIBStatisticsAccountingBase {
    private static final int THREAD_STAT_MEASURE_COUNT = 4;

    public IIBThreadStTest(String[] args) {
        super(args);
        this.setMeasureCount(4);
        this.needAgentlessDD = true;
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("THREAD_STATS");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Hashtable intervalData = this.getData("INTERVAL_VALUE");
        Enumeration enu = data.keys();
        double totalElapsedTime = 0.0;
        double totalCPUTime = 0.0;
        double totalInputMessages = 0.0;
        double totalSizeOfInputMessages = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Thread Number  :" + key);
            String intervalDataKey = null;
            double measPeriod = 1.0;
            if (key != null && key.trim().length() > 0) {
                if (key.indexOf("/") > -1) {
                    Enumeration enu1 = intervalData.keys();
                    while (enu1.hasMoreElements()) {
                        String key1;
                        String tempKey = key1 = (String)enu1.nextElement();
                        if (key1.indexOf("/") > -1) {
                            key1 = key1.substring(0, key1.indexOf("/"));
                        } else {
                            measPeriod = this.timeSinceLastTest;
                        }
                        String key2 = key.substring(0, key.indexOf("/"));
                        if (!key2.equals(key1)) continue;
                        intervalDataKey = tempKey;
                    }
                    this.printOut("intervalDataKey  :" + intervalDataKey);
                    ArrayList intervalArrayList = (ArrayList)intervalData.get(intervalDataKey);
                    measPeriod = (Double)intervalArrayList.get(0);
                    this.printOut("Execution group name :" + intervalDataKey + "  statistic collection time " + measPeriod);
                } else {
                    measPeriod = this.timeSinceLastTest;
                    this.printOut("Execution group name not found for this  " + intervalDataKey + "  statistic collection time is assigned time since last measure period value ");
                }
            }
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            totalElapsedTime = (Double)tempArrayList.get(0);
            totalCPUTime = (Double)tempArrayList.get(1);
            totalInputMessages = (Double)tempArrayList.get(2);
            totalSizeOfInputMessages = (Double)tempArrayList.get(3);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            if (totalInputMessages > 0.0) {
                this.printOut("DEEP DEBUGS :Node name :" + key + " totalInputMessages  " + totalInputMessages);
                double avgElapsedTime = (totalElapsedTime /= 1000000.0) / totalInputMessages;
                double avgCPUTime = (totalCPUTime /= 1000000.0) / totalInputMessages;
                measureArrayList.add(new Double(avgElapsedTime));
                measureArrayList.add(new Double(avgCPUTime));
                if (EgTest.debug) {
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Average ElapsedTime(" + avgElapsedTime + ")is derived from totalElapsedTime(" + totalElapsedTime + ") / totalInputMessages(" + totalInputMessages + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Average CPUTime(" + avgCPUTime + ")is derived from totalCPUTime(" + totalCPUTime + ") / totalInputMessages(" + totalInputMessages + ")");
                }
            } else {
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
            }
            if (measPeriod > 0.0) {
                double inputMessageRate = totalInputMessages / measPeriod;
                double messageDataRate = totalSizeOfInputMessages / measPeriod;
                if (EgTest.debug) {
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Input MessageRate(" + inputMessageRate + ")is derived from totalInputMessages(" + totalInputMessages + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Message DataRate(" + messageDataRate + ")is derived from totalSizeOfInputMessages(" + totalSizeOfInputMessages + ") / Statistics interval(" + measPeriod + ")");
                }
                measureArrayList.add(new Double(inputMessageRate));
                measureArrayList.add(new Double(messageDataRate));
            } else {
                this.printOut("DEEP DEBUGS :Thread name :" + key + " measPeriod  is zero ,So assinging default values  ");
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
            }
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBThreadStTest obj = new IIBThreadStTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

