/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBJVMMemTest
extends IIBResourceStatisticsBase {
    private static final int JVM_MEMORY_STAT_MEASURE_COUNT = 9;

    public IIBJVMMemTest(String[] args) {
        super(args);
        this.setMeasureCount(9);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("JVM_Memory");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Enumeration enu = data.keys();
        double committedMemory = 0.0;
        double usedMemory = 0.0;
        double maxMemory = 0.0;
        double usedPCTOfCommittedMemory = 0.0;
        double usedPCTOfMaxConfMemory = 0.0;
        double freeInCommittedMemory = 0.0;
        double freeInMaxConfMemory = 0.0;
        double freePCTCommittedMemory = 0.0;
        double freePCTMaxConfMemory = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Node name  :" + key);
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            committedMemory = (Double)tempArrayList.get(0);
            usedMemory = (Double)tempArrayList.get(1);
            maxMemory = (Double)tempArrayList.get(2);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            usedPCTOfCommittedMemory = usedMemory / committedMemory * 100.0;
            freeInCommittedMemory = committedMemory - usedMemory;
            freePCTCommittedMemory = freeInCommittedMemory / committedMemory * 100.0;
            if (maxMemory > 0.0) {
                usedPCTOfMaxConfMemory = usedMemory / maxMemory * 100.0;
                freeInMaxConfMemory = maxMemory - usedMemory;
                freePCTMaxConfMemory = freeInMaxConfMemory / maxMemory * 100.0;
            } else {
                maxMemory = -5.0;
                usedPCTOfMaxConfMemory = -5.0;
                freeInMaxConfMemory = -5.0;
                freePCTMaxConfMemory = -5.0;
            }
            measureArrayList.add(new Double(committedMemory));
            measureArrayList.add(new Double(usedMemory));
            measureArrayList.add(new Double(maxMemory));
            measureArrayList.add(new Double(usedPCTOfCommittedMemory));
            measureArrayList.add(new Double(usedPCTOfMaxConfMemory));
            measureArrayList.add(new Double(freeInCommittedMemory));
            measureArrayList.add(new Double(freeInMaxConfMemory));
            measureArrayList.add(new Double(freePCTCommittedMemory));
            measureArrayList.add(new Double(freePCTMaxConfMemory));
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBJVMMemTest obj = new IIBJVMMemTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

