/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBJDBCStatTest
extends IIBResourceStatisticsBase {
    private static final int JDBC_CONNECTION_POOL_STAT_MEASURE_COUNT = 7;

    public IIBJDBCStatTest(String[] args) {
        super(args);
        this.setMeasureCount(7);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("JDBCConnectionPools");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Enumeration enu = data.keys();
        double actualSizeOfPool = 0.0;
        double maxSizeOfPool = 0.0;
        double cumulativeRequests = 0.0;
        double cumulativeDelayedRequests = 0.0;
        double cumulativeTimedOutRequests = 0.0;
        double maxDelayInMilliseconds = 0.0;
        double connectionPoolUsagePCT = 0.0;
        double freeConnections = 0.0;
        double requestHandledRate = 0.0;
        double connectionWaitRequestRate = 0.0;
        double connectionTimeOutRequestRate = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Node name  :" + key);
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            actualSizeOfPool = (Double)tempArrayList.get(0);
            maxSizeOfPool = (Double)tempArrayList.get(1);
            cumulativeRequests = (Double)tempArrayList.get(2);
            cumulativeDelayedRequests = (Double)tempArrayList.get(3);
            cumulativeTimedOutRequests = (Double)tempArrayList.get(4);
            maxDelayInMilliseconds = (Double)tempArrayList.get(5);
            connectionPoolUsagePCT = actualSizeOfPool / maxSizeOfPool * 100.0;
            freeConnections = maxSizeOfPool - actualSizeOfPool;
            if (this.timeSinceLastTest > 0.0) {
                requestHandledRate = cumulativeRequests / this.timeSinceLastTest;
                connectionWaitRequestRate = cumulativeDelayedRequests / this.timeSinceLastTest;
                connectionTimeOutRequestRate = cumulativeTimedOutRequests / this.timeSinceLastTest;
            } else {
                this.printOut("WARNING : timeSinceLastTest value less than zero");
                requestHandledRate = -5.0;
                connectionWaitRequestRate = -5.0;
                connectionTimeOutRequestRate = -5.0;
            }
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            measureArrayList.add(new Double(actualSizeOfPool));
            measureArrayList.add(new Double(connectionPoolUsagePCT));
            measureArrayList.add(new Double(freeConnections));
            measureArrayList.add(new Double(requestHandledRate));
            measureArrayList.add(new Double(connectionWaitRequestRate));
            measureArrayList.add(new Double(connectionTimeOutRequestRate));
            measureArrayList.add(new Double(maxDelayInMilliseconds));
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBJDBCStatTest obj = new IIBJDBCStatTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

