/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IBMDb2DirectIOTest
extends GenericTest {
    private static final int MEASURES_COUNT = 3;
    private String user;
    private String password;
    private String dbName;
    private Hashtable prevValues = null;
    private ArrayList activeDatabases;
    private String ssl = "";

    public IBMDb2DirectIOTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.prevValues = new Hashtable();
        this.ssl = this.getValueForParam("ssl");
        this.ssl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("y") || this.ssl.trim().equalsIgnoreCase("yes")) ? "true" : "false";
    }

    public static void main(String[] stringArray) {
        IBMDb2DirectIOTest iBMDb2DirectIOTest = new IBMDb2DirectIOTest(stringArray);
        iBMDb2DirectIOTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getIoStats();
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getIoStats() {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        if (this.ssl.equalsIgnoreCase("true")) {
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName, this.ssl);
            connection = dB2JdbcHelper.getConnection();
        } else {
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
        }
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT DB_NAME, DIRECT_READS, DIRECT_WRITES, POOL_DATA_P_READS, POOL_DATA_WRITES, POOL_INDEX_P_READS, POOL_INDEX_WRITES FROM TABLE(" + string + ") AS T";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            this.activeDatabases = new ArrayList();
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString("DB_NAME");
                d4 = resultSet.getDouble("DIRECT_READS");
                d5 = resultSet.getDouble("DIRECT_WRITES");
                d6 = resultSet.getDouble("POOL_DATA_P_READS");
                d7 = resultSet.getDouble("POOL_DATA_WRITES");
                d8 = resultSet.getDouble("POOL_INDEX_P_READS");
                d9 = resultSet.getDouble("POOL_INDEX_WRITES");
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.prevValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(6);
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d8));
                    arrayList2.add(new Double(d9));
                } else {
                    double d10 = (Double)arrayList2.get(0);
                    double d11 = (Double)arrayList2.get(1);
                    double d12 = (Double)arrayList2.get(2);
                    double d13 = (Double)arrayList2.get(3);
                    double d14 = (Double)arrayList2.get(4);
                    double d15 = (Double)arrayList2.get(5);
                    double d16 = d6 - d12 + (d7 - d13) + (d8 - d14) + (d9 - d15);
                    if (this.timeSinceLastTest > 0.0) {
                        d = (d4 - d10) / this.timeSinceLastTest;
                        d2 = (d5 - d11) / this.timeSinceLastTest;
                        d3 = d16 / this.timeSinceLastTest;
                    } else {
                        d = 0.0;
                        d2 = 0.0;
                        d3 = 0.0;
                    }
                    arrayList2.set(0, new Double(d4));
                    arrayList2.set(1, new Double(d5));
                    arrayList2.set(2, new Double(d6));
                    arrayList2.set(3, new Double(d7));
                    arrayList2.set(4, new Double(d8));
                    arrayList2.set(5, new Double(d9));
                }
                this.prevValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(3);
                arrayList.add(new Double(d >= 0.0 ? d : -5.0));
                arrayList.add(new Double(d2 >= 0.0 ? d2 : -5.0));
                arrayList.add(new Double(d3 >= 0.0 ? d3 : -5.0));
                hashtable.put(string3, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured in IBMDb2DirectIOTest " + exception);
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        ArrayList<Double> arrayList = new ArrayList<Double>(3);
        for (int i = 0; i < 3; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

