/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IBMChasFuelGugeTest
extends EgSnmpGenericTest {
    boolean isFirst = true;

    public IBMChasFuelGugeTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
        this.setMeasureCount(6);
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasures(".1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.2");
            Hashtable hashtable3 = this.getMeasures(".1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.3");
            Hashtable hashtable4 = this.getMeasures(".1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.7");
            Hashtable hashtable5 = this.getMeasures(".1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.8");
            Hashtable hashtable6 = this.getMeasures(".1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.9");
            Hashtable hashtable7 = this.getMeasures(".1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.10");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info :", "IBMChasFuelGugeTest No Powermodule available for ", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable3.get(string);
                String string4 = (String)hashtable4.get(string);
                String string5 = (String)hashtable5.get(string);
                String string6 = (String)hashtable6.get(string);
                String string7 = (String)hashtable7.get(string);
                String string8 = "";
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                if (string2 != null) {
                    string8 = "PowerDomain " + string2;
                }
                d = string3 != null ? this.getPowerState(string3) : -5.0;
                d2 = string4 != null ? this.getPowerValue(string4) : -5.0;
                d3 = string5 != null ? this.getPowerValue(string5) : -5.0;
                d4 = string6 != null ? this.getPowerValue(string6) : -5.0;
                d5 = string7 != null ? this.getPowerValue(string7) : -5.0;
                if (d4 > 0.0 && d5 >= 0.0) {
                    d6 = (d4 - d5) / d4 * 100.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                this.addNewMeasure(string8, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "IBMChasFuelGugeTest Exception occured in computeMeasures for ", this.targetHost);
            exception.printStackTrace();
        }
    }

    private double getPowerValue(String string) {
        double d = -5.0;
        try {
            if (string.toLowerCase().indexOf("w") > -1) {
                String string2 = string.substring(0, string.toLowerCase().indexOf("w"));
                d = Double.parseDouble(string2);
            } else {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "IBMChasFuelGugeTest Exception occured in getPowerValue method for ", this.targetHost);
            d = -5.0;
        }
        return d;
    }

    private double getPowerState(String string) {
        double d = -5.0;
        try {
            if (string.indexOf("-") > -1) {
                String string2 = string.substring(0, string.indexOf("-"));
                d = Double.parseDouble(string2.trim());
            } else {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "IBMChasFuelGugeTest Exception occured in getPowerState method for ", this.targetHost);
            d = -5.0;
        }
        return d;
    }

    private Hashtable getMeasures(String string) {
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.lhs[i].trim();
                    if (this.rhs[i] != null && this.rhs[i].trim().length() > 0) {
                        string3 = this.rhs[i].trim();
                        hashtable.put(string2, string3);
                        continue;
                    }
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "IBMChasFuelGugeTest Error occured in getMeasures for ", this.targetHost);
            exception.printStackTrace();
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        IBMChasFuelGugeTest iBMChasFuelGugeTest = new IBMChasFuelGugeTest(stringArray);
        iBMChasFuelGugeTest.computeMeasures(new Hashtable());
    }
}

