/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HpEvaSystemTest
extends GenericTest {
    EgHpEvaSanHelper hpCntlr = null;

    public HpEvaSystemTest(String[] stringArray) {
        super(stringArray);
        this.hpCntlr = new EgHpEvaSanHelper(stringArray);
        this.setMeasureCount(4);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.hpCntlr.setData();
        ArrayList arrayList = this.hpCntlr.getSystemData();
        if (arrayList == null || arrayList.size() < 1) {
            this.logToErrorFile("Error", "HpEvaSystemTest.computeMeasures", "Controller Status data not available");
            return;
        }
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string == null || string.trim().length() == 0) continue;
            if ((string = string.toUpperCase().trim()).startsWith("OBJECTNAME")) {
                bl = true;
                continue;
            }
            if (bl && string.startsWith("OPERATIONALSTATE ")) {
                String string2 = this.getRHS(string);
                if (string2.equals("GOOD") || string2.equals("ATTENTION") || string2.equals("NORMAL")) {
                    d4 = 1.0;
                    continue;
                }
                if (string2.equals("FAILED") || string2.equals("BAD")) {
                    d4 = 0.0;
                    continue;
                }
                d4 = 2.0;
                continue;
            }
            if (bl && string.startsWith("TOTALSTORAGESPACE")) {
                try {
                    d = Double.parseDouble(this.getRHS(string));
                }
                catch (Exception exception) {
                    d = -5.0;
                }
                continue;
            }
            if (bl && string.startsWith("USEDSTORAGESPACE")) {
                try {
                    d2 = Double.parseDouble(this.getRHS(string));
                }
                catch (Exception exception) {
                    d2 = -5.0;
                }
                continue;
            }
            if (bl && string.startsWith("AVAILABLESTORAGESPACE")) {
                try {
                    d3 = Double.parseDouble(this.getRHS(string));
                }
                catch (Exception exception) {
                    d3 = -5.0;
                }
                continue;
            }
            if (!bl || !string.startsWith("OSUNITID")) continue;
            double d5 = 0.0;
            try {
                d5 = d3 * 100.0 / d;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(new Double(d4));
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(d5));
            if (this.hpCntlr.debug) {
                System.out.println("[HpEvaSystemTest] ==> " + arrayList2);
            }
            this.addNewMeasure(arrayList2);
            d = -5.0;
            d2 = -5.0;
            d3 = -5.0;
            d4 = -5.0;
            bl = false;
        }
    }

    private String getRHS(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken().trim();
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void main(String[] stringArray) {
        HpEvaSystemTest hpEvaSystemTest = new HpEvaSystemTest(stringArray);
        hpEvaSystemTest.computeMeasures(new Hashtable());
    }
}

