/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class HanaDbUptimeTest
extends GenericTest {
    private static final int UPTIME_MEASURE_COUNT = 1;
    private String userName = "";
    private String password = "";
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;
    private String installdir = "";
    private Hashtable prevHashUptime = new Hashtable();
    private Hashtable curUptime = new Hashtable();
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);

    public HanaDbUptimeTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.installdir = EgInstallInfo.getInstallDir() + "/agent/logs/hanadbuptime_" + this.targetHost + "_" + this.portNo + ".log";
        this.f = new File(this.installdir);
        this.fixedTestPeriod = true;
        this.isDynamicInfoTest = true;
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.##");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block32: {
            String string;
            double d;
            double d2;
            String string2;
            double d3;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            Statement statement;
            ResultSet resultSet;
            Object object;
            block31: {
                if (this.checkHostName) {
                    ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    object = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                    if (object != null && ((ArrayList)object).size() > 0) {
                        this.hostNameToFilter = (String)((ArrayList)object).get(0);
                        this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                        this.checkHostName = false;
                    } else {
                        this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        return;
                    }
                }
                System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                object = null;
                resultSet = null;
                statement = null;
                string7 = "";
                string6 = "";
                string5 = "";
                string4 = "";
                string3 = "";
                d3 = 0.0;
                string2 = "";
                d2 = 0.0;
                d = 0.0;
                double d4 = 0.0;
                this.prevHashUptime = new Hashtable();
                this.curUptime = new Hashtable();
                string = "select database_name, host, to_char(start_time,'YYYY/MM/DD HH24:MI:SS') start_time,  to_char(current_timestamp,'YYYY/MM/DD HH24:MI:SS')  time, version,seconds_between (start_time,current_timestamp)  uptime_sec from m_database where lower(host)='" + this.hostNameToFilter + "'";
                System.out.println(this.entity + "==>Query:" + string + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                object = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                if (object != null) break block31;
                this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                statement = object.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                this.closeSt(statement);
                this.closeConn((Connection)object);
                exception.printStackTrace();
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string7 = resultSet.getString(1).trim();
                string6 = resultSet.getString(2);
                string5 = resultSet.getString(3);
                string4 = resultSet.getString(4);
                string2 = resultSet.getString(5);
                string3 = resultSet.getString(6);
                d3 = this.getDoubleValue(string3);
                d3 /= 60.0;
                d3 = this.roundDouble(d3);
                String string8 = Double.toString(d3);
                this.curUptime.put(string7, new String(string8));
                this.readDoubleFromFile();
                String string9 = (String)this.prevHashUptime.get(string7);
                if (string9 == null) {
                    System.out.println("Previous uptime is null in HanaDBUptimeTest");
                } else {
                    d = Double.parseDouble(string9);
                    if (d3 < d) {
                        d2 = 1.0;
                    }
                }
                this.writeDoubleToFile();
                if (debug) {
                    System.out.println(" Up time " + d3);
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d3));
                if (this.measureCount > 1) {
                    arrayList.add(new Double(d2));
                }
                this.addNewMeasure(string7, arrayList);
            }
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn((Connection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block32;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + sQLException.toString());
                sQLException.printStackTrace();
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block32;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + exception.toString());
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs(resultSet);
                            this.closeSt(statement);
                            this.closeConn((Connection)object);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            return d;
        }
        try {
            string = string.trim();
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDoubleFromFile() {
        try {
            if (!this.f.exists()) {
                return;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            String string = null;
            while ((string = this.dis.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.prevHashUptime.put(string2, new String(string3));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dis.close();
            }
            catch (Exception exception) {}
            this.dis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoubleToFile() {
        try {
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            Enumeration enumeration = this.curUptime.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.curUptime.get(string);
                String string3 = string + "=" + string2;
                this.dos.writeBytes(string3);
                this.dos.writeBytes("\n");
                this.dos.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
            }
            catch (Exception exception) {}
            this.dos = null;
        }
    }

    public static void main(String[] stringArray) {
        HanaDbUptimeTest hanaDbUptimeTest = new HanaDbUptimeTest(stringArray);
        hanaDbUptimeTest.computeMeasures(new Hashtable());
    }
}

